/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMapHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.BaseStateImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpecificLeafTest {
    @Test
    public void checkByteBufferLeafs() {
        int bytes = 128;
        ByteBuffer bb = ByteBuffer.allocate(bytes);
        bb.order(ByteOrder.nativeOrder());
        Memory mem = Memory.wrap((ByteBuffer)bb).region(0L, (long)bytes, ByteOrder.nativeOrder());
        Assert.assertTrue((boolean)((BaseStateImpl)mem).isBBType());
        Assert.assertTrue((boolean)mem.isReadOnly());
        SpecificLeafTest.checkCrossLeafTypeIds(mem);
        Buffer buf = mem.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
        bb.order(Util.NON_NATIVE_BYTE_ORDER);
        Memory mem2 = Memory.wrap((ByteBuffer)bb).region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf2 = mem2.asBuffer().region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf3 = buf2.duplicate();
        Assert.assertTrue((boolean)((BaseStateImpl)mem).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)mem2).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf2).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf3).isDuplicateType());
    }

    @Test
    public void checkDirectLeafs() throws Exception {
        int bytes = 128;
        try (WritableHandle h = WritableMemory.allocateDirect((long)bytes);){
            WritableMemory wmem = h.getWritable();
            Assert.assertTrue((boolean)((BaseStateImpl)wmem).isDirectType());
            Assert.assertFalse((boolean)wmem.isReadOnly());
            SpecificLeafTest.checkCrossLeafTypeIds((Memory)wmem);
            WritableMemory nnwmem = wmem.writableRegion(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
            Memory mem = wmem.region(0L, (long)bytes, ByteOrder.nativeOrder());
            Buffer buf = mem.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
            Memory mem2 = nnwmem.region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf2 = mem2.asBuffer().region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf3 = buf2.duplicate();
            Assert.assertTrue((boolean)((BaseStateImpl)mem).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)mem2).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf2).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf3).isDuplicateType());
        }
    }

    @Test
    public void checkMapLeafs() throws Exception {
        File file = new File("TestFile2.bin");
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        long bytes = 128L;
        try (WritableMapHandle h = WritableMemory.writableMap((File)file, (long)0L, (long)128L, (ByteOrder)ByteOrder.nativeOrder());){
            WritableMemory mem = h.getWritable();
            Assert.assertTrue((boolean)((BaseStateImpl)mem).isMapType());
            Assert.assertFalse((boolean)mem.isReadOnly());
            SpecificLeafTest.checkCrossLeafTypeIds((Memory)mem);
            Memory nnreg = mem.region(0L, 128L, Util.NON_NATIVE_BYTE_ORDER);
            Memory reg = mem.region(0L, 128L, ByteOrder.nativeOrder());
            Buffer buf = reg.asBuffer().region(0L, 128L, ByteOrder.nativeOrder());
            Buffer buf4 = buf.duplicate();
            Memory reg2 = nnreg.region(0L, 128L, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf2 = reg2.asBuffer().region(0L, 128L, Util.NON_NATIVE_BYTE_ORDER);
            Buffer buf3 = buf2.duplicate();
            Assert.assertTrue((boolean)((BaseStateImpl)reg).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)reg2).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf2).isRegionType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf3).isDuplicateType());
            Assert.assertTrue((boolean)((BaseStateImpl)buf4).isDuplicateType());
        }
    }

    @Test
    public void checkHeapLeafs() {
        int bytes = 128;
        Memory mem = Memory.wrap((byte[])new byte[bytes]);
        Assert.assertTrue((boolean)((BaseStateImpl)mem).isHeapType());
        Assert.assertTrue((boolean)((BaseStateImpl)mem).isReadOnlyType());
        SpecificLeafTest.checkCrossLeafTypeIds(mem);
        Memory nnreg = mem.region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Memory reg = mem.region(0L, (long)bytes, ByteOrder.nativeOrder());
        Buffer buf = reg.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
        Buffer buf4 = buf.duplicate();
        Memory reg2 = nnreg.region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf2 = reg2.asBuffer().region(0L, (long)bytes, Util.NON_NATIVE_BYTE_ORDER);
        Buffer buf3 = buf2.duplicate();
        Assert.assertFalse((boolean)((BaseStateImpl)mem).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)reg2).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf2).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf3).isDuplicateType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf4).isDuplicateType());
    }

    private static void checkCrossLeafTypeIds(Memory mem) {
        Memory reg1 = mem.region(0L, mem.getCapacity());
        Assert.assertTrue((boolean)((BaseStateImpl)reg1).isRegionType());
        Buffer buf1 = reg1.asBuffer();
        Assert.assertTrue((boolean)((BaseStateImpl)buf1).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf1).isBufferType());
        Assert.assertTrue((boolean)buf1.isReadOnly());
        Buffer buf2 = buf1.duplicate();
        Assert.assertTrue((boolean)((BaseStateImpl)buf2).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf2).isBufferType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf2).isDuplicateType());
        Assert.assertTrue((boolean)buf2.isReadOnly());
        Memory mem2 = buf1.asMemory();
        Assert.assertTrue((boolean)((BaseStateImpl)mem2).isRegionType());
        Assert.assertFalse((boolean)((BaseStateImpl)mem2).isBufferType());
        Assert.assertFalse((boolean)((BaseStateImpl)mem2).isDuplicateType());
        Assert.assertTrue((boolean)mem2.isReadOnly());
        Buffer buf3 = buf1.duplicate(Util.NON_NATIVE_BYTE_ORDER);
        Assert.assertTrue((boolean)((BaseStateImpl)buf3).isRegionType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf3).isBufferType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf3).isDuplicateType());
        Assert.assertTrue((boolean)((BaseStateImpl)buf3).isNonNativeType());
        Assert.assertTrue((boolean)buf3.isReadOnly());
        Memory mem3 = buf3.asMemory();
        Assert.assertTrue((boolean)((BaseStateImpl)mem3).isRegionType());
        Assert.assertFalse((boolean)((BaseStateImpl)mem3).isBufferType());
        Assert.assertTrue((boolean)((BaseStateImpl)mem3).isDuplicateType());
        Assert.assertTrue((boolean)((BaseStateImpl)mem3).isNonNativeType());
        Assert.assertTrue((boolean)mem3.isReadOnly());
    }
}

