/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonNativeWritableMemoryImplTest {
    private byte[] bArr = new byte[8];
    private final WritableMemory wmem = WritableMemory.writableWrap((byte[])this.bArr, (ByteOrder)ByteOrder.BIG_ENDIAN);

    @Test
    public void checkCharacters() {
        int i;
        int m = 2;
        int n = 0x100000 / m + m;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        for (i = 0; i < n; ++i) {
            wmem1.putChar((long)(i * m), (char)i++);
        }
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((char)wmem1.getChar((long)(i * m)), (char)((char)i++));
        }
        char[] cArr = new char[n];
        wmem1.getCharArray(0L, cArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        wmem2.putCharArray(0L, cArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkDoubles() {
        int i;
        int m = 8;
        int n = 0x100000 / m + m;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        double dbl = 1.0;
        for (i = 0; i < n; ++i) {
            double d = dbl;
            dbl = d + 1.0;
            wmem1.putDouble((long)(i * m), d);
        }
        dbl = 1.0;
        for (i = 0; i < n; ++i) {
            double d = dbl;
            dbl = d + 1.0;
            Assert.assertEquals((double)wmem1.getDouble((long)(i * m)), (double)d);
        }
        double[] dblArr = new double[n];
        wmem1.getDoubleArray(0L, dblArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        wmem2.putDoubleArray(0L, dblArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkFloats() {
        int i;
        int m = 4;
        int n = 0x100000 / m + m;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        float flt = 1.0f;
        for (i = 0; i < n; ++i) {
            float f = flt;
            flt = f + 1.0f;
            wmem1.putFloat((long)(i * m), f);
        }
        flt = 1.0f;
        for (i = 0; i < n; ++i) {
            float f = flt;
            flt = f + 1.0f;
            Assert.assertEquals((float)wmem1.getFloat((long)(i * m)), (float)f);
        }
        float[] fltArr = new float[n];
        wmem1.getFloatArray(0L, fltArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        wmem2.putFloatArray(0L, fltArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkInts() {
        int i;
        int m = 4;
        int n = 0x100000 / m + m;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        int intg = 1;
        for (i = 0; i < n; ++i) {
            wmem1.putInt((long)(i * m), intg++);
        }
        intg = 1;
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((int)wmem1.getInt((long)(i * m)), (int)intg++);
        }
        int[] intArr = new int[n];
        wmem1.getIntArray(0L, intArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        wmem2.putIntArray(0L, intArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkLongs() {
        int i;
        int m = 8;
        int n = 0x100000 / m + m;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        long lng = 1L;
        for (i = 0; i < n; ++i) {
            wmem1.putLong((long)(i * m), lng++);
        }
        lng = 1L;
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((long)wmem1.getLong((long)(i * m)), (long)lng++);
        }
        long[] longArr = new long[n];
        wmem1.getLongArray(0L, longArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        wmem2.putLongArray(0L, longArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void checkShorts() {
        int i;
        int m = 2;
        int n = 0x100000 / m + m;
        byte[] arr1 = new byte[n * m];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])arr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        short sht = 1;
        for (i = 0; i < n; ++i) {
            short s = sht;
            sht = (short)(sht + 1);
            wmem1.putShort((long)(i * m), s);
        }
        sht = 1;
        for (i = 0; i < n; ++i) {
            short s = sht;
            sht = (short)(sht + 1);
            Assert.assertEquals((short)wmem1.getShort((long)(i * m)), (short)s);
        }
        short[] shortArr = new short[n];
        wmem1.getShortArray(0L, shortArr, 0, n);
        byte[] arr2 = new byte[n * m];
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])arr2, (ByteOrder)ByteOrder.BIG_ENDIAN);
        wmem2.putShortArray(0L, shortArr, 0, n);
        Assert.assertEquals((byte[])arr2, (byte[])arr1);
    }

    @Test
    public void testGetAndAddLong() {
        this.wmem.getAndAddLong(0L, 1L);
        try {
            this.wmem.getAndAddLong(1L, 1L);
            throw new RuntimeException("Expected AssertionError");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testGetAndSetLong() {
        this.wmem.getAndSetLong(0L, 1L);
        try {
            this.wmem.getAndSetLong(1L, 1L);
            throw new RuntimeException("Expected AssertionError");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testCompareAndSwapLong() {
        this.wmem.compareAndSwapLong(0L, 0L, 1L);
        try {
            this.wmem.compareAndSwapLong(1L, 0L, 1L);
            throw new RuntimeException("Expected AssertionError");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void checkRegion() {
        WritableMemory wreg = this.wmem.writableRegion(0L, this.wmem.getCapacity());
        Assert.assertEquals((Object)wreg.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void checkRegionZeros() {
        byte[] bArr1 = new byte[]{};
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])bArr1, (ByteOrder)ByteOrder.BIG_ENDIAN);
        Memory reg = wmem1.region(0L, wmem1.getCapacity());
        Assert.assertEquals((Object)reg.getTypeByteOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
    }
}

