/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.internal.NioBits;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NioBitsTest {
    @Test
    public void checkVMParams() {
        NioBitsTest.println("Max MemoryImpl: " + NioBits.getMaxDirectByteBufferMemory());
        NioBitsTest.println("Page Aligned: " + NioBits.isPageAligned());
        NioBitsTest.println("Page Size: " + NioBits.pageSize());
    }

    @Test
    public void checkGetAtomicFields() {
        long cap = 1024L;
        NioBitsTest.printStats();
        NioBits.reserveMemory((long)cap, (long)cap);
        NioBitsTest.printStats();
        NioBits.unreserveMemory((long)cap, (long)cap);
        NioBitsTest.printStats();
    }

    @Test
    public void checkPageCount() {
        Assert.assertEquals((int)NioBits.pageCount((long)0L), (int)0);
        Assert.assertEquals((int)NioBits.pageCount((long)1L), (int)1);
    }

    private static void printStats() {
        long count = NioBits.getDirectAllocationsCount();
        long resMem = NioBits.getReservedMemory();
        long totCap = NioBits.getTotalCapacity();
        long maxDBBmem = NioBits.getMaxDirectByteBufferMemory();
        String s = String.format("%,10d\t%,15d\t%,15d\t%,15d", count, resMem, totCap, maxDBBmem);
        NioBitsTest.println(s);
    }

    @Test
    public void printlnTest() {
        NioBitsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

