/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MemoryWriteToTest {
    @Test
    public void testOnHeap() throws IOException {
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(0));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(7));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(1023));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(10000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(0x500000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomBytesMemory(0x50000A));
    }

    @Test
    public void testOnHeapInts() throws IOException {
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(0));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(7));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(1023));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(10000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(0x500000));
        MemoryWriteToTest.testWriteTo(MemoryWriteToTest.createRandomIntsMemory(0x50000A));
    }

    @Test
    public void testOffHeap() throws Exception {
        try (WritableHandle handle = WritableMemory.allocateDirect((long)0x50000AL);){
            WritableMemory mem = handle.getWritable();
            MemoryWriteToTest.testWriteTo(mem.region(0L, 0L));
            MemoryWriteToTest.testOffHeap(mem, 7);
            MemoryWriteToTest.testOffHeap(mem, 1023);
            MemoryWriteToTest.testOffHeap(mem, 10000);
            MemoryWriteToTest.testOffHeap(mem, 0x500000);
            MemoryWriteToTest.testOffHeap(mem, 0x50000A);
        }
    }

    private static void testOffHeap(WritableMemory mem, int size) throws IOException {
        MemoryWriteToTest.createRandomBytesMemory(size).copyTo(0L, mem, 0L, (long)size);
        MemoryWriteToTest.testWriteTo(mem.region(0L, (long)size));
    }

    private static Memory createRandomBytesMemory(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Memory.wrap((byte[])bytes);
    }

    private static Memory createRandomIntsMemory(int size) {
        int[] ints = ThreadLocalRandom.current().ints(size).toArray();
        return Memory.wrap((int[])ints);
    }

    private static void testWriteTo(Memory mem) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (WritableByteChannel out = Channels.newChannel(baos);){
            mem.writeTo(0L, mem.getCapacity(), out);
        }
        byte[] result = baos.toByteArray();
        Assert.assertTrue((boolean)mem.equals(Memory.wrap((byte[])result)));
    }
}

