/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExampleMemoryRequestServerTest {
    @Test
    public void checkExampleMemoryRequestServer1() throws Exception {
        int bytes = 8;
        ExampleMemoryRequestServer svr = new ExampleMemoryRequestServer();
        try (WritableHandle wh = WritableMemory.allocateDirect((long)8L);){
            WritableMemory memStart = wh.getWritable();
            WritableMemory wMem = svr.request(memStart, bytes);
            MemoryClient client = new MemoryClient(wMem);
            client.process();
            svr.cleanup();
        }
    }

    @Test
    public void checkExampleMemoryRequestServer2() throws Exception {
        int bytes = 8;
        ExampleMemoryRequestServer svr = new ExampleMemoryRequestServer();
        try (WritableHandle handle = WritableMemory.allocateDirect((long)bytes, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)svr);){
            WritableMemory memStart = handle.getWritable();
            MemoryClient client = new MemoryClient(memStart);
            client.process();
            svr.cleanup();
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkZeroCapacity() throws Exception {
        ExampleMemoryRequestServer svr = new ExampleMemoryRequestServer();
        WritableHandle wh = WritableMemory.allocateDirect((long)0L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)svr);
        Throwable throwable = null;
        if (wh != null) {
            if (throwable != null) {
                try {
                    wh.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                wh.close();
            }
        }
    }

    @Test
    public void printlnTest() {
        ExampleMemoryRequestServerTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    public static class ExampleMemoryRequestServer
    implements MemoryRequestServer {
        IdentityHashMap<WritableMemory, WritableHandle> map = new IdentityHashMap();

        public WritableMemory request(WritableMemory currentWMem, long capacityBytes) {
            ByteOrder order = currentWMem.getTypeByteOrder();
            WritableHandle handle = WritableMemory.allocateDirect((long)capacityBytes, (ByteOrder)order, (MemoryRequestServer)this);
            WritableMemory wmem = handle.getWritable();
            this.map.put(wmem, handle);
            return wmem;
        }

        public void requestClose(WritableMemory memToRelease, WritableMemory newMemory) {
            WritableHandle handle = this.map.get(memToRelease);
            if (handle != null && handle.getWritable() == memToRelease) {
                try {
                    handle.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void cleanup() {
            this.map.forEach((k, v) -> {
                Assert.assertFalse((boolean)k.isValid());
                try {
                    v.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    static class MemoryClient {
        WritableMemory smallMem;
        MemoryRequestServer svr;

        MemoryClient(WritableMemory memStart) {
            this.smallMem = memStart;
            this.svr = memStart.getMemoryRequestServer();
        }

        void process() {
            long cap1 = this.smallMem.getCapacity();
            this.smallMem.fill((byte)1);
            ExampleMemoryRequestServerTest.println(this.smallMem.toHexString("Small", 0L, (int)cap1));
            WritableMemory bigMem = this.svr.request(this.smallMem, 2L * cap1);
            long cap2 = bigMem.getCapacity();
            this.smallMem.copyTo(0L, bigMem, 0L, cap1);
            this.svr.requestClose(this.smallMem, bigMem);
            bigMem.fill(cap1, cap1, (byte)2);
            ExampleMemoryRequestServerTest.println(bigMem.toHexString("Big", 0L, (int)cap2));
            WritableMemory giantMem = this.svr.request(bigMem, 2L * cap2);
            long cap3 = giantMem.getCapacity();
            bigMem.copyTo(0L, giantMem, 0L, cap2);
            this.svr.requestClose(bigMem, giantMem);
            giantMem.fill(cap2, cap2, (byte)3);
            ExampleMemoryRequestServerTest.println(giantMem.toHexString("Giant", 0L, (int)cap3));
            this.svr.requestClose(giantMem, null);
        }
    }
}

