/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DruidIssue11544Test {
    @Test
    public void withByteBuffer() {
        int initialLongs = 1000;
        int size1 = initialLongs * 8;
        ByteBuffer bb = ByteBuffer.allocateDirect(size1);
        bb.order(ByteOrder.nativeOrder());
        WritableMemory mem1 = WritableMemory.writableWrap((ByteBuffer)bb);
        Assert.assertTrue((boolean)mem1.isDirect());
        MemoryRequestServer svr = mem1.getMemoryRequestServer();
        if (svr == null) {
            svr = new DefaultMemoryRequestServer();
        }
        Assert.assertNotNull((Object)svr);
        int size2 = size1 * 2;
        WritableMemory mem2 = svr.request(mem1, (long)size2);
        Assert.assertFalse((boolean)mem2.isDirect());
        Assert.assertEquals((long)mem2.getCapacity(), (long)size2);
        mem1.copyTo(0L, mem2, 0L, (long)size1);
        svr.requestClose(mem1, mem2);
        Assert.assertTrue((boolean)mem1.isValid());
        Assert.assertTrue((boolean)mem2.isValid());
        int size3 = size2 * 2;
        WritableMemory mem3 = svr.request(mem2, (long)size3);
        Assert.assertFalse((boolean)mem3.isDirect());
        Assert.assertEquals((long)mem3.getCapacity(), (long)size3);
        mem2.copyTo(0L, mem3, 0L, (long)size2);
        svr.requestClose(mem2, mem3);
        Assert.assertTrue((boolean)mem2.isValid());
        Assert.assertTrue((boolean)mem3.isValid());
    }
}

