/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CopyMemoryOverlapTest {
    @Test
    public void checkOverlapUsingMemory() throws Exception {
        long copyLongs = 0x100000L;
        double overlap = 0.5;
        long start_mS = System.currentTimeMillis();
        CopyMemoryOverlapTest.copyUsingDirectMemory(copyLongs, overlap, true);
        long end1_mS = System.currentTimeMillis();
        CopyMemoryOverlapTest.copyUsingDirectMemory(copyLongs, overlap, false);
        long end2_mS = System.currentTimeMillis();
        CopyMemoryOverlapTest.println("CopyUp Time Sec: " + (double)(end1_mS - start_mS) / 1000.0);
        CopyMemoryOverlapTest.println("CopyDn Time Sec: " + (double)(end2_mS - end1_mS) / 1000.0);
    }

    @Test
    public void checkOverlapUsingRegions() throws Exception {
        long copyLongs = 0x100000L;
        double overlap = 0.5;
        long start_mS = System.currentTimeMillis();
        CopyMemoryOverlapTest.copyUsingDirectRegions(copyLongs, overlap, true);
        long end1_mS = System.currentTimeMillis();
        CopyMemoryOverlapTest.copyUsingDirectRegions(copyLongs, overlap, false);
        long end2_mS = System.currentTimeMillis();
        CopyMemoryOverlapTest.println("CopyUp Time Sec: " + (double)(end1_mS - start_mS) / 1000.0);
        CopyMemoryOverlapTest.println("CopyDn Time Sec: " + (double)(end2_mS - end1_mS) / 1000.0);
    }

    private static final void copyUsingDirectMemory(long copyLongs, double overlap, boolean copyUp) throws Exception {
        long toOffsetLongs;
        long fromOffsetLongs;
        CopyMemoryOverlapTest.println("Copy Using Direct Memory");
        long overlapLongs = (long)(overlap * (double)copyLongs);
        long backingLongs = 2L * copyLongs - overlapLongs;
        if (copyUp) {
            fromOffsetLongs = 0L;
            toOffsetLongs = copyLongs - overlapLongs;
        } else {
            fromOffsetLongs = copyLongs - overlapLongs;
            toOffsetLongs = 0L;
        }
        long backingBytes = backingLongs << 3;
        long copyBytes = copyLongs << 3;
        long fromOffsetBytes = fromOffsetLongs << 3;
        long toOffsetBytes = toOffsetLongs << 3;
        CopyMemoryOverlapTest.println("Copy longs   : " + copyLongs + "\t bytes: " + copyBytes);
        CopyMemoryOverlapTest.println("Overlap      : " + overlap * 100.0 + "%");
        CopyMemoryOverlapTest.println("CopyUp       : " + copyUp);
        CopyMemoryOverlapTest.println("Backing longs: " + backingLongs + "\t bytes: " + backingBytes);
        try (WritableHandle backHandle = WritableMemory.allocateDirect((long)backingBytes);){
            WritableMemory backingMem = backHandle.getWritable();
            CopyMemoryOverlapTest.fill(backingMem);
            backingMem.copyTo(fromOffsetBytes, backingMem, toOffsetBytes, copyBytes);
            CopyMemoryOverlapTest.checkMemLongs((Memory)backingMem, fromOffsetLongs, toOffsetLongs, copyLongs);
        }
        CopyMemoryOverlapTest.println("");
    }

    private static final void copyUsingDirectRegions(long copyLongs, double overlap, boolean copyUp) throws Exception {
        long toOffsetLongs;
        long fromOffsetLongs;
        CopyMemoryOverlapTest.println("Copy Using Direct Memory");
        long overlapLongs = (long)(overlap * (double)copyLongs);
        long backingLongs = 2L * copyLongs - overlapLongs;
        if (copyUp) {
            fromOffsetLongs = 0L;
            toOffsetLongs = copyLongs - overlapLongs;
        } else {
            fromOffsetLongs = copyLongs - overlapLongs;
            toOffsetLongs = 0L;
        }
        long backingBytes = backingLongs << 3;
        long copyBytes = copyLongs << 3;
        long fromOffsetBytes = fromOffsetLongs << 3;
        long toOffsetBytes = toOffsetLongs << 3;
        CopyMemoryOverlapTest.println("Copy longs   : " + copyLongs + "\t bytes: " + copyBytes);
        CopyMemoryOverlapTest.println("Overlap      : " + overlap * 100.0 + "%");
        CopyMemoryOverlapTest.println("CopyUp       : " + copyUp);
        CopyMemoryOverlapTest.println("Backing longs: " + backingLongs + "\t bytes: " + backingBytes);
        try (WritableHandle backHandle = WritableMemory.allocateDirect((long)backingBytes);){
            WritableMemory backingMem = backHandle.getWritable();
            CopyMemoryOverlapTest.fill(backingMem);
            WritableMemory reg1 = backingMem.writableRegion(fromOffsetBytes, copyBytes);
            WritableMemory reg2 = backingMem.writableRegion(toOffsetBytes, copyBytes);
            reg1.copyTo(0L, reg2, 0L, copyBytes);
            CopyMemoryOverlapTest.checkMemLongs((Memory)reg2, fromOffsetLongs, 0L, copyLongs);
        }
        CopyMemoryOverlapTest.println("");
    }

    private static final void fill(WritableMemory wmem) {
        long longs = wmem.getCapacity() >>> 3;
        for (long i = 0L; i < longs; ++i) {
            wmem.putLong(i << 3, i);
        }
    }

    private static final void checkMemLongs(Memory mem, long fromOffsetLongs, long toOffsetLongs, long copyLongs) {
        for (long i = 0L; i < copyLongs; ++i) {
            long memVal = mem.getLong(toOffsetLongs + i << 3);
            Assert.assertEquals((long)memVal, (long)(fromOffsetLongs + i));
        }
    }

    private static final void listMem(Memory mem, String comment) {
        CopyMemoryOverlapTest.println(comment);
        CopyMemoryOverlapTest.println("Idx\tValue");
        long longs = mem.getCapacity() >>> 3;
        for (long i = 0L; i < longs; ++i) {
            CopyMemoryOverlapTest.println(i + "\t" + mem.getLong(i << 3));
        }
    }

    @Test
    public void printlnTest() {
        CopyMemoryOverlapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

