/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.BaseStateImpl;
import org.apache.datasketches.memory.internal.Prim;
import org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BaseStateTest {
    @Test
    public void checkPrimOffset() {
        int off = (int)Prim.BYTE.off();
        Assert.assertTrue((off > 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkIsSameResource() {
        WritableBuffer wbuf;
        WritableMemory wmem;
        WritableMemory mem = wmem = WritableMemory.allocate((int)16);
        Assert.assertFalse((boolean)wmem.isSameResource(null));
        Assert.assertTrue((boolean)wmem.isSameResource((Object)mem));
        WritableBuffer buf = wbuf = wmem.asWritableBuffer();
        Assert.assertFalse((boolean)wbuf.isSameResource(null));
        Assert.assertTrue((boolean)wbuf.isSameResource((Object)buf));
    }

    @Test
    public void checkNotEqualTo() {
        byte[] arr = new byte[8];
        Memory mem = Memory.wrap((byte[])arr);
        Assert.assertFalse((boolean)mem.equalTo(0L, (Object)arr, 0L, 8L));
    }

    @Test
    public void checkStepBoolean() {
        BaseStateTest.checkStepBoolean(true);
        BaseStateTest.checkStepBoolean(false);
    }

    private static void checkStepBoolean(boolean initialState) {
        StepBoolean step = new StepBoolean(initialState);
        Assert.assertTrue((step.get() == initialState ? 1 : 0) != 0);
        step.change();
        Assert.assertTrue((boolean)step.hasChanged());
        Assert.assertTrue((step.get() != initialState ? 1 : 0) != 0);
        step.change();
        Assert.assertTrue((step.get() != initialState ? 1 : 0) != 0);
        Assert.assertTrue((boolean)step.hasChanged());
    }

    @Test
    public void checkPrim() {
        Assert.assertEquals((long)Prim.DOUBLE.scale(), (long)8L);
    }

    @Test
    public void checkGetNativeBaseOffset_Heap() throws Exception {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        long offset = ((BaseStateImpl)wmem).getNativeBaseOffset();
        Assert.assertEquals((long)offset, (long)0L);
    }

    @Test
    public void checkIsByteOrderCompatible() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        Assert.assertTrue((boolean)wmem.isByteOrderCompatible(ByteOrder.nativeOrder()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkByteOrderNull() {
        Util.isNativeByteOrder(null);
        Assert.fail();
    }

    @Test
    public void checkIsNativeByteOrder() {
        Assert.assertTrue((boolean)BaseStateImpl.isNativeByteOrder((ByteOrder)ByteOrder.nativeOrder()));
        try {
            BaseStateImpl.isNativeByteOrder(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkXxHash64() {
        WritableMemory mem = WritableMemory.allocate((int)8);
        long out = mem.xxHash64(mem.getLong(0L), 1L);
        Assert.assertTrue((out != 0L ? 1 : 0) != 0);
    }

    @Test
    public void checkTypeDecode() {
        for (int i = 0; i < 128; ++i) {
            BaseStateImpl.typeDecode((int)i);
        }
    }

    @Test
    public void printlnTest() {
        BaseStateTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

