/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BaseBufferTest {
    @Test
    public void checkLimits() {
        Buffer buf = Memory.wrap((byte[])new byte[100]).asBuffer();
        buf.setStartPositionEnd(40L, 45L, 50L);
        buf.setStartPositionEnd(0L, 0L, 100L);
        try {
            buf.setStartPositionEnd(0L, 0L, 101L);
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void checkLimitsAndCheck() {
        Buffer buf = Memory.wrap((byte[])new byte[100]).asBuffer();
        buf.setAndCheckStartPositionEnd(40L, 45L, 50L);
        buf.setAndCheckStartPositionEnd(0L, 0L, 100L);
        try {
            buf.setAndCheckStartPositionEnd(0L, 0L, 101L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buf.setAndCheckPosition(100L);
        try {
            buf.setAndCheckPosition(101L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buf.setPosition(99L);
        buf.incrementAndCheckPosition(1L);
        try {
            buf.incrementAndCheckPosition(1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCheckValid() throws Exception {
        Buffer buf;
        try (WritableHandle hand = WritableMemory.allocateDirect((long)100L);){
            WritableMemory wmem = hand.getWritable();
            buf = wmem.asBuffer();
        }
        try {
            Memory memory = buf.asMemory();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }
}

