/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseState;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.BaseStateImpl;
import org.apache.datasketches.memory.internal.Util;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class AllocateDirectMemoryTest {
    @Test
    public void simpleAllocateDirect() throws Exception {
        WritableMemory wMem;
        int longs = 32;
        try (WritableHandle wh = WritableMemory.allocateDirect((long)(longs << 3));){
            wMem = wh.getWritable();
            for (int i = 0; i < longs; ++i) {
                wMem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)wMem.getLong((long)(i << 3)), (long)i);
            }
            ((BaseStateImpl)wMem).checkValid();
        }
        try {
            ((BaseStateImpl)wMem).checkValid();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void checkDefaultMemoryRequestServer() throws Exception {
        int longs1 = 32;
        int bytes1 = longs1 << 3;
        try (WritableHandle wh = WritableMemory.allocateDirect((long)bytes1);){
            WritableMemory origWmem = wh.getWritable();
            for (int i = 0; i < longs1; ++i) {
                origWmem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)origWmem.getLong((long)(i << 3)), (long)i);
            }
            AllocateDirectMemoryTest.println(origWmem.toHexString("Test", 0L, 256));
            int longs2 = 64;
            int bytes2 = longs2 << 3;
            Object memReqSvr = BaseState.defaultMemReqSvr == null ? new DefaultMemoryRequestServer() : origWmem.getMemoryRequestServer();
            WritableMemory newWmem = memReqSvr.request(origWmem, (long)bytes2);
            Assert.assertFalse((boolean)newWmem.isDirect());
            for (int i = 0; i < longs2; ++i) {
                newWmem.putLong((long)(i << 3), (long)i);
                Assert.assertEquals((long)newWmem.getLong((long)(i << 3)), (long)i);
            }
            memReqSvr.requestClose(origWmem, newWmem);
        }
    }

    @Test
    public void checkNonNativeDirect() throws Exception {
        try (WritableHandle h = WritableMemory.allocateDirect((long)128L, (ByteOrder)Util.NON_NATIVE_BYTE_ORDER, null);){
            WritableMemory wmem = h.getWritable();
            wmem.putChar(0L, '\u0001');
            Assert.assertEquals((byte)wmem.getByte(1L), (byte)1);
        }
    }

    @Test
    public void checkExplicitClose() throws Exception {
        long cap = 128L;
        try (WritableHandle wdh = WritableMemory.allocateDirect((long)128L);){
            wdh.close();
        }
    }

    @AfterClass
    public void checkDirectCounter() {
        WritableMemory.writableWrap((byte[])new byte[8]);
        long count = BaseState.getCurrentDirectMemoryAllocations();
        if (count != 0L) {
            AllocateDirectMemoryTest.println("" + count);
            Assert.fail();
        }
    }

    @Test
    public void printlnTest() {
        AllocateDirectMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

