/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Utf8CodingException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.test.IsValidUtf8TestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Utf8Test {
    static final int min1ByteCP = 0;
    static final int min2ByteCP = 128;
    static final int min3ByteCP = 2048;
    static final int min4ByteCP = 65536;
    static final int minPlane2CP = 131072;
    static final int maxCodePoint = 0x10FFFF;
    static final int minSurr = 55296;
    static final int maxSurr = 57343;

    @Test
    public void testRoundTripAllValidCodePoints() throws IOException {
        for (int cp = 0; cp < 0x10FFFF; ++cp) {
            if (Utf8Test.isSurrogateCodePoint(cp)) continue;
            String refStr = new String(Character.toChars(cp));
            Utf8Test.assertRoundTrips(refStr);
        }
    }

    @Test
    public void testPutInvalidChars() {
        WritableMemory mem = WritableMemory.allocate((int)10);
        WritableMemory emptyMem = WritableMemory.allocate((int)0);
        for (int c = 55296; c <= 57343; ++c) {
            Utf8Test.assertSurrogate(mem, (char)c);
            Utf8Test.assertSurrogate(emptyMem, (char)c);
        }
    }

    private static void assertSurrogate(WritableMemory mem, char c) {
        try {
            mem.putCharsToUtf8(0L, (CharSequence)new String(new char[]{c}));
            Assert.fail();
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPutInvaidSurrogatePairs() {
        WritableMemory mem = WritableMemory.allocate((int)4);
        StringBuilder sb = new StringBuilder();
        sb.append('\ud800');
        sb.append('\udbff');
        try {
            mem.putCharsToUtf8(0L, (CharSequence)sb);
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPutHighBMP() {
        WritableMemory mem = WritableMemory.allocate((int)2);
        StringBuilder sb = new StringBuilder();
        sb.append("\ue000");
        try {
            mem.putCharsToUtf8(0L, (CharSequence)sb);
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPutExtendedAscii() {
        WritableMemory mem = WritableMemory.allocate((int)1);
        StringBuilder sb = new StringBuilder();
        sb.append("\u07ff");
        try {
            mem.putCharsToUtf8(0L, (CharSequence)sb);
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPutOneAsciiToEmpty() {
        WritableMemory mem = WritableMemory.allocate((int)0);
        StringBuilder sb = new StringBuilder();
        sb.append("a");
        try {
            mem.putCharsToUtf8(0L, (CharSequence)sb);
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPutValidSurrogatePair() {
        WritableMemory mem = WritableMemory.allocate((int)4);
        StringBuilder sb = new StringBuilder();
        sb.append('\ud800');
        sb.append('\udc00');
        mem.putCharsToUtf8(0L, (CharSequence)sb);
    }

    @Test
    public void testOneByte() {
        int valid = 0;
        for (int i = -128; i <= 127; ++i) {
            ByteString bs = ByteString.copyFrom((byte[])new byte[]{(byte)i});
            if (!bs.isValidUtf8()) {
                Utf8Test.assertInvalid(bs.toByteArray());
                continue;
            }
            ++valid;
        }
        Assert.assertEquals((long)128L, (long)valid);
    }

    @Test
    public void testTwoBytes() {
        int valid = 0;
        for (int i = -128; i <= 127; ++i) {
            for (int j = -128; j <= 127; ++j) {
                ByteString bs = ByteString.copyFrom((byte[])new byte[]{(byte)i, (byte)j});
                if (!bs.isValidUtf8()) {
                    Utf8Test.assertInvalid(bs.toByteArray());
                    continue;
                }
                ++valid;
            }
        }
        Assert.assertEquals((long)IsValidUtf8TestUtil.EXPECTED_TWO_BYTE_ROUNDTRIPPABLE_COUNT, (long)valid);
    }

    public void testThreeBytes() {
        if (System.getenv("TRAVIS") == null) {
            int count = 0;
            int valid = 0;
            for (int i = -128; i <= 127; ++i) {
                for (int j = -128; j <= 127; ++j) {
                    for (int k = -128; k <= 127; ++k) {
                        byte[] bytes = new byte[]{(byte)i, (byte)j, (byte)k};
                        ByteString bs = ByteString.copyFrom((byte[])bytes);
                        if (!bs.isValidUtf8()) {
                            Utf8Test.assertInvalid(bytes);
                        } else {
                            ++valid;
                        }
                        if ((long)(++count) % 1000000L != 0L) continue;
                        Utf8Test.println("Processed " + (long)count / 1000000L + " million characters");
                    }
                }
            }
            Assert.assertEquals((long)IsValidUtf8TestUtil.EXPECTED_THREE_BYTE_ROUNDTRIPPABLE_COUNT, (long)valid);
        }
    }

    @Test
    public void checkRandomValidCodePoints() {
        Util.RandomCodePoints rcp = new Util.RandomCodePoints(true);
        int numCP = 1000;
        int[] cpArr = new int[numCP];
        rcp.fillCodePointArray(cpArr, 0, 131072);
        String rcpStr = new String(cpArr, 0, numCP);
        WritableMemory wmem = WritableMemory.allocate((int)(4 * numCP));
        int utf8Bytes = (int)wmem.putCharsToUtf8(0L, (CharSequence)rcpStr);
        StringBuilder sb = new StringBuilder();
        try {
            wmem.getCharsFromUtf8(0L, utf8Bytes, (Appendable)sb);
        }
        catch (IOException | Utf8CodingException e) {
            throw new RuntimeException(e);
        }
        Utf8Test.checkStrings(sb.toString(), rcpStr);
        CharBuffer cb = CharBuffer.allocate(rcpStr.length());
        try {
            wmem.getCharsFromUtf8(0L, utf8Bytes, (Appendable)cb);
        }
        catch (IOException | Utf8CodingException e) {
            throw new RuntimeException(e);
        }
        String cbStr = sb.toString();
        Assert.assertEquals((int)cbStr.length(), (int)rcpStr.length());
        Utf8Test.checkStrings(cbStr, rcpStr);
    }

    @Test
    public void checkRandomValidCodePoints2() {
        Util.RandomCodePoints rcp = new Util.RandomCodePoints(false);
    }

    @Test
    public void testInvalid_4BytesSamples() {
        Utf8Test.assertInvalid(240, 164, 173, 127);
        Utf8Test.assertInvalid(240, 164, 173, 192);
        Utf8Test.assertInvalid(240, 143, 173, 162);
        Utf8Test.assertInvalid(244, 144, 173, 162);
    }

    @Test
    public void testRealStrings() throws IOException {
        Utf8Test.assertRoundTrips("The quick brown fox jumps over the lazy dog");
        Utf8Test.assertRoundTrips("Quizdeltagerne spiste jordb\u00e6r med fl\u00f8de, mens cirkusklovnen");
        Utf8Test.assertRoundTrips("\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092");
        Utf8Test.assertRoundTrips("\u05d3\u05d2 \u05e1\u05e7\u05e8\u05df \u05e9\u05d8 \u05d1\u05d9\u05dd \u05de\u05d0\u05d5\u05db\u05d6\u05d1 \u05d5\u05dc\u05e4\u05ea\u05e2 \u05de\u05e6\u05d0 \u05dc\u05d5 \u05d7\u05d1\u05e8\u05d4 \u05d0\u05d9\u05da \u05d4\u05e7\u05dc\u05d9\u05d8\u05d4");
        Utf8Test.assertRoundTrips(" \u0e08\u0e07\u0e1d\u0e48\u0e32\u0e1f\u0e31\u0e19\u0e1e\u0e31\u0e12\u0e19\u0e32\u0e27\u0e34\u0e0a\u0e32\u0e01\u0e32\u0e23");
        Utf8Test.assertRoundTrips("\u8fd4\u56de\u94fe\u4e2d\u7684\u4e0b\u4e00\u4e2a\u4ee3\u7406\u9879\u9009\u62e9\u5668");
        Utf8Test.assertRoundTrips("\ud841\udf0e\ud841\udf31\ud841\udf79\ud843\udc53\ud843\udc78\ud843\udc96\ud843\udccf\ud843\udcd5\ud843\udd15\ud843\udd7c\ud843\udd7f\ud843\ude0e\ud843\ude0f\ud843\ude77\ud843\ude9d\ud843\udea2");
        Utf8Test.assertRoundTrips("The quick brown \u3044\u308d\u306f\u306b\u307b\u3078\u8fd4\u56de\u94fe\u4e2d\u7684\u4e0b\u4e00");
    }

    @Test
    public void checkNonEmptyDestinationForDecode() {
        StringBuilder sb = new StringBuilder();
        sb.append("abc");
        int startChars = sb.toString().toCharArray().length;
        String refStr = "Quizdeltagerne spiste jordb\u00e6r med fl\u00f8de, mens cirkusklovnen";
        byte[] refByteArr = refStr.getBytes(StandardCharsets.UTF_8);
        int addBytes = refByteArr.length;
        WritableMemory refMem = WritableMemory.writableWrap((byte[])refByteArr);
        int decodedChars = refMem.getCharsFromUtf8(0L, addBytes, sb);
        String finalStr = sb.toString();
        int finalChars = finalStr.toCharArray().length;
        Assert.assertEquals((int)(decodedChars + startChars), (int)finalChars);
        Utf8Test.println("Decoded chars: " + decodedChars);
        Utf8Test.println("Final chars: " + finalChars);
        Utf8Test.println(sb.toString());
    }

    @Test
    public void checkNonEmptyDestinationForEncode() {
        String refStr = "Quizdeltagerne spiste jordb\u00e6r med fl\u00f8de, mens cirkusklovnen";
        byte[] refByteArr = refStr.getBytes(StandardCharsets.UTF_8);
        int refBytes = refByteArr.length;
        int offset = 100;
        WritableMemory tgtMem = WritableMemory.allocate((int)(refBytes + offset));
        long bytesEncoded = tgtMem.putCharsToUtf8((long)offset, (CharSequence)refStr);
        Assert.assertEquals((long)bytesEncoded, (long)refBytes);
    }

    @Test
    public void testOverlong() {
        Utf8Test.assertInvalid(192, 175);
        Utf8Test.assertInvalid(224, 128, 175);
        Utf8Test.assertInvalid(240, 128, 128, 175);
        Utf8Test.assertInvalid(193, 191);
        Utf8Test.assertInvalid(224, 159, 191);
        Utf8Test.assertInvalid(240, 143, 191, 191);
        Utf8Test.assertInvalid(192, 128);
        Utf8Test.assertInvalid(224, 128, 128);
        Utf8Test.assertInvalid(240, 128, 128, 128);
    }

    @Test
    public void testIllegalCodepoints() {
        Utf8Test.assertInvalid(237, 160, 128);
        Utf8Test.assertInvalid(237, 173, 191);
        Utf8Test.assertInvalid(237, 174, 128);
        Utf8Test.assertInvalid(237, 175, 191);
        Utf8Test.assertInvalid(237, 176, 128);
        Utf8Test.assertInvalid(237, 190, 128);
        Utf8Test.assertInvalid(237, 191, 191);
        Utf8Test.assertInvalid(237, 160, 128, 237, 176, 128);
        Utf8Test.assertInvalid(237, 160, 128, 237, 191, 191);
        Utf8Test.assertInvalid(237, 173, 191, 237, 176, 128);
        Utf8Test.assertInvalid(237, 173, 191, 237, 191, 191);
        Utf8Test.assertInvalid(237, 174, 128, 237, 176, 128);
        Utf8Test.assertInvalid(237, 174, 128, 237, 191, 191);
        Utf8Test.assertInvalid(237, 175, 191, 237, 176, 128);
        Utf8Test.assertInvalid(237, 175, 191, 237, 191, 191);
    }

    @Test
    public void testBufferSlice() throws IOException {
        String str = "The quick brown fox jumps over the lazy dog";
        Utf8Test.assertRoundTrips(str, 4, 10, 4);
        Utf8Test.assertRoundTrips(str, 0, str.length(), 0);
    }

    @Test
    public void testInvalidBufferSlice() {
        byte[] bytes = "The quick brown fox jumps over the lazy dog".getBytes(StandardCharsets.UTF_8);
        Utf8Test.assertInvalidSlice(bytes, bytes.length - 3, 4);
        Utf8Test.assertInvalidSlice(bytes, bytes.length, 1);
        Utf8Test.assertInvalidSlice(bytes, bytes.length + 1, 0);
        Utf8Test.assertInvalidSlice(bytes, 0, bytes.length + 1);
    }

    private static void assertInvalid(int ... bytesAsInt) {
        byte[] bytes = new byte[bytesAsInt.length];
        for (int i = 0; i < bytesAsInt.length; ++i) {
            bytes[i] = (byte)bytesAsInt[i];
        }
        Utf8Test.assertInvalid(bytes);
    }

    private static void assertInvalid(byte[] bytes) {
        int bytesLen = bytes.length;
        try {
            Memory.wrap((byte[])bytes).getCharsFromUtf8(0L, bytesLen, new StringBuilder());
            Assert.fail();
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
        try {
            CharBuffer cb = CharBuffer.allocate(bytesLen);
            Memory.wrap((byte[])bytes).getCharsFromUtf8(0L, bytesLen, (Appendable)cb);
            Assert.fail();
        }
        catch (IOException | Utf8CodingException throwable) {
            // empty catch block
        }
    }

    private static void assertInvalidSlice(byte[] bytes, int index, int size) {
        try {
            Memory mem = Memory.wrap((byte[])bytes);
            mem.getCharsFromUtf8((long)index, size, new StringBuilder());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void assertRoundTrips(String refStr) throws IOException {
        Utf8Test.assertRoundTrips(refStr, refStr.toCharArray().length, 0, -1);
    }

    private static void assertRoundTrips(String refStr, int refSubCharLen, int offsetBytes, int utf8LengthBytes) throws IOException {
        byte[] refByteArr = refStr.getBytes(StandardCharsets.UTF_8);
        if (utf8LengthBytes == -1) {
            utf8LengthBytes = refByteArr.length;
        }
        Memory refMem = Memory.wrap((byte[])refByteArr);
        byte[] refByteArr2 = new byte[refByteArr.length + 1];
        System.arraycopy(refByteArr, 0, refByteArr2, 1, refByteArr.length);
        Memory refReg = Memory.wrap((byte[])refByteArr2).region(1L, (long)refByteArr.length);
        WritableMemory dstMem = WritableMemory.allocate((int)refByteArr.length);
        WritableMemory dstMem2 = WritableMemory.allocate((int)(refByteArr.length + 1)).writableRegion(1L, (long)refByteArr.length);
        Utf8Test.assertRoundTrips(refStr, refSubCharLen, offsetBytes, utf8LengthBytes, refByteArr, refMem, dstMem);
        Utf8Test.assertRoundTrips(refStr, refSubCharLen, offsetBytes, utf8LengthBytes, refByteArr, refMem, dstMem2);
        Utf8Test.assertRoundTrips(refStr, refSubCharLen, offsetBytes, utf8LengthBytes, refByteArr, refReg, dstMem);
        Utf8Test.assertRoundTrips(refStr, refSubCharLen, offsetBytes, utf8LengthBytes, refByteArr, refReg, dstMem2);
    }

    private static void assertRoundTrips(String refStr, int refSubCharLen, int offsetBytes, int utf8LengthBytes, byte[] refByteArr, Memory refMem, WritableMemory dstMem) throws IOException {
        StringBuilder sb = new StringBuilder();
        int charPos = refMem.getCharsFromUtf8((long)offsetBytes, utf8LengthBytes, sb);
        Utf8Test.checkStrings(sb.toString(), new String(refByteArr, offsetBytes, utf8LengthBytes, StandardCharsets.UTF_8));
        Assert.assertEquals((int)charPos, (int)refSubCharLen);
        CharBuffer cb = CharBuffer.allocate(refByteArr.length + 1);
        cb.position(1);
        cb = cb.slice();
        refMem.getCharsFromUtf8((long)offsetBytes, utf8LengthBytes, (Appendable)cb);
        cb.flip();
        Utf8Test.checkStrings(cb.toString(), new String(refByteArr, offsetBytes, utf8LengthBytes, StandardCharsets.UTF_8));
        long encodedUtf8Bytes = dstMem.putCharsToUtf8(0L, (CharSequence)refStr);
        Assert.assertEquals((long)encodedUtf8Bytes, (long)refByteArr.length);
        Assert.assertEquals((int)0, (int)dstMem.compareTo(0L, (long)refByteArr.length, refMem, 0L, (long)refByteArr.length));
        WritableMemory writeMem2 = WritableMemory.allocate((int)(refByteArr.length - 1));
        try {
            writeMem2.putCharsToUtf8(0L, (CharSequence)refStr);
            Assert.fail();
        }
        catch (Utf8CodingException utf8CodingException) {
            // empty catch block
        }
    }

    private static boolean isSurrogateCodePoint(int cp) {
        return cp >= 55296 && cp <= 57343;
    }

    private static void checkStrings(String actual, String expected) {
        if (!expected.equals(actual)) {
            Assert.fail((String)("Failure: Expected (" + Utf8Test.codepoints(expected) + ") Actual (" + Utf8Test.codepoints(actual) + ")"));
        }
    }

    private static List<String> codepoints(String str) {
        ArrayList<String> codepoints = new ArrayList<String>();
        for (int i = 0; i < str.length(); ++i) {
            codepoints.add(Long.toHexString(str.charAt(i)));
        }
        return codepoints;
    }

    @Test
    public void printlnTest() {
        Utf8Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

