/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.test;

import java.nio.ByteBuffer;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.annotations.Test;

public class BufferReadWriteSafetyTest {
    private final WritableBuffer buf = (WritableBuffer)Buffer.wrap((ByteBuffer)ByteBuffer.allocate(8));

    @Test(expectedExceptions={AssertionError.class})
    public void testPutByte() {
        this.buf.putByte(0L, (byte)1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutBytePositional() {
        this.buf.putByte((byte)1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutBoolean() {
        this.buf.putBoolean(0L, true);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutBooleanPositional() {
        this.buf.putBoolean(true);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutShort() {
        this.buf.putShort(0L, (short)1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutShortPositional() {
        this.buf.putShort((short)1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutChar() {
        this.buf.putChar(0L, '\u0001');
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutCharPositional() {
        this.buf.putChar('\u0001');
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutInt() {
        this.buf.putInt(0L, 1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutIntPositional() {
        this.buf.putInt(1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutLong() {
        this.buf.putLong(0L, 1L);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutLongPositional() {
        this.buf.putLong(1L);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutFloat() {
        this.buf.putFloat(0L, 1.0f);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutFloatPositional() {
        this.buf.putFloat(1.0f);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutDouble() {
        this.buf.putDouble(0L, 1.0);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testPutDoublePositional() {
        this.buf.putDouble(1.0);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutByteArray() {
        this.buf.putByteArray(new byte[]{1}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutBooleanArray() {
        this.buf.putBooleanArray(new boolean[]{true}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutShortArray() {
        this.buf.putShortArray(new short[]{1}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutCharArray() {
        this.buf.putCharArray(new char[]{'\u0001'}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutIntArray() {
        this.buf.putIntArray(new int[]{1}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutLongArray() {
        this.buf.putLongArray(new long[]{1L}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testPutFloatArray() {
        this.buf.putFloatArray(new float[]{1.0f}, 0, 1);
    }

    @Test(expectedExceptions={ReadOnlyException.class})
    public void testDoubleByteArray() {
        this.buf.putDoubleArray(new double[]{1.0}, 0, 1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testWritableMemoryAsBuffer() {
        WritableBuffer buf1 = (WritableBuffer)WritableMemory.allocate((int)8).asBuffer();
        buf1.putInt(1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testWritableBufferRegion() {
        WritableBuffer buf1 = (WritableBuffer)WritableMemory.allocate((int)8).asWritableBuffer().region();
        buf1.putInt(1);
    }

    @Test(expectedExceptions={AssertionError.class})
    public void testWritableBufferDuplicate() {
        WritableBuffer buf1 = (WritableBuffer)WritableMemory.allocate((int)8).asWritableBuffer().duplicate();
        buf1.putInt(1);
    }
}

