/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesSketchTest {
    private static final boolean enablePrinting = false;

    @Test
    public void heapToDirect() {
        UpdateDoublesSketch heapSketch = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            heapSketch.update((double)i);
        }
        DoublesSketch directSketch = DoublesSketch.wrap((Memory)WritableMemory.writableWrap((byte[])heapSketch.toByteArray(false)));
        Assert.assertEquals((double)directSketch.getMinItem(), (double)0.0);
        Assert.assertEquals((double)directSketch.getMaxItem(), (double)999.0);
        Assert.assertEquals((double)directSketch.getQuantile(0.5), (double)500.0, (double)4.0);
    }

    @Test
    public void directToHeap() {
        int sizeBytes = 10000;
        UpdateDoublesSketch directSketch = DoublesSketch.builder().build(WritableMemory.writableWrap((byte[])new byte[sizeBytes]));
        for (int i = 0; i < 1000; ++i) {
            directSketch.update((double)i);
        }
        UpdateDoublesSketch heapSketch = (UpdateDoublesSketch)DoublesSketch.heapify((Memory)WritableMemory.writableWrap((byte[])directSketch.toByteArray()));
        for (int i = 0; i < 1000; ++i) {
            heapSketch.update((double)(i + 1000));
        }
        Assert.assertEquals((double)heapSketch.getMinItem(), (double)0.0);
        Assert.assertEquals((double)heapSketch.getMaxItem(), (double)1999.0);
        Assert.assertEquals((double)heapSketch.getQuantile(0.5), (double)1000.0, (double)10.0);
    }

    @Test
    public void checkToByteArray() {
        UpdateDoublesSketch ds = DoublesSketch.builder().build();
        ds.update(1.0);
        ds.update(2.0);
        byte[] arr = ds.toByteArray(false);
        Assert.assertEquals((int)arr.length, (int)ds.getCurrentUpdatableSerializedSizeBytes());
    }

    static void testSketchEquality(DoublesSketch sketch1, DoublesSketch sketch2) {
        Assert.assertEquals((int)sketch1.getK(), (int)sketch2.getK());
        Assert.assertEquals((long)sketch1.getN(), (long)sketch2.getN());
        Assert.assertEquals((long)sketch1.getBitPattern(), (long)sketch2.getBitPattern());
        Assert.assertEquals((double)sketch1.getMinItem(), (double)sketch2.getMinItem());
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)sketch2.getMaxItem());
        DoublesSketchAccessor accessor1 = DoublesSketchAccessor.wrap((DoublesSketch)sketch1);
        DoublesSketchAccessor accessor2 = DoublesSketchAccessor.wrap((DoublesSketch)sketch2);
        for (int i = 0; i < accessor1.numItems(); ++i) {
            Assert.assertEquals((double)accessor1.get(i), (double)accessor2.get(i));
        }
        int lvl = 0;
        for (long bitPattern = sketch1.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
            if ((bitPattern & 1L) > 0L) {
                accessor1.setLevel(lvl);
                accessor2.setLevel(lvl);
                for (int i = 0; i < accessor1.numItems(); ++i) {
                    Assert.assertEquals((double)accessor1.get(i), (double)accessor2.get(i));
                }
            }
            ++lvl;
        }
    }

    @Test
    public void checkIsSameResource() {
        int k = 16;
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[k * 16 + 24]);
        WritableMemory cmem = WritableMemory.writableWrap((byte[])new byte[8]);
        DirectUpdateDoublesSketch duds = (DirectUpdateDoublesSketch)DoublesSketch.builder().setK(k).build(mem);
        Assert.assertTrue((boolean)duds.isSameResource((Memory)mem));
        DirectCompactDoublesSketch dcds = (DirectCompactDoublesSketch)duds.compact(cmem);
        Assert.assertTrue((boolean)dcds.isSameResource((Memory)cmem));
        UpdateDoublesSketch uds = DoublesSketch.builder().setK(k).build();
        Assert.assertFalse((boolean)uds.isSameResource((Memory)mem));
    }

    @Test
    public void checkEmptyExceptions() {
        int k = 16;
        UpdateDoublesSketch uds = DoublesSketch.builder().setK(k).build();
        try {
            uds.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            uds.getMinItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            uds.getRank(1.0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            uds.getPMF(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            uds.getCDF(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void directSketchShouldMoveOntoHeapEventually() {
        WritableMemory wmem = WritableMemory.allocateDirect((long)1000L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)new DefaultMemoryRequestServer());
        UpdateDoublesSketch sketch = DoublesSketch.builder().build(wmem);
        Assert.assertTrue((boolean)sketch.isSameResource((Memory)wmem));
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        DoublesSketchTest.println(sketch.toString());
    }

    @Test
    public void directSketchShouldMoveOntoHeapEventually2() {
        WritableMemory wmem = WritableMemory.allocateDirect((long)50L, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)new DefaultMemoryRequestServer());
        UpdateDoublesSketch sketch = DoublesSketch.builder().build(wmem);
        Assert.assertTrue((boolean)sketch.isSameResource((Memory)wmem));
        for (int i = 0; i < 1000; ++i) {
            if (!wmem.isAlive()) {
                DoublesSketchTest.println("Sketch Move to Heap at i = " + i);
                break;
            }
            sketch.update((double)i);
        }
        Assert.assertFalse((boolean)wmem.isAlive());
    }

    @Test
    public void checkEmptyDirect() {
        WritableMemory wmem = WritableMemory.allocateDirect((long)1000L);
        UpdateDoublesSketch sketch = DoublesSketch.builder().build(wmem);
        byte[] bytes = sketch.toByteArray();
        byte[] result = new byte[]{1, 3, 8, 4, -128, 0, 0, 0};
        Assert.assertEquals((byte[])bytes, (byte[])result);
        wmem.close();
    }

    @Test
    public void sortedView() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        sketch.update(3.0);
        sketch.update(1.0);
        sketch.update(2.0);
        DoublesSketchSortedView view = sketch.getSortedView();
        DoublesSortedViewIterator it = view.iterator();
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((double)it.getQuantile(), (double)1.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((double)it.getQuantile(), (double)2.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)it.next(), (boolean)true);
        Assert.assertEquals((double)it.getQuantile(), (double)3.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertEquals((long)it.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)it.next(), (boolean)false);
    }

    @Test
    public void checkRankLBError() {
        UpdateDoublesSketch sk = DoublesSketch.builder().build();
        double eps = sk.getNormalizedRankError(false);
        DoublesSketchTest.println("" + 2.0 * eps);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((double)i);
        }
        double rlb = sk.getRankLowerBound(0.5);
        DoublesSketchTest.println(0.5 - rlb);
        Assert.assertTrue((0.5 - rlb <= 2.0 * eps ? 1 : 0) != 0);
    }

    @Test
    public void checkRankUBError() {
        UpdateDoublesSketch sk = DoublesSketch.builder().build();
        double eps = sk.getNormalizedRankError(false);
        DoublesSketchTest.println("" + 2.0 * eps);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((double)i);
        }
        double rub = sk.getRankUpperBound(0.5);
        DoublesSketchTest.println(rub - 0.5);
        Assert.assertTrue((rub - 0.5 <= 2.0 * eps ? 1 : 0) != 0);
    }

    @Test
    public void checkGetRanks() {
        UpdateDoublesSketch sk = DoublesSketch.builder().build();
        for (int i = 1; i <= 10000; ++i) {
            sk.update((double)i);
        }
        double[] qArr = new double[]{1000.0, 2000.0, 3000.0, 4000.0, 5000.0, 6000.0, 7000.0, 8000.0, 9000.0, 10000.0};
        double[] ranks = sk.getRanks(qArr, QuantileSearchCriteria.INCLUSIVE);
        for (int i = 0; i < qArr.length; ++i) {
            double rLB = sk.getRankLowerBound(ranks[i]);
            double rUB = sk.getRankUpperBound(ranks[i]);
            Assert.assertTrue((rLB <= ranks[i] ? 1 : 0) != 0);
            Assert.assertTrue((rUB >= ranks[i] ? 1 : 0) != 0);
            DoublesSketchTest.println(rLB + ", " + ranks[i] + ", " + rUB);
        }
    }

    @Test
    public void checkToStringHeap() {
        UpdateDoublesSketch sk = DoublesSketch.builder().setK(8).build();
        int n = 32;
        for (int i = 1; i <= 32; ++i) {
            double item = i;
            sk.update(item);
        }
        DoublesSketchTest.println(sk.toString(true, false));
    }

    @Test
    public void printlnTest() {
        DoublesSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    private static final void println(Object o) {
    }
}

