/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UpdateSketchTest {
    @Test
    public void checkOtherUpdates() {
        int k = 512;
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(k).build();
        sk1.update(1L);
        sk1.update(1.5);
        sk1.update(0.0);
        sk1.update(-0.0);
        String s = null;
        sk1.update(s);
        s = "";
        sk1.update(s);
        s = "String";
        sk1.update(s);
        byte[] byteArr = null;
        sk1.update(byteArr);
        byteArr = new byte[]{};
        sk1.update(byteArr);
        sk1.update(ByteBuffer.wrap(byteArr));
        byteArr = "Byte Array".getBytes(StandardCharsets.UTF_8);
        sk1.update(byteArr);
        sk1.update(ByteBuffer.wrap(byteArr, 0, 10));
        sk1.update(ByteBuffer.wrap(byteArr, 2, 6));
        char[] charArr = null;
        sk1.update(charArr);
        charArr = new char[]{};
        sk1.update(charArr);
        charArr = "String".toCharArray();
        sk1.update(charArr);
        int[] intArr = null;
        sk1.update(intArr);
        intArr = new int[]{};
        sk1.update(intArr);
        int[] intArr2 = new int[]{1, 2, 3, 4, 5};
        sk1.update(intArr2);
        long[] longArr = null;
        sk1.update(longArr);
        longArr = new long[]{};
        sk1.update(longArr);
        long[] longArr2 = new long[]{6L, 7L, 8L, 9L};
        sk1.update(longArr2);
        double est = sk1.getEstimate();
        Assert.assertEquals((double)est, (double)9.0, (double)0.0);
    }

    @Test
    public void checkStartingSubMultiple() {
        int lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X1.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)10);
        lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X2.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)5);
        lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X4.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)6);
        lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X8.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)7);
        lgSubMul = ThetaUtil.startingSubMultiple((int)4, (int)ResizeFactor.X1.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)5);
    }

    @Test
    public void checkBuilder() {
        UpdateSketchBuilder bldr = UpdateSketch.builder();
        long seed = 12345L;
        bldr.setSeed(seed);
        Assert.assertEquals((long)bldr.getSeed(), (long)seed);
        float p = 0.5f;
        bldr.setP(p);
        Assert.assertEquals((float)bldr.getP(), (float)p);
        ResizeFactor rf = ResizeFactor.X4;
        bldr.setResizeFactor(rf);
        Assert.assertEquals((Object)bldr.getResizeFactor(), (Object)rf);
        Family fam = Family.ALPHA;
        bldr.setFamily(fam);
        Assert.assertEquals((Object)bldr.getFamily(), (Object)fam);
        int lgK = 10;
        int k = 1 << lgK;
        bldr.setNominalEntries(k);
        Assert.assertEquals((int)bldr.getLgNominalEntries(), (int)lgK);
        DefaultMemoryRequestServer mrs = new DefaultMemoryRequestServer();
        bldr.setMemoryRequestServer((MemoryRequestServer)mrs);
        Assert.assertEquals((Object)bldr.getMemoryRequestServer(), (Object)mrs);
        UpdateSketchTest.println(bldr.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderNomEntries() {
        UpdateSketchBuilder bldr = UpdateSketch.builder();
        int k = 0x8000000;
        bldr.setNominalEntries(k);
    }

    @Test
    public void checkCompact() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        CompactSketch csk = sk.compact();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIncompatibleFamily() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.compact().toByteArray());
        UpdateSketch.wrap((WritableMemory)wmem, (long)9001L);
    }

    @Test
    public void checkCorruption() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        try {
            wmem.putByte(1L, (byte)2);
            UpdateSketch.wrap((WritableMemory)wmem, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            wmem.putByte(1L, (byte)3);
            wmem.putByte(0L, (byte)2);
            UpdateSketch.wrap((WritableMemory)wmem, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsResizeFactorIncorrect() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        PreambleUtil.insertLgNomLongs((WritableMemory)wmem, (int)26);
        for (int lgK = 4; lgK <= 26; ++lgK) {
            PreambleUtil.insertLgNomLongs((WritableMemory)wmem, (int)lgK);
            int lgT = lgK + 1;
            for (int lgA = 5; lgA <= lgT; ++lgA) {
                PreambleUtil.insertLgArrLongs((WritableMemory)wmem, (int)lgA);
                for (int lgR = 0; lgR <= 3; ++lgR) {
                    PreambleUtil.insertLgResizeFactor((WritableMemory)wmem, (int)lgR);
                    boolean lgRbad = UpdateSketch.isResizeFactorIncorrect((Memory)wmem, (int)lgK, (int)lgA);
                    boolean rf123 = lgR > 0 && (lgT - lgA) % lgR != 0;
                    boolean rf0 = lgR == 0 && lgA != lgT;
                    Assert.assertTrue((lgRbad == rf0 || lgRbad == rf123 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void checkCompactOpsMemoryToCompact() {
        int lgK = 6;
        UpdateSketch sk = Sketches.updateSketchBuilder().setLogNominalEntries(lgK).build();
        int n = 1 << lgK + 1;
        for (int i = 2; i < n; ++i) {
            sk.update((long)i);
        }
        int cbytes = sk.getCompactBytes();
        byte[] byteArr = sk.toByteArray();
        WritableMemory skwmem = WritableMemory.writableWrap((byte[])byteArr);
        WritableMemory cskwmem1 = WritableMemory.allocate((int)cbytes);
        WritableMemory cskwmem2 = WritableMemory.allocate((int)cbytes);
        WritableMemory cskwmem3 = WritableMemory.allocate((int)cbytes);
        CompactSketch csk1 = sk.compact(true, cskwmem1);
        CompactSketch csk2 = CompactOperations.memoryToCompact((Memory)skwmem, (boolean)true, (WritableMemory)cskwmem2);
        CompactSketch csk3 = CompactOperations.memoryToCompact((Memory)cskwmem1, (boolean)true, (WritableMemory)cskwmem3);
        Assert.assertTrue((boolean)cskwmem1.equals(cskwmem2));
        Assert.assertTrue((boolean)cskwmem1.equals(cskwmem3));
    }

    @Test
    public void printlnTest() {
        UpdateSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

