/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Comparator;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.LongsAsOrderableStrings;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public class SkewedDataTest {
    static String[] hdr = new String[]{"N", "MaxItem", "MinItem", "NumParts", "SearchCriteria"};
    static String hdrfmt = "%6s %10s %10s %10s %15s\n";
    static String hdrdfmt = "%6d %10s %10s %10d %15s\n";
    static String[] rowhdr = new String[]{"Row", "NormRanks", "NatRanks", "Boundaries", "DeltaItems"};
    static String rowhdrfmt = "%5s %12s %12s %12s %12s\n";
    static String rowdfmt = "%5d %12.8f %12d %12s %12d\n";
    static String[] rowhdr2 = new String[]{"Row", "NormRanks", "NatRanks", "Boundaries"};
    static String rowhdrfmt2 = "%5s %12s %12s %12s\n";
    static String rowdfmt2 = "%5d %12.8f %12d %12s\n";
    private static final boolean enablePrinting = true;

    public void checkWithSkew() {
        long i;
        int n = 2050;
        int k = 32768;
        int n2 = 200;
        int totalN = n + n2;
        int numDigits = LongsAsOrderableStrings.digits(totalN);
        long v2 = 1000L;
        int numParts = 22;
        QuantileSearchCriteria searchCrit = QuantileSearchCriteria.INCLUSIVE;
        ItemsSketch sk = ItemsSketch.getInstance(String.class, (int)k, Comparator.naturalOrder());
        for (i = 1L; i <= (long)n; ++i) {
            sk.update((Object)LongsAsOrderableStrings.getString(i, numDigits));
        }
        for (i = 1L; i <= (long)n2; ++i) {
            sk.update((Object)LongsAsOrderableStrings.getString(v2, numDigits));
        }
        ItemsSketchSortedView sv = sk.getSortedView();
        GenericSortedViewIterator itr = sv.iterator();
        SkewedDataTest.println("SORTED VIEW:");
        SkewedDataTest.printf(rowhdrfmt2, rowhdr2);
        int j = 0;
        while (itr.next()) {
            SkewedDataTest.printf(rowdfmt2, j++, itr.getNormalizedRank(searchCrit), itr.getNaturalRank(searchCrit), itr.getQuantile());
        }
        GenericPartitionBoundaries gpb = sv.getPartitionBoundaries(numParts, searchCrit);
        int arrLen = ((String[])gpb.getBoundaries()).length;
        double[] normRanks = gpb.getNormalizedRanks();
        long[] natRanks = gpb.getNaturalRanks();
        String[] boundaries = (String[])gpb.getBoundaries();
        long[] numDeltaItems = gpb.getNumDeltaItems();
        SkewedDataTest.println("");
        SkewedDataTest.println("GET PARTITION BOUNDARIES:");
        SkewedDataTest.printf(hdrfmt, hdr);
        SkewedDataTest.printf(hdrdfmt, totalN, gpb.getMaxItem(), gpb.getMinItem(), numParts, searchCrit.toString());
        SkewedDataTest.println("");
        SkewedDataTest.printf(rowhdrfmt, rowhdr);
        for (int i2 = 0; i2 < arrLen; ++i2) {
            SkewedDataTest.printf(rowdfmt, i2, normRanks[i2], natRanks[i2], boundaries[i2], numDeltaItems[i2]);
        }
    }

    private static final void print(Object o) {
        System.out.print(o.toString());
    }

    private static final void println(Object o) {
        System.out.println(o.toString());
    }

    private static final void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }
}

