/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.List;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqSketch;

public final class ReqSketchSortedView
implements FloatsSortedView {
    private float[] quantiles;
    private long[] cumWeights;
    private final long totalN;
    private final float maxItem;
    private final float minItem;

    ReqSketchSortedView(float[] quantiles, long[] cumWeights, long totalN, float maxItem, float minItem) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = totalN;
        this.maxItem = maxItem;
        this.minItem = minItem;
    }

    public ReqSketchSortedView(ReqSketch sketch) {
        if (sketch.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.totalN = sketch.getN();
        this.maxItem = sketch.getMaxItem();
        this.minItem = sketch.getMinItem();
        this.buildSortedViewArrays(sketch);
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public float getMaxItem() {
        return this.maxItem;
    }

    @Override
    public float getMinItem() {
        return this.minItem;
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public float getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        double naturalRank = QuantilesUtil.getNaturalRank(rank, this.totalN, searchCrit);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[len - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public float[] getQuantiles() {
        return (float[])this.quantiles.clone();
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.LE : InequalitySearch.LT;
        int index = InequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public FloatsSortedViewIterator iterator() {
        return new FloatsSortedViewIterator(this.quantiles, this.cumWeights);
    }

    private void buildSortedViewArrays(ReqSketch sk) {
        List<ReqCompactor> compactors = sk.getCompactors();
        int numComp = compactors.size();
        int totalQuantiles = sk.getNumRetained();
        this.quantiles = new float[totalQuantiles];
        this.cumWeights = new long[totalQuantiles];
        int count = 0;
        for (int i = 0; i < numComp; ++i) {
            ReqCompactor c = compactors.get(i);
            FloatBuffer bufIn = c.getBuffer();
            long bufWeight = 1 << c.getLgWeight();
            int bufInLen = bufIn.getCount();
            this.mergeSortIn(bufIn, bufWeight, count, sk.getHighRankAccuracyMode());
            count += bufInLen;
        }
        this.createCumulativeNativeRanks();
    }

    private void mergeSortIn(FloatBuffer bufIn, long bufWeight, int count, boolean hra) {
        if (!bufIn.isSorted()) {
            bufIn.sort();
        }
        float[] arrIn = bufIn.getArray();
        int bufInLen = bufIn.getCount();
        int totLen = count + bufInLen;
        int i = count - 1;
        int j = bufInLen - 1;
        int h = hra ? bufIn.getCapacity() - 1 : bufInLen - 1;
        int k = totLen;
        while (k-- > 0) {
            if (i >= 0 && j >= 0) {
                if (this.quantiles[i] >= arrIn[h]) {
                    this.quantiles[k] = this.quantiles[i];
                    this.cumWeights[k] = this.cumWeights[i--];
                    continue;
                }
                this.quantiles[k] = arrIn[h--];
                --j;
                this.cumWeights[k] = bufWeight;
                continue;
            }
            if (i >= 0) {
                this.quantiles[k] = this.quantiles[i];
                this.cumWeights[k] = this.cumWeights[i--];
                continue;
            }
            if (j < 0) break;
            this.quantiles[k] = arrIn[h--];
            --j;
            this.cumWeights[k] = bufWeight;
        }
    }

    private void createCumulativeNativeRanks() {
        int len = this.quantiles.length;
        for (int i = 1; i < len; ++i) {
            int n = i;
            this.cumWeights[n] = this.cumWeights[n] + this.cumWeights[i - 1];
        }
        if (this.totalN > 0L) assert (this.cumWeights[len - 1] == this.totalN);
    }
}

