/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.partitions;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.partitions.BoundsRule;
import org.apache.datasketches.partitions.SketchFillRequest;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericAPI;

public class Partitioner<T, S extends QuantilesGenericAPI<T> & PartitioningFeature<T>> {
    private static final QuantileSearchCriteria defaultCriteria = QuantileSearchCriteria.INCLUSIVE;
    private final long tgtPartitionSize;
    private final int maxPartsPerSk;
    private final SketchFillRequest<T, S> fillReq;
    private final QuantileSearchCriteria criteria;
    private final ArrayDeque<StackElement<T>> stack = new ArrayDeque();
    private int numLevels;
    private int partitionsPerSk;
    private final List<PartitionBoundsRow<T>> finalPartitionList = new ArrayList<PartitionBoundsRow<T>>();

    public Partitioner(long tgtPartitionSize, int maxPartsPerPass, SketchFillRequest<T, S> fillReq) {
        this(tgtPartitionSize, maxPartsPerPass, fillReq, defaultCriteria);
    }

    public Partitioner(long tgtPartitionSize, int maxPartsPerSk, SketchFillRequest<T, S> fillReq, QuantileSearchCriteria criteria) {
        this.tgtPartitionSize = tgtPartitionSize;
        this.maxPartsPerSk = maxPartsPerSk;
        this.fillReq = fillReq;
        this.criteria = criteria;
    }

    public List<PartitionBoundsRow<T>> partition(S sk) {
        if (sk.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        long inputN = sk.getN();
        double guessNumParts = Math.max(1.0, Math.ceil((double)inputN / (double)this.tgtPartitionSize));
        this.numLevels = (int)Math.max(1.0, Math.ceil(Math.log(guessNumParts) / Math.log(this.maxPartsPerSk)));
        int partsPerSk = (int)Math.round(Math.pow(guessNumParts, 1.0 / (double)this.numLevels));
        this.partitionsPerSk = Math.min(partsPerSk, this.maxPartsPerSk);
        GenericPartitionBoundaries gpb = ((PartitioningFeature)sk).getPartitionBoundaries(this.partitionsPerSk, this.criteria);
        StackElement se = new StackElement(gpb, 0, "1");
        this.stack.push(se);
        this.partitionSearch(this.stack);
        return Collections.unmodifiableList(this.finalPartitionList);
    }

    private void partitionSearch(ArrayDeque<StackElement<T>> stack) {
        if (stack.isEmpty()) {
            return;
        }
        StackElement<T> se = stack.peek();
        GenericPartitionBoundaries gpb = se.gpb;
        int numParts = gpb.getNumPartitions();
        if (stack.size() == this.numLevels) {
            while (++se.part <= numParts) {
                PartitionBoundsRow<T> row = new PartitionBoundsRow<T>(se);
                this.finalPartitionList.add(row);
            }
            stack.pop();
            this.partitionSearch(stack);
        } else {
            if (++se.part <= numParts) {
                PartitionBoundsRow<T> row = new PartitionBoundsRow<T>(se);
                S sk = this.fillReq.getRange(row.lowerBound, row.upperBound, row.rule);
                GenericPartitionBoundaries gpb2 = ((PartitioningFeature)sk).getPartitionBoundaries(this.partitionsPerSk, this.criteria);
                int level = stack.size() + 1;
                String partId = se.levelPartId + "." + se.part + "," + level;
                StackElement se2 = new StackElement(gpb2, 0, partId);
                stack.push(se2);
                this.partitionSearch(stack);
            }
            if (stack.isEmpty()) {
                return;
            }
            stack.pop();
            this.partitionSearch(stack);
        }
    }

    public static class PartitionBoundsRow<T> {
        public int part;
        public String levelPartId;
        public long approxNumDeltaItems;
        public BoundsRule rule;
        public T lowerBound;
        public T upperBound;

        public PartitionBoundsRow(StackElement<T> se) {
            GenericPartitionBoundaries gpb = se.gpb;
            this.part = se.part;
            this.levelPartId = se.levelPartId + "." + this.part;
            QuantileSearchCriteria searchCrit = gpb.getSearchCriteria();
            T[] boundaries = gpb.getBoundaries();
            int numParts = gpb.getNumPartitions();
            if (searchCrit == QuantileSearchCriteria.INCLUSIVE) {
                if (this.part == 1) {
                    this.lowerBound = gpb.getMinItem();
                    this.upperBound = boundaries[this.part];
                    this.rule = BoundsRule.INCLUDE_BOTH;
                } else {
                    this.lowerBound = boundaries[this.part - 1];
                    this.upperBound = boundaries[this.part];
                    this.rule = BoundsRule.INCLUDE_UPPER;
                }
            } else if (this.part == numParts) {
                this.lowerBound = boundaries[this.part - 1];
                this.upperBound = gpb.getMaxItem();
                this.rule = BoundsRule.INCLUDE_BOTH;
            } else {
                this.lowerBound = boundaries[this.part - 1];
                this.upperBound = boundaries[this.part];
                this.rule = BoundsRule.INCLUDE_LOWER;
            }
            this.approxNumDeltaItems = gpb.getNumDeltaItems()[this.part];
        }
    }

    public static class StackElement<T> {
        public final GenericPartitionBoundaries<T> gpb;
        public int part;
        public String levelPartId;

        public StackElement(GenericPartitionBoundaries<T> gpb, int part, String levelPartId) {
            this.gpb = gpb;
            this.part = part;
            this.levelPartId = levelPartId;
        }
    }
}

