/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.req.ReqSketchSortedView;
import org.testng.Assert;
import org.testng.annotations.Test;

public final class ReflectUtilityTest {
    static final Class<?> REQ_SV = ReflectUtilityTest.getClass("org.apache.datasketches.req.ReqSketchSortedView");
    static final Class<?> KLL_FLOATS_SV = ReflectUtilityTest.getClass("org.apache.datasketches.kll.KllFloatsSketchSortedView");
    static final Class<?> KLL_DOUBLES_SV = ReflectUtilityTest.getClass("org.apache.datasketches.kll.KllDoublesSketchSortedView");
    static final Class<?> CLASSIC_DOUBLES_SV = ReflectUtilityTest.getClass("org.apache.datasketches.quantiles.DoublesSketchSortedView");
    static final Constructor<?> REQ_SV_CTOR = ReflectUtilityTest.getConstructor(REQ_SV, float[].class, long[].class, Long.TYPE, Float.TYPE, Float.TYPE);
    static final Constructor<?> KLL_FLOATS_SV_CTOR = ReflectUtilityTest.getConstructor(KLL_FLOATS_SV, float[].class, long[].class, Long.TYPE, Float.TYPE, Float.TYPE);
    static final Constructor<?> KLL_DOUBLES_SV_CTOR = ReflectUtilityTest.getConstructor(KLL_DOUBLES_SV, double[].class, long[].class, Long.TYPE, Double.TYPE, Double.TYPE);
    static final Constructor<?> CLASSIC_DOUBLES_SV_CTOR = ReflectUtilityTest.getConstructor(CLASSIC_DOUBLES_SV, double[].class, long[].class, Long.TYPE, Double.TYPE, Double.TYPE);

    private ReflectUtilityTest() {
    }

    @Test
    public static void checkCtr() throws Exception {
        float[] farr = new float[]{10.0f, 20.0f, 30.0f};
        long[] larr = new long[]{1L, 2L, 3L};
        long n = 3L;
        ReqSketchSortedView reqSV = (ReqSketchSortedView)REQ_SV_CTOR.newInstance(farr, larr, n, Float.valueOf(10.0f), Float.valueOf(30.0f));
        float q = reqSV.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE);
        Assert.assertEquals((float)q, (float)30.0f);
    }

    public static Class<?> getClass(String fullyQualifiedBinaryName) {
        try {
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            return scl.loadClass(fullyQualifiedBinaryName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> ownerClass, Class<?> ... parameterTypes) {
        try {
            Constructor<?> ctor = ownerClass.getDeclaredConstructor(parameterTypes);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstance(Constructor<?> constructor, Object ... initargs) {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(initargs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getField(Class<?> ownerClass, String fieldName) {
        try {
            Field field = ownerClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Class<?> ownerClass, Field field) {
        try {
            field.setAccessible(true);
            return field.get(ownerClass);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> ownerClass, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = parameterTypes == null ? ownerClass.getDeclaredMethod(methodName, new Class[0]) : ownerClass.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

