/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllItemsSketchSerDeTest {
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();

    @Test
    public void serializeDeserializeEmpty() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] bytes = sk1.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertTrue((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllItemsSketch sk3 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk3.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        try {
            sk3.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk3.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }

    @Test
    public void serializeDeserializeOneValue() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk1.update((Object)" 1");
        byte[] bytes = sk1.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertFalse((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sk2.getN(), (long)1L);
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)" 1");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)" 1");
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllItemsSketch sk3 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertFalse((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)1);
        Assert.assertEquals((long)sk3.getN(), (long)1L);
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((String)((String)sk3.getMinItem()), (String)" 1");
        Assert.assertEquals((String)((String)sk3.getMaxItem()), (String)" 1");
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }

    @Test
    public void serializeDeserializeMultipleValues() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sk1.update((Object)Util.intToFixedLengthString((int)i, (int)4));
        }
        Assert.assertEquals((String)((String)sk1.getMinItem()), (String)"   0");
        Assert.assertEquals((String)((String)sk1.getMaxItem()), (String)" 999");
        byte[] bytes = sk1.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((int)bytes.length, (int)sk1.getSerializedSizeBytes());
        Assert.assertFalse((boolean)sk2.isEmpty());
        Assert.assertEquals((int)sk2.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk2.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)((String)sk1.getMinItem()));
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)((String)sk1.getMaxItem()));
        Assert.assertEquals((int)sk2.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        KllItemsSketch sk3 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertFalse((boolean)sk3.isEmpty());
        Assert.assertEquals((int)sk3.getNumRetained(), (int)sk1.getNumRetained());
        Assert.assertEquals((long)sk3.getN(), (long)sk1.getN());
        Assert.assertEquals((double)sk3.getNormalizedRankError(false), (double)sk1.getNormalizedRankError(false));
        Assert.assertEquals((String)((String)sk3.getMinItem()), (String)((String)sk1.getMinItem()));
        Assert.assertEquals((String)((String)sk3.getMaxItem()), (String)((String)sk1.getMaxItem()));
        Assert.assertEquals((int)sk3.getSerializedSizeBytes(), (int)sk1.getSerializedSizeBytes());
        byte[] bytes2 = sk3.toByteArray();
        Assert.assertEquals((byte[])bytes, (byte[])bytes2);
    }
}

