/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllFloatsSketchIteratorTest {
    @Test
    public void emptySketch() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        QuantilesFloatsSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        QuantilesFloatsSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((float)it.getQuantile(), (float)1.0f);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void twoItemSketchForIterator() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        QuantilesFloatsSketchIterator itr = sketch.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((float)itr.getQuantile(), (float)2.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((float)itr.getQuantile(), (float)1.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
    }

    @Test
    public void twoItemSketchForSortedViewIterator() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        FloatsSortedViewIterator itr = sketch.getSortedView().iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((float)itr.getQuantile(), (float)1.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((float)itr.getQuantile(), (float)2.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
            for (int i = 0; i < n; ++i) {
                sketch.update((float)i);
            }
            QuantilesFloatsSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

