/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllItemsSketchSortedView;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactItemsSketchIteratorTest {
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();

    @Test
    public void emptySketch() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        QuantilesGenericSketchIterator itr = sk2.iterator();
        Assert.assertFalse((boolean)itr.next());
    }

    @Test
    public void oneItemSketch() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        QuantilesGenericSketchIterator itr = sk2.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertFalse((boolean)itr.next());
    }

    @Test
    public void twoItemSketchForIterator() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        sk.update((Object)"2");
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        QuantilesGenericSketchIterator itr = sk2.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"2");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
    }

    @Test
    public void twoItemSketchForSortedViewIterator() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        sk.update((Object)"2");
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        KllItemsSketchSortedView.KllItemsSketchSortedViewIterator itr = sk2.getSortedView().iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"2");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void bigSketches() {
        int digits = 6;
        for (int n = 1000; n < 100000; n += 2000) {
            KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
            for (int i = 0; i < n; ++i) {
                sk.update((Object)Util.intToFixedLengthString((int)i, (int)6));
            }
            byte[] byteArr = sk.toByteArray();
            KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
            Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
            QuantilesGenericSketchIterator itr = sk2.iterator();
            int count = 0;
            int weight = 0;
            while (itr.next()) {
                ++count;
                weight += (int)itr.getWeight();
            }
            Assert.assertEquals((int)count, (int)sk.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

