/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.PairwiseSetOperations;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PairwiseSetOperationsTest {
    @Test
    public void checkIntersectionNoOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + k));
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        CompactSketch rsk = PairwiseSetOperations.intersect((Sketch)csk1, (Sketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)0.0);
    }

    @Test
    public void checkIntersectionFullOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        CompactSketch rsk = PairwiseSetOperations.intersect((Sketch)csk1, (Sketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        long v = 0L;
        int trials = 10;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        Intersection inter = SetOperation.builder().buildIntersection();
        for (int t = 0; t < trials; ++t) {
            for (int i = 0; i < u; ++i) {
                usk1.update((long)i + v);
                usk2.update((long)i + v + (long)(u / 2));
            }
            v += (long)(u + u / 2);
            CompactSketch csk1 = usk1.compact(true, null);
            CompactSketch csk2 = usk2.compact(true, null);
            CompactSketch rsk = PairwiseSetOperations.intersect((Sketch)csk1, (Sketch)csk2);
            double result1 = rsk.getEstimate();
            inter.intersect((Sketch)csk1);
            inter.intersect((Sketch)csk2);
            CompactSketch csk3 = inter.getResult(true, null);
            double result2 = csk3.getEstimate();
            Assert.assertEquals((double)result1, (double)result2, (double)0.0);
            usk1.reset();
            usk2.reset();
            inter.reset();
        }
    }

    @Test
    public void checkAnotBNoOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + k));
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        CompactSketch rsk = PairwiseSetOperations.aNotB((Sketch)csk1, (Sketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkAnotBFullOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        CompactSketch rsk = PairwiseSetOperations.aNotB((Sketch)csk1, (Sketch)csk2);
        Assert.assertEquals((double)rsk.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void checkAnotBEarlyStop() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        long v = 0L;
        int trials = 10;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        AnotB aNotB = SetOperation.builder().buildANotB();
        for (int t = 0; t < trials; ++t) {
            for (int i = 0; i < u; ++i) {
                usk1.update((long)i + v);
                usk2.update((long)i + v + (long)(u / 2));
            }
            v += (long)(u + u / 2);
            CompactSketch csk1 = usk1.compact(true, null);
            CompactSketch csk2 = usk2.compact(true, null);
            CompactSketch rsk = PairwiseSetOperations.aNotB((Sketch)csk1, (Sketch)csk2);
            double result1 = rsk.getEstimate();
            CompactSketch csk3 = aNotB.aNotB((Sketch)csk1, (Sketch)csk2);
            double result2 = csk3.getEstimate();
            Assert.assertEquals((double)result1, (double)result2, (double)0.0);
            usk1.reset();
            usk2.reset();
        }
    }

    @Test
    public void checkUnionNoOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        Union union = Sketches.setOperationBuilder().setNominalEntries(k).buildUnion();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + k));
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        union.union((Sketch)csk1);
        union.union((Sketch)csk2);
        CompactSketch stdSk = union.getResult(true, null);
        CompactSketch pwSk = PairwiseSetOperations.union((CompactSketch)csk1, (CompactSketch)csk2, (int)k);
        Assert.assertEquals((double)pwSk.getEstimate(), (double)stdSk.getEstimate(), (double)0.0);
    }

    @Test
    public void checkUnionFullOverlap() {
        int lgK = 9;
        int k = 1 << lgK;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < k; ++i) {
            usk1.update((long)i);
            usk2.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        CompactSketch rsk = PairwiseSetOperations.union((CompactSketch)csk1, (CompactSketch)csk2, (int)k);
        Assert.assertEquals((double)rsk.getEstimate(), (double)k, (double)0.0);
    }

    @Test
    public void checkUnionEarlyStop() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 4 * k;
        long v = 0L;
        int trials = 10;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        Union union = SetOperation.builder().setNominalEntries(2 * k).buildUnion();
        for (int t = 0; t < trials; ++t) {
            for (int i = 0; i < u; ++i) {
                usk1.update((long)i + v);
                usk2.update((long)i + v + (long)(u / 2));
            }
            v += (long)(u + u / 2);
            CompactSketch csk1 = usk1.compact(true, null);
            CompactSketch csk2 = usk2.compact(true, null);
            CompactSketch pwSk = PairwiseSetOperations.union((CompactSketch)csk1, (CompactSketch)csk2, (int)(2 * k));
            double pwEst = pwSk.getEstimate();
            union.union((Sketch)csk1);
            union.union((Sketch)csk2);
            CompactSketch stdSk = union.getResult(true, null);
            double stdEst = stdSk.getEstimate();
            Assert.assertEquals((double)pwEst, (double)stdEst, (double)0.0);
            usk1.reset();
            usk2.reset();
            union.reset();
        }
    }

    @Test
    public void checkUnionCutbackToK() {
        int lgK = 10;
        int k = 1 << lgK;
        int u = 3 * k;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(k).build();
        Union union = SetOperation.builder().setNominalEntries(k).buildUnion();
        for (int i = 0; i < u; ++i) {
            usk1.update((long)i);
            usk2.update((long)(i + 2 * u));
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        CompactSketch pwSk = PairwiseSetOperations.union((CompactSketch)csk1, (CompactSketch)csk2, (int)k);
        double pwEst = pwSk.getEstimate();
        union.union((Sketch)csk1);
        union.union((Sketch)csk2);
        CompactSketch stdSk = union.getResult(true, null);
        double stdEst = stdSk.getEstimate();
        Assert.assertEquals((double)pwEst, (double)stdEst, (double)(stdEst * 0.06));
        usk1.reset();
        usk2.reset();
        union.reset();
    }

    @Test
    public void checkNullRules() {
        int k = 16;
        UpdateSketch uskA = UpdateSketch.builder().setNominalEntries(k).build();
        CompactSketch cskAempty = uskA.compact();
        CompactSketch cskAnull = null;
        AnotB aNotB = SetOperation.builder().buildANotB();
        Intersection inter = SetOperation.builder().buildIntersection();
        try {
            PairwiseSetOperationsTest.checkIntersection(inter, cskAnull, cskAempty);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkIntersection(inter, cskAempty, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkIntersection(inter, cskAnull, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkAnotB(aNotB, cskAnull, cskAempty);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkAnotB(aNotB, cskAempty, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            PairwiseSetOperationsTest.checkAnotB(aNotB, cskAnull, cskAnull);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEmptyValidRules() {
        int k = 16;
        UpdateSketch uskA = UpdateSketch.builder().setNominalEntries(k).build();
        UpdateSketch uskB = UpdateSketch.builder().setNominalEntries(k).build();
        CompactSketch cskAempty = uskA.compact();
        CompactSketch cskBempty = uskB.compact();
        uskA.update(1L);
        CompactSketch cskA1 = uskA.compact();
        Union union = SetOperation.builder().setNominalEntries(k).buildUnion();
        AnotB aNotB = SetOperation.builder().buildANotB();
        Intersection inter = SetOperation.builder().buildIntersection();
        PairwiseSetOperationsTest.checkSetOps(union, inter, aNotB, k, cskAempty, cskBempty);
        PairwiseSetOperationsTest.checkSetOps(union, inter, aNotB, k, cskA1, cskBempty);
        PairwiseSetOperationsTest.checkSetOps(union, inter, aNotB, k, cskAempty, cskA1);
    }

    private static void checkSetOps(Union union, Intersection inter, AnotB aNotB, int k, CompactSketch cskA, CompactSketch cskB) {
        PairwiseSetOperationsTest.checkUnion(union, cskA, cskB, k);
        PairwiseSetOperationsTest.checkIntersection(inter, cskA, cskB);
        PairwiseSetOperationsTest.checkAnotB(aNotB, cskA, cskB);
    }

    private static void checkUnion(Union union, CompactSketch cskA, CompactSketch cskB, int k) {
        union.union((Sketch)cskA);
        union.union((Sketch)cskB);
        CompactSketch cskU = union.getResult();
        CompactSketch cskP = PairwiseSetOperations.union((CompactSketch)cskA, (CompactSketch)cskB, (int)k);
        Assert.assertEquals((boolean)cskU.isEmpty(), (boolean)cskP.isEmpty());
        union.reset();
    }

    private static void checkIntersection(Intersection inter, CompactSketch cskA, CompactSketch cskB) {
        inter.intersect((Sketch)cskA);
        inter.intersect((Sketch)cskB);
        CompactSketch cskI = inter.getResult();
        CompactSketch cskP = PairwiseSetOperations.intersect((Sketch)cskA, (Sketch)cskB);
        Assert.assertEquals((boolean)cskI.isEmpty(), (boolean)cskP.isEmpty());
        inter.reset();
    }

    private static void checkAnotB(AnotB aNotB, CompactSketch cskA, CompactSketch cskB) {
        CompactSketch cskD = aNotB.aNotB((Sketch)cskA, (Sketch)cskB);
        CompactSketch cskP = PairwiseSetOperations.aNotB((Sketch)cskA, (Sketch)cskB);
        Assert.assertEquals((boolean)cskD.isEmpty(), (boolean)cskP.isEmpty());
    }

    @Test
    public void printlnTest() {
        PairwiseSetOperationsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

