/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.req.ReqSketch;
import org.apache.datasketches.req.ReqSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReqSketchSortedViewTest {
    private final int k = 32;
    private final boolean hra = false;
    private final int numV = 3;
    private final int dup = 2;
    private final int n = 6;
    private static final boolean enablePrinting = false;

    @Test
    public void emptySketch() {
        ReqSketch sketch = ReqSketch.builder().build();
        FloatsSortedViewIterator itr = sketch.getSortedView().iterator();
        Assert.assertFalse((boolean)itr.next());
    }

    @Test
    public void twoValueSketch() {
        ReqSketch sketch = ReqSketch.builder().build();
        sketch.update(1.0f);
        sketch.update(2.0f);
        FloatsSortedViewIterator itr = sketch.getSortedView().iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((float)itr.getQuantile(), (float)1.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((float)itr.getQuantile(), (float)2.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    public void checkIterator() {
        ReqSketchSortedViewTest.println("");
        ReqSketchSortedViewTest.println("CHECK ReqSketchSortedViewIterator");
        ReqSketchSortedViewTest.println("  k: 32, hra: false");
        ReqSketchSortedViewTest.println("  numV: 3, dup: 2, Total n = 6");
        ReqSketch sketch = this.buildDataLoadSketch();
        this.checkIterator(sketch);
    }

    private ReqSketch buildDataLoadSketch() {
        float[] fArr = new float[6];
        int h = 0;
        for (int i = 0; i < 3; ++i) {
            float flt = (i + 1) * 10;
            for (int j = 1; j <= 2; ++j) {
                fArr[h++] = flt;
            }
        }
        ReqSketchBuilder bldr = ReqSketch.builder();
        ReqSketch sketch = bldr.build();
        for (int i = 0; i < 6; ++i) {
            sketch.update(fArr[i]);
        }
        return sketch;
    }

    private void checkIterator(ReqSketch sketch) {
        ReqSketchSortedViewTest.println("\nNot Deduped:");
        FloatsSortedView sv = sketch.getSortedView();
        FloatsSortedViewIterator itr = sv.iterator();
        this.printIterator(itr);
    }

    private void printIterator(FloatsSortedViewIterator itr) {
        ReqSketchSortedViewTest.println("");
        String[] header = new String[]{"Value", "Wt", "CumWtNotInc", "NormRankNotInc", "CumWtInc", "NormRankInc"};
        String hfmt = "%8s%6s%16s%16s%16s%16s\n";
        String fmt = "%8.1f%6d%16d%16.3f%16d%16.3f\n";
        ReqSketchSortedViewTest.printf(hfmt, header);
        while (itr.next()) {
            float v = itr.getQuantile();
            long wt = itr.getWeight();
            long cumWtNotInc = itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE);
            double nRankNotInc = itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE);
            long cumWtInc = itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE);
            double nRankInc = itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE);
            ReqSketchSortedViewTest.printf(fmt, Float.valueOf(v), wt, cumWtNotInc, nRankNotInc, cumWtInc, nRankInc);
        }
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

