/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketchSortedView;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketchSortedView;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchSortedView;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.LinearRanksAndQuantiles;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.ReflectUtility;
import org.apache.datasketches.req.ReqSketch;
import org.apache.datasketches.req.ReqSketchSortedView;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CrossCheckQuantilesTest {
    static final int k = 32;
    final float[][] svFValues = new float[][]{{10.0f}, {10.0f, 10.0f}, {10.0f, 20.0f, 30.0f, 40.0f}, {10.0f, 20.0f, 20.0f, 30.0f, 30.0f, 30.0f, 40.0f, 50.0f}, {10.0f, 10.0f, 20.0f, 20.0f, 30.0f, 30.0f, 40.0f, 40.0f}};
    final double[][] svDValues = new double[][]{{10.0}, {10.0, 10.0}, {10.0, 20.0, 30.0, 40.0}, {10.0, 20.0, 20.0, 30.0, 30.0, 30.0, 40.0, 50.0}, {10.0, 10.0, 20.0, 20.0, 30.0, 30.0, 40.0, 40.0}};
    final long[][] svWeights = new long[][]{{1L}, {1L, 1L}, {2L, 2L, 2L, 2L}, {2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L}, {2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L}};
    int numSets;
    long[][] svCumWeights;
    long[] totalN;
    float[][] skFStreamValues;
    double[][] skDStreamValues;
    ReqSketch reqFloatsSk = null;
    KllFloatsSketch kllFloatsSk = null;
    KllDoublesSketch kllDoublesSk = null;
    UpdateDoublesSketch classicDoublesSk = null;
    ReqSketchSortedView reqFloatsSV = null;
    KllFloatsSketchSortedView kllFloatsSV = null;
    KllDoublesSketchSortedView kllDoublesSV = null;
    DoublesSketchSortedView classicDoublesSV = null;
    private static final boolean enablePrinting = false;

    @Test
    public void runTests() throws Exception {
        this.buildDataSets();
        for (int set = 0; set < this.numSets; ++set) {
            this.buildSVs(set);
            this.buildSketches(set);
            CrossCheckQuantilesTest.println("");
            CrossCheckQuantilesTest.println("TEST getRank, Set " + set + ", all Criteria, across all sketches and their Sorted Views:");
            this.checkGetRank(set, QuantileSearchCriteria.INCLUSIVE);
            this.checkGetRank(set, QuantileSearchCriteria.EXCLUSIVE);
            CrossCheckQuantilesTest.println("");
            CrossCheckQuantilesTest.println("TEST getQuantile, Set " + set + ", all Criteria, across all sketches and their Sorted Views:");
            this.checkGetQuantile(set, QuantileSearchCriteria.INCLUSIVE);
            this.checkGetQuantile(set, QuantileSearchCriteria.EXCLUSIVE);
        }
    }

    private void checkGetRank(int set, QuantileSearchCriteria crit) {
        double testRank;
        double trueRank;
        float maxFloatvalue = this.getMaxFloatValue(set);
        CrossCheckQuantilesTest.println("");
        for (float v = 5.0f; v <= maxFloatvalue + 5.0f; v += 5.0f) {
            trueRank = LinearRanksAndQuantiles.getTrueFloatRank(this.svCumWeights[set], this.svFValues[set], v, crit);
            testRank = this.reqFloatsSV.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.reqFloatsSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.kllFloatsSV.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.kllFloatsSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            CrossCheckQuantilesTest.println("Floats  set: " + set + ", value: " + v + ", rank: " + trueRank + ", crit: " + crit.toString());
        }
        CrossCheckQuantilesTest.println("");
        double maxDoubleValue = this.getMaxDoubleValue(set);
        for (double v = 5.0; v <= maxDoubleValue + 5.0; v += 5.0) {
            trueRank = LinearRanksAndQuantiles.getTrueDoubleRank(this.svCumWeights[set], this.svDValues[set], v, crit);
            testRank = this.kllDoublesSV.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.kllDoublesSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.classicDoublesSV.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            testRank = this.classicDoublesSk.getRank(v, crit);
            Assert.assertEquals((double)testRank, (double)trueRank);
            CrossCheckQuantilesTest.println("Doubles set: " + set + ", value: " + v + ", rank: " + trueRank + ", crit: " + crit.toString());
        }
    }

    private void checkGetQuantile(int set, QuantileSearchCriteria crit) {
        int twoN = (int)this.totalN[set] * 2;
        double dTwoN = twoN;
        CrossCheckQuantilesTest.println("");
        for (int i = 0; i <= twoN; ++i) {
            double normRank = (double)i / dTwoN;
            float trueFQ = LinearRanksAndQuantiles.getTrueFloatQuantile(this.svCumWeights[set], this.svFValues[set], normRank, crit);
            float testFQ = this.reqFloatsSV.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            testFQ = this.reqFloatsSk.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            testFQ = this.kllFloatsSV.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            testFQ = this.kllFloatsSk.getQuantile(normRank, crit);
            Assert.assertEquals((float)testFQ, (float)trueFQ);
            CrossCheckQuantilesTest.println("Floats  set: " + set + ", rank: " + normRank + ", Q: " + trueFQ + ", crit: " + crit.toString());
        }
        CrossCheckQuantilesTest.println("");
        for (int i = 0; i <= twoN; ++i) {
            double normRank = (double)i / dTwoN;
            double trueDQ = LinearRanksAndQuantiles.getTrueDoubleQuantile(this.svCumWeights[set], this.svDValues[set], normRank, crit);
            double testDQ = this.kllDoublesSV.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            testDQ = this.kllDoublesSk.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            testDQ = this.classicDoublesSV.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            testDQ = this.classicDoublesSk.getQuantile(normRank, crit);
            Assert.assertEquals((double)testDQ, (double)trueDQ);
            CrossCheckQuantilesTest.println("Doubles set: " + set + ", rank: " + normRank + ", Q: " + trueDQ + ", crit: " + crit.toString());
        }
    }

    private double getMaxDoubleValue(int set) {
        int streamLen = this.skDStreamValues[set].length;
        return this.skDStreamValues[set][streamLen - 1];
    }

    private float getMaxFloatValue(int set) {
        int streamLen = this.skFStreamValues[set].length;
        return this.skFStreamValues[set][streamLen - 1];
    }

    private void buildSketches(int set) {
        this.reqFloatsSk = ReqSketch.builder().setK(32).build();
        this.kllFloatsSk = KllFloatsSketch.newHeapInstance((int)32);
        this.kllDoublesSk = KllDoublesSketch.newHeapInstance((int)32);
        this.classicDoublesSk = DoublesSketch.builder().setK(32).build();
        int count = this.skFStreamValues[set].length;
        for (int i = 0; i < count; ++i) {
            this.reqFloatsSk.update(this.skFStreamValues[set][i]);
            this.kllFloatsSk.update(this.skFStreamValues[set][i]);
            this.kllDoublesSk.update(this.skDStreamValues[set][i]);
            this.classicDoublesSk.update(this.skDStreamValues[set][i]);
        }
    }

    private void buildSVs(int set) throws Exception {
        this.reqFloatsSV = this.getRawReqSV(this.svFValues[set], this.svCumWeights[set], this.totalN[set]);
        this.kllFloatsSV = this.getRawKllFloatsSV(this.svFValues[set], this.svCumWeights[set], this.totalN[set]);
        this.kllDoublesSV = this.getRawKllDoublesSV(this.svDValues[set], this.svCumWeights[set], this.totalN[set]);
        this.classicDoublesSV = this.getRawClassicDoublesSV(this.svDValues[set], this.svCumWeights[set], this.totalN[set]);
    }

    private final ReqSketchSortedView getRawReqSV(float[] values, long[] cumWeights, long totalN) throws Exception {
        return (ReqSketchSortedView)ReflectUtility.REQ_SV_CTOR.newInstance(values, cumWeights, totalN);
    }

    private final KllFloatsSketchSortedView getRawKllFloatsSV(float[] values, long[] cumWeights, long totalN) throws Exception {
        return (KllFloatsSketchSortedView)ReflectUtility.KLL_FLOATS_SV_CTOR.newInstance(values, cumWeights, totalN);
    }

    private final KllDoublesSketchSortedView getRawKllDoublesSV(double[] values, long[] cumWeights, long totalN) throws Exception {
        return (KllDoublesSketchSortedView)ReflectUtility.KLL_DOUBLES_SV_CTOR.newInstance(values, cumWeights, totalN);
    }

    private final DoublesSketchSortedView getRawClassicDoublesSV(double[] values, long[] cumWeights, long totalN) throws Exception {
        return (DoublesSketchSortedView)ReflectUtility.CLASSIC_DOUBLES_SV_CTOR.newInstance(values, cumWeights, totalN);
    }

    private void buildDataSets() {
        this.numSets = this.svWeights.length;
        this.svCumWeights = new long[this.numSets][];
        this.totalN = new long[this.numSets];
        this.skFStreamValues = new float[this.numSets][];
        this.skDStreamValues = new double[this.numSets][];
        for (int i = 0; i < this.numSets; ++i) {
            this.svCumWeights[i] = this.convertToCumWeights(this.svWeights[i]);
            int len = this.svCumWeights[i].length;
            int totalCount = (int)this.svCumWeights[i][len - 1];
            this.totalN[i] = totalCount;
            this.skFStreamValues[i] = this.convertToFloatStream(this.svFValues[i], this.svWeights[i], totalCount);
            this.skDStreamValues[i] = this.convertToDoubleStream(this.svDValues[i], this.svWeights[i], totalCount);
        }
        CrossCheckQuantilesTest.println("");
    }

    private float[] convertToFloatStream(float[] svFValueArr, long[] svWeightsArr, int totalCount) {
        float[] out = new float[totalCount];
        int len = svWeightsArr.length;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            float f = svFValueArr[j];
            int wt = (int)svWeightsArr[j];
            for (int w = 0; w < wt; ++w) {
                out[i++] = f;
            }
        }
        return out;
    }

    private double[] convertToDoubleStream(double[] svDValueArr, long[] svWeightsArr, int totalCount) {
        double[] out = new double[totalCount];
        int len = svWeightsArr.length;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            double d = svDValueArr[j];
            int wt = (int)svWeightsArr[j];
            for (int w = 0; w < wt; ++w) {
                out[i++] = d;
            }
        }
        return out;
    }

    private long[] convertToCumWeights(long[] weights) {
        int len = weights.length;
        long[] out = new long[len];
        out[0] = weights[0];
        for (int i = 1; i < len; ++i) {
            out[i] = weights[i] + out[i - 1];
        }
        return out;
    }

    private static final void println(Object o) {
    }
}

