/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectCompactFloatsSketch;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscFloatsTest {
    static final String LS = System.getProperty("line.separator");
    private final MemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkConvertToCumulative() {
        long[] array = new long[]{1L, 2L, 3L, 2L, 1L};
        long out = KllHelper.convertToCumulative((long[])array);
        Assert.assertEquals((long)out, (long)9L);
    }

    @Test
    public void checkSortedViewConstruction() {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            kll.update((float)i);
        }
        FloatsSortedView fsv = kll.getSortedView();
        long[] cumWeights = fsv.getCumulativeWeights();
        float[] values = fsv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((float)values[i], (float)(i + 1));
        }
    }

    @Test
    public void checkBounds() {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        for (int i = 0; i < 1000; ++i) {
            kll.update((float)i);
        }
        double eps = kll.getNormalizedRankError(false);
        float est = kll.getQuantile(0.5);
        float ub = kll.getQuantileUpperBound(0.5);
        float lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((float)ub, (float)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((float)lb, (float)kll.getQuantile(0.5 - eps));
        KllMiscFloatsTest.println("Ext     : " + est);
        KllMiscFloatsTest.println("UB      : " + ub);
        KllMiscFloatsTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(6L, (byte)3);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(1.0f);
        sk.update(2.0f);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(1L, (byte)0);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(2L, (byte)0);
        KllFloatsSketch.heapify((Memory)wmem);
    }

    @Test
    public void checkMisc() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)8);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        for (int i = 0; i < 20; ++i) {
            sk.update((float)i);
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
        sk.toByteArray();
        float[] items = sk.getFloatItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray();
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    public void visualCheckToString() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 0; i < 10; ++i) {
            sketch.update((float)(i + 1));
        }
        String s1 = sketch.toString(true, true);
        KllMiscFloatsTest.println(s1);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 0; i < 400; ++i) {
            sketch2.update((float)(i + 1));
        }
        KllMiscFloatsTest.println("\n" + sketch2.toString(true, true));
        sketch2.merge((KllSketch)sketch);
        String s2 = sketch2.toString(true, true);
        KllMiscFloatsTest.println(LS + s2);
    }

    @Test
    public void viewCompactions() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        KllMiscFloatsTest.show(sk, 20);
        KllMiscFloatsTest.show(sk, 21);
        KllMiscFloatsTest.show(sk, 43);
        KllMiscFloatsTest.show(sk, 44);
        KllMiscFloatsTest.show(sk, 54);
        KllMiscFloatsTest.show(sk, 55);
        KllMiscFloatsTest.show(sk, 73);
        KllMiscFloatsTest.show(sk, 74);
        KllMiscFloatsTest.show(sk, 88);
        KllMiscFloatsTest.show(sk, 89);
        KllMiscFloatsTest.show(sk, 96);
        KllMiscFloatsTest.show(sk, 97);
        KllMiscFloatsTest.show(sk, 108);
    }

    @Test
    public void viewCompactionAndSortedView() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        KllMiscFloatsTest.show(sk, 20);
        FloatsSortedView sv = sk.getSortedView();
        FloatsSortedViewIterator itr = sv.iterator();
        KllMiscFloatsTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            float v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscFloatsTest.printf("%12.1f%12d\n", Float.valueOf(v), wt);
        }
    }

    private static void show(KllFloatsSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((float)(i + 1));
        }
        KllMiscFloatsTest.println(sk.toString(true, true));
    }

    @Test
    public void checkGrowLevels() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray()[2], (int)33);
    }

    @Test
    public void checkSketchInitializeFloatHeap() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL HEAP");
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT HEAP EMPTY");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)Float.NaN);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)Float.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT HEAP SINGLE");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeFloatHeapifyCompactMem() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL HEAPIFIED FROM COMPACT");
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        KllMiscFloatsTest.println(sk2.toString(true, true));
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        KllFloatsSketch sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)Float.NaN);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)Float.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        sk2.update(1.0f);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllFloatsSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeFloatHeapifyUpdatableMem() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL HEAPIFIED FROM UPDATABLE");
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        KllHeapFloatsSketch sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)21.0f);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)Float.NaN);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)Float.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        sk2.update(1.0f);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscFloatsTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((float)sk.getMaxFloatItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMinFloatItem(), (float)1.0f);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringFloatCompact() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL COMPACT");
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        byte[] compBytes = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        KllFloatsSketch sk2 = KllFloatsSketch.heapify((Memory)wmem);
        byte[] compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY COMPACT");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllFloatsSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE COMPACT");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllFloatsSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkMemoryToStringFloatUpdatable() {
        int k = 20;
        KllMiscFloatsTest.println("#### CASE: FLOAT FULL UPDATABLE");
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((float)i);
        }
        byte[] upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        KllHeapFloatsSketch sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        byte[] upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((long)sk.getN(), (long)sk2.getN());
        Assert.assertEquals((float)sk.getMinItem(), (float)sk2.getMinItem());
        Assert.assertEquals((float)sk.getMaxItem(), (float)sk2.getMaxItem());
        Assert.assertEquals((int)sk.getNumRetained(), (int)sk2.getNumRetained());
        KllMiscFloatsTest.println("#### CASE: FLOAT EMPTY UPDATABLE");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscFloatsTest.println("#### CASE: FLOAT SINGLE UPDATABLE");
        sk = KllFloatsSketch.newHeapInstance((int)k);
        sk.update(1.0f);
        upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscFloatsTest.println(s);
        sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        KllMiscFloatsTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscFloatsTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int m = 8;
        int n1 = 21;
        int n2 = 43;
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        WritableMemory wmem2 = WritableMemory.allocate((int)3000);
        KllDirectFloatsSketch sk1 = KllDirectFloatsSketch.newDirectInstance((int)k, (int)m, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        KllDirectFloatsSketch sk2 = KllDirectFloatsSketch.newDirectInstance((int)k, (int)m, (WritableMemory)wmem2, (MemoryRequestServer)this.memReqSvr);
        for (i = 1; i <= n1; ++i) {
            sk1.update((float)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((float)(i + 100));
        }
        sk1.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk1.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk1.getMaxItem(), (double)143.0);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllFloatsSketch skHeap = KllFloatsSketch.newHeapInstance((int)k);
        skHeap.update(1.0f);
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapFloatsSketch));
        Assert.assertEquals((float)skHeap.getFloatSingleItem(), (float)1.0f);
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)skHeap));
        KllFloatsSketch skDirect = KllFloatsSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)this.memReqSvr);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectFloatsSketch));
        Assert.assertEquals((float)skDirect.getFloatSingleItem(), (float)1.0f);
        Memory srcMem2 = Memory.wrap((byte[])skHeap.toByteArray());
        KllFloatsSketch skCompact = KllFloatsSketch.wrap((Memory)srcMem2);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectCompactFloatsSketch));
        Assert.assertEquals((float)skCompact.getFloatSingleItem(), (float)1.0f);
    }

    public void checkInheritanceArtifacts() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        try {
            sk.getDoubleItemsArray();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMaxDoubleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinDoubleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setDoubleItemsArray(null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setDoubleItemsArrayAt(0, 0.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMaxDoubleItem(0.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setMinDoubleItem(0.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscFloatsTest.println(s);
        KllMiscFloatsTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

