/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDoublesSketchIteratorTest {
    @Test
    public void emptySketch() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        QuantilesDoublesSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        QuantilesDoublesSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)it.getQuantile(), (double)0.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
            for (int i = 0; i < n; ++i) {
                sketch.update((double)i);
            }
            QuantilesDoublesSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

