/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.IntersectionImpl;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapIntersectionTest {
    @Test
    public void checkExactIntersectionNoOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 256; ++i) {
            usk1.update((long)i);
        }
        for (i = 256; i < 512; ++i) {
            usk2.update((long)i);
        }
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)usk1);
        inter.intersect((Sketch)usk2);
        boolean ordered = true;
        Assert.assertTrue((boolean)inter.hasResult());
        CompactSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        rsk1 = inter.getResult(false, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        rsk1 = inter.getResult(true, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)0.0);
        Assert.assertFalse((boolean)inter.isSameResource((Memory)mem));
    }

    @Test
    public void checkExactIntersectionFullOverlap() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(512).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 512; ++i) {
            usk1.update((long)i);
        }
        for (i = 0; i < 512; ++i) {
            usk2.update((long)i);
        }
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)usk1);
        inter.intersect((Sketch)usk2);
        boolean ordered = true;
        CompactSketch rsk1 = inter.getResult(false, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, null);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        int bytes = rsk1.getCompactBytes();
        byte[] byteArray = new byte[bytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        rsk1 = inter.getResult(false, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
        rsk1 = inter.getResult(true, mem);
        Assert.assertEquals((double)rsk1.getEstimate(), (double)512.0);
    }

    @Test
    public void checkIntersectionEarlyStop() {
        int i;
        int lgK = 10;
        int k = 1024;
        int u = 4096;
        UpdateSketch usk1 = UpdateSketch.builder().setNominalEntries(1024).build();
        UpdateSketch usk2 = UpdateSketch.builder().setNominalEntries(1024).build();
        for (i = 0; i < 4096; ++i) {
            usk1.update((long)i);
        }
        for (i = 2048; i < 6144; ++i) {
            usk2.update((long)i);
        }
        CompactSketch csk1 = usk1.compact(true, null);
        CompactSketch csk2 = usk2.compact(true, null);
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)csk1);
        inter.intersect((Sketch)csk2);
        CompactSketch rsk1 = inter.getResult(true, null);
        double result = rsk1.getEstimate();
        double sd2err = 4096.0 / Math.sqrt(1024.0);
        Assert.assertEquals((double)result, (double)2048.0, (double)sd2err);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkNoCall() {
        Intersection inter = SetOperation.builder().buildIntersection();
        Assert.assertFalse((boolean)inter.hasResult());
        inter.getResult(false, null);
    }

    @Test
    public void checkIntersectionNull() {
        Intersection inter = SetOperation.builder().buildIntersection();
        Sketch sk = null;
        try {
            inter.intersect(sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            inter.intersect(sk, sk);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void check1stCall() {
        int lgK = 9;
        int k = 512;
        UpdateSketch sk = UpdateSketch.builder().setNominalEntries(512).build();
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk);
        CompactSketch rsk1 = inter.getResult(false, null);
        double est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk = UpdateSketch.builder().setNominalEntries(512).build();
        sk.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk);
        rsk1 = inter.getResult(false, null);
        est = rsk1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterEmpty() {
        UpdateSketch sk1 = UpdateSketch.builder().build();
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.intersect((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void check2ndCallAfterValid() {
        UpdateSketch sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().build();
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(1L);
        inter.intersect((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)1.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
        sk1 = UpdateSketch.builder().build();
        sk1.update(1L);
        inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk1);
        sk2 = UpdateSketch.builder().build();
        sk2.update(2L);
        inter.intersect((Sketch)sk2);
        comp1 = inter.getResult(false, null);
        est = comp1.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkEstimatingIntersect() {
        int i;
        int lgK = 9;
        int k = 512;
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        HeapIntersectionTest.println("sk1: " + sk1.getEstimate());
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)sk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        HeapIntersectionTest.println("sk2: " + sk2.getEstimate());
        inter.intersect((Sketch)sk2);
        CompactSketch comp1 = inter.getResult(false, null);
        double est = comp1.getEstimate();
        Assert.assertTrue((est > 512.0 ? 1 : 0) != 0);
        HeapIntersectionTest.println("Est: " + est);
    }

    @Test
    public void checkHeapifyAndWrap() {
        int lgK = 9;
        int k = 512;
        UpdateSketch sk1 = UpdateSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        CompactSketch cSk1 = sk1.compact(true, null);
        double cSk1Est = cSk1.getEstimate();
        HeapIntersectionTest.println("cSk1Est: " + cSk1Est);
        Intersection inter = SetOperation.builder().buildIntersection();
        inter.intersect((Sketch)cSk1);
        UpdateSketch sk2 = UpdateSketch.builder().setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk2.update((long)i);
        }
        CompactSketch cSk2 = sk2.compact(true, null);
        double cSk2Est = cSk2.getEstimate();
        HeapIntersectionTest.println("cSk2Est: " + cSk2Est);
        Assert.assertEquals((double)cSk2Est, (double)cSk1Est, (double)0.0);
        inter.intersect((Sketch)cSk2);
        CompactSketch interResultCSk1 = inter.getResult(false, null);
        double inter1est = interResultCSk1.getEstimate();
        Assert.assertEquals((double)inter1est, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("Inter1Est: " + inter1est);
        byte[] byteArray = inter.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)mem);
        CompactSketch heapifiedSk = inter2.getResult(false, null);
        double heapifiedEst = heapifiedSk.getEstimate();
        Assert.assertEquals((double)heapifiedEst, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("HeapifiedEst: " + heapifiedEst);
        Intersection inter3 = Sketches.wrapIntersection((WritableMemory)mem);
        CompactSketch wrappedSk = inter3.getResult(false, null);
        double wrappedEst = wrappedSk.getEstimate();
        Assert.assertEquals((double)wrappedEst, (double)cSk1Est, (double)0.0);
        HeapIntersectionTest.println("WrappedEst: " + wrappedEst);
        inter.reset();
        inter2.reset();
        inter3.reset();
    }

    @Test
    public void checkPreject() {
        UpdateSketch sk = UpdateSketch.builder().setP(0.5f).build();
        sk.update(7L);
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)0);
    }

    @Test
    public void checkHeapifyVirginEmpty() {
        int lgK = 5;
        int k = 32;
        Intersection inter1 = SetOperation.builder().buildIntersection();
        Memory srcMem = Memory.wrap((byte[])inter1.toByteArray());
        Intersection inter2 = (Intersection)SetOperation.heapify((Memory)srcMem);
        Assert.assertFalse((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        UpdateSketch sk1 = UpdateSketch.builder().setP(0.5f).setNominalEntries(32).build();
        sk1.update(7L);
        inter1.intersect((Sketch)sk1);
        Assert.assertFalse((boolean)inter1.isEmpty());
        Assert.assertTrue((boolean)inter1.hasResult());
        Assert.assertFalse((boolean)inter2.hasResult());
        srcMem = Memory.wrap((byte[])inter1.toByteArray());
        inter2 = (Intersection)SetOperation.heapify((Memory)srcMem);
        Assert.assertFalse((boolean)inter2.isEmpty());
        Assert.assertTrue((boolean)inter2.hasResult());
        CompactSketch comp = inter2.getResult(true, null);
        Assert.assertEquals((int)comp.getRetainedEntries(false), (int)0);
        Assert.assertFalse((boolean)comp.isEmpty());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreambleLongs() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        mem.putByte(0L, (byte)2);
        SetOperation.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        mem.putByte(1L, (byte)2);
        SetOperation.heapify((Memory)mem);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkFamilyID() {
        int k = 32;
        Union union = SetOperation.builder().setNominalEntries(32).buildUnion();
        byte[] byteArray = union.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArray);
        Intersection inter1 = (Intersection)SetOperation.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadEmptyState() {
        Intersection inter1 = SetOperation.builder().buildIntersection();
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        inter1.intersect((Sketch)sk);
        byte[] byteArray = inter1.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        mem.putInt(8L, 1);
        SetOperation.heapify((Memory)mem);
    }

    @Test
    public void checkEmpty() {
        UpdateSketch usk = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)usk);
        Assert.assertTrue((boolean)inter.isEmpty());
        Assert.assertEquals((int)inter.getRetainedEntries(), (int)0);
        Assert.assertTrue((inter.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)inter.getThetaLong(), (long)Long.MAX_VALUE);
        long[] longArr = inter.getCache();
        Assert.assertEquals((int)longArr.length, (int)0);
    }

    @Test
    public void checkOne() {
        UpdateSketch usk = Sketches.updateSketchBuilder().build();
        usk.update(1L);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)usk);
        Assert.assertFalse((boolean)inter.isEmpty());
        Assert.assertEquals((int)inter.getRetainedEntries(), (int)1);
        Assert.assertTrue((inter.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)inter.getThetaLong(), (long)Long.MAX_VALUE);
        long[] longArr = inter.getCache();
        Assert.assertEquals((int)longArr.length, (int)32);
    }

    @Test
    public void checkGetResult() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)sk);
        CompactSketch csk = inter.getResult();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void checkFamily() {
        IntersectionImpl impl = IntersectionImpl.initNewHeapInstance((long)9001L);
        Assert.assertEquals((Object)impl.getFamily(), (Object)Family.INTERSECTION);
    }

    @Test
    public void checkPairIntersectSimple() {
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skB = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        CompactSketch csk = inter.intersect((Sketch)skA, (Sketch)skB);
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test
    public void printlnTest() {
        HeapIntersectionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

