/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.ReservoirLongsSketch;
import org.apache.datasketches.sampling.ReservoirLongsSketchTest;
import org.apache.datasketches.sampling.ReservoirLongsUnion;
import org.apache.datasketches.sampling.ReservoirSize;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirLongsUnionTest {
    @Test
    public void checkEmptyUnion() {
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        byte[] unionBytes = rlu.toByteArray();
        Assert.assertEquals((int)unionBytes.length, (int)8);
        ReservoirLongsUnionTest.println(rlu.toString());
    }

    @Test
    public void checkInstantiation() {
        int n = 100;
        int k = 25;
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)25);
        Assert.assertNull((Object)rlu.getResult());
        rlu.update(5L);
        Assert.assertNotNull((Object)rlu.getResult());
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)25);
        for (int i = 0; i < 100; ++i) {
            rls.update((long)i);
        }
        rlu.reset();
        Assert.assertEquals((long)rlu.getResult().getN(), (long)0L);
        rlu.update(rls);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)rls.getN());
        byte[] sketchBytes = rls.toByteArray();
        Memory mem = Memory.wrap((byte[])sketchBytes);
        rlu = ReservoirLongsUnion.newInstance((int)rls.getK());
        rlu.update(mem);
        Assert.assertNotNull((Object)rlu.getResult());
        ReservoirLongsUnionTest.println(rlu.toString());
    }

    @Test
    public void checkNullUpdate() {
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        Assert.assertNull((Object)rlu.getResult());
        rlu.update((ReservoirLongsSketch)null);
        Assert.assertNull((Object)rlu.getResult());
        rlu.update((Memory)null);
        Assert.assertNull((Object)rlu.getResult());
        rlu.update(5L);
        Assert.assertNotNull((Object)rlu.getResult());
    }

    @Test
    public void checkSerialization() {
        int n = 100;
        int k = 25;
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)25);
        for (int i = 0; i < 100; ++i) {
            rlu.update((long)i);
        }
        byte[] unionBytes = rlu.toByteArray();
        Memory mem = Memory.wrap((byte[])unionBytes);
        ReservoirLongsUnion rebuiltUnion = ReservoirLongsUnion.heapify((Memory)mem);
        ReservoirLongsUnionTest.validateUnionEquality(rlu, rebuiltUnion);
    }

    @Test
    public void checkVersionConversionWithEmptyGadget() {
        int k = 32768;
        short encK = ReservoirSize.computeSize((int)32768);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)32768);
        byte[] unionBytesOrig = rlu.toByteArray();
        byte[] unionBytes = rlu.toByteArray();
        WritableMemory unionMem = WritableMemory.writableWrap((byte[])unionBytes);
        unionMem.putByte(1L, (byte)1);
        unionMem.putInt(4L, 0);
        unionMem.putShort(4L, encK);
        ReservoirLongsUnionTest.println(PreambleUtil.preambleToString((Memory)unionMem));
        ReservoirLongsUnion rebuilt = ReservoirLongsUnion.heapify((Memory)unionMem);
        byte[] rebuiltBytes = rebuilt.toByteArray();
        Assert.assertEquals((int)unionBytesOrig.length, (int)rebuiltBytes.length);
        for (int i = 0; i < unionBytesOrig.length; ++i) {
            Assert.assertEquals((byte)unionBytesOrig[i], (byte)rebuiltBytes[i]);
        }
    }

    @Test
    public void checkVersionConversionWithGadget() {
        long n = 32L;
        int k = 256;
        short encK = ReservoirSize.computeSize((int)256);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)256);
        for (long i = 0L; i < 32L; ++i) {
            rlu.update(i);
        }
        byte[] unionBytesOrig = rlu.toByteArray();
        byte[] unionBytes = rlu.toByteArray();
        WritableMemory unionMem = WritableMemory.writableWrap((byte[])unionBytes);
        unionMem.putByte(1L, (byte)1);
        unionMem.putInt(4L, 0);
        unionMem.putShort(4L, encK);
        int offset = Family.RESERVOIR_UNION.getMaxPreLongs() << 3;
        unionMem.putByte((long)(offset + 1), (byte)1);
        unionMem.putInt((long)(offset + 4), 0);
        unionMem.putShort((long)(offset + 4), encK);
        ReservoirLongsUnion rebuilt = ReservoirLongsUnion.heapify((Memory)unionMem);
        byte[] rebuiltBytes = rebuilt.toByteArray();
        Assert.assertEquals((int)unionBytesOrig.length, (int)rebuiltBytes.length);
        for (int i = 0; i < unionBytesOrig.length; ++i) {
            Assert.assertEquals((byte)unionBytesOrig[i], (byte)rebuiltBytes[i]);
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void checkNullMemoryInstantiation() {
        ReservoirLongsUnion.heapify(null);
    }

    @Test
    public void checkDownsampledUpdate() {
        int bigK = 1024;
        int bigN = 131072;
        int smallK = 256;
        int smallN = 2048;
        ReservoirLongsSketch sketch1 = ReservoirLongsUnionTest.getBasicSketch(2048, 256);
        ReservoirLongsSketch sketch2 = ReservoirLongsUnionTest.getBasicSketch(131072, 1024);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)256);
        Assert.assertEquals((int)rlu.getMaxK(), (int)256);
        rlu.update(sketch1);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)256);
        rlu.update(sketch2);
        Assert.assertEquals((int)rlu.getResult().getK(), (int)256);
        Assert.assertEquals((int)rlu.getResult().getNumSamples(), (int)256);
    }

    @Test
    public void checkUnionResetWithInitialSmallK() {
        int maxK = 25;
        int sketchK = 10;
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)25);
        ReservoirLongsSketch rls = ReservoirLongsUnionTest.getBasicSketch(20, 10);
        rlu.update(rls);
        Assert.assertEquals((int)rlu.getMaxK(), (int)25);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)10);
        rlu.reset();
        Assert.assertNotNull((Object)rlu.getResult());
        rls = ReservoirLongsUnionTest.getBasicSketch(50, 26);
        rlu.update(rls);
        Assert.assertEquals((int)rlu.getMaxK(), (int)25);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)25);
    }

    @Test
    public void checkNewGadget() {
        int maxK = 1024;
        int bigK = 1536;
        int smallK = 128;
        ReservoirLongsSketch bigKSketch = ReservoirLongsUnionTest.getBasicSketch(512, 1536);
        byte[] bigKBytes = bigKSketch.toByteArray();
        Memory bigKMem = Memory.wrap((byte[])bigKBytes);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(bigKMem);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)512L);
        ReservoirLongsSketch smallKSketch = ReservoirLongsUnionTest.getBasicSketch(1024, 128);
        byte[] smallKBytes = smallKSketch.toByteArray();
        Memory smallKMem = Memory.wrap((byte[])smallKBytes);
        rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(smallKMem);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertTrue((rlu.getResult().getK() < 1024 ? 1 : 0) != 0);
        Assert.assertEquals((int)rlu.getResult().getK(), (int)128);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)1024L);
        ReservoirLongsSketch smallKExactSketch = ReservoirLongsUnionTest.getBasicSketch(128, 128);
        byte[] smallKExactBytes = smallKExactSketch.toByteArray();
        Memory smallKExactMem = Memory.wrap((byte[])smallKExactBytes);
        rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(smallKExactMem);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)128L);
    }

    @Test
    public void checkStandardMergeNoCopy() {
        int k = 1024;
        int n1 = 256;
        int n2 = 256;
        ReservoirLongsSketch sketch1 = ReservoirLongsUnionTest.getBasicSketch(256, 1024);
        ReservoirLongsSketch sketch2 = ReservoirLongsUnionTest.getBasicSketch(256, 1024);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(sketch1);
        rlu.update(sketch2);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)512L);
        Assert.assertEquals((int)rlu.getResult().getNumSamples(), (int)512);
        int n3 = 2048;
        ReservoirLongsSketch sketch3 = ReservoirLongsUnionTest.getBasicSketch(2048, 1024);
        byte[] sketch3Bytes = sketch3.toByteArray();
        Memory mem = Memory.wrap((byte[])sketch3Bytes);
        rlu.update(mem);
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)2560L);
        Assert.assertEquals((int)rlu.getResult().getNumSamples(), (int)1024);
    }

    @Test
    public void checkStandardMergeWithCopy() {
        int k = 1024;
        int n1 = 768;
        int n2 = 2048;
        ReservoirLongsSketch sketch1 = ReservoirLongsUnionTest.getBasicSketch(768, 1024);
        ReservoirLongsSketch sketch2 = ReservoirLongsUnionTest.getBasicSketch(2048, 1024);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(sketch1);
        rlu.update(sketch2);
        rlu.update(10L);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)2817L);
        Assert.assertEquals((int)rlu.getResult().getNumSamples(), (int)1024);
    }

    @Test
    public void checkWeightedMerge() {
        int k = 1024;
        int n1 = 16384;
        int n2 = 2048;
        ReservoirLongsSketch sketch1 = ReservoirLongsUnionTest.getBasicSketch(16384, 1024);
        ReservoirLongsSketch sketch2 = ReservoirLongsUnionTest.getBasicSketch(2048, 1024);
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(sketch1);
        rlu.update(sketch2);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)18432L);
        Assert.assertEquals((int)rlu.getResult().getNumSamples(), (int)1024);
        rlu = ReservoirLongsUnion.newInstance((int)1024);
        rlu.update(sketch2);
        rlu.update(sketch1);
        Assert.assertNotNull((Object)rlu.getResult());
        Assert.assertEquals((int)rlu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)rlu.getResult().getN(), (long)18432L);
        Assert.assertEquals((int)rlu.getResult().getNumSamples(), (int)1024);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreLongs() {
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        WritableMemory mem = WritableMemory.writableWrap((byte[])rlu.toByteArray());
        mem.putByte(0L, (byte)0);
        ReservoirLongsUnion.heapify((Memory)mem);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        WritableMemory mem = WritableMemory.writableWrap((byte[])rlu.toByteArray());
        mem.putByte(1L, (byte)0);
        ReservoirLongsUnion.heapify((Memory)mem);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        ReservoirLongsUnion rlu = ReservoirLongsUnion.newInstance((int)1024);
        WritableMemory mem = WritableMemory.writableWrap((byte[])rlu.toByteArray());
        mem.putByte(2L, (byte)0);
        ReservoirLongsUnion.heapify((Memory)mem);
        Assert.fail();
    }

    private static void validateUnionEquality(ReservoirLongsUnion rlu1, ReservoirLongsUnion rlu2) {
        Assert.assertEquals((int)rlu1.getMaxK(), (int)rlu2.getMaxK());
        ReservoirLongsSketchTest.validateReservoirEquality(rlu1.getResult(), rlu2.getResult());
    }

    private static ReservoirLongsSketch getBasicSketch(int n, int k) {
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)k);
        for (int i = 0; i < n; ++i) {
            rls.update((long)i);
        }
        return rls;
    }

    private static void println(String msg) {
    }
}

