/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.req.ReqAuxiliary;
import org.apache.datasketches.req.ReqDebug;
import org.apache.datasketches.req.ReqDebugImpl;
import org.apache.datasketches.req.ReqIterator;
import org.apache.datasketches.req.ReqSketch;
import org.apache.datasketches.req.ReqSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReqSketchTest {
    private static final String LS = System.getProperty("line.separator");
    private static final int skDebug = 0;
    private static final int iDebug = 0;

    @Test
    public void bigTest() {
        this.bigTestImpl(6, 1, 200, true, true, true, 0);
        this.bigTestImpl(6, 1, 200, false, false, true, 0);
        this.bigTestImpl(6, 1, 200, false, true, false, 0);
        this.bigTestImpl(6, 1, 200, true, false, true, 0);
    }

    public void bigTestImpl(int k, int min, int max, boolean up, boolean hra, boolean ltEq, int skDebug) {
        ReqSketch sk = this.loadSketch(k, min, max, up, hra, ltEq, skDebug);
        ReqSketchTest.checkToString(sk, 0);
        ReqSketchTest.checkAux(sk, 0);
        ReqSketchTest.checkGetRank(sk, min, max, 0);
        ReqSketchTest.checkGetRanks(sk, max, 0);
        ReqSketchTest.checkGetQuantiles(sk, 0);
        ReqSketchTest.checkGetCDF(sk, 0);
        ReqSketchTest.checkGetPMF(sk, 0);
        ReqSketchTest.checkIterator(sk, 0);
        ReqSketchTest.checkMerge(sk, 0);
        ReqSketchTest.printBoundary(skDebug);
        sk.reset();
    }

    public ReqSketch loadSketch(int k, int min, int max, boolean up, boolean hra, boolean ltEq, int skDebug) {
        ReqSketchBuilder bldr = ReqSketch.builder();
        bldr.setReqDebug((ReqDebug)new ReqDebugImpl(skDebug, "%5.0f"));
        bldr.setK(k);
        bldr.setHighRankAccuracy(hra);
        ReqSketch sk = bldr.build();
        sk.setLessThanOrEqual(ltEq);
        if (up) {
            for (int i = min; i <= max; ++i) {
                sk.update((float)i);
            }
        } else {
            int i = max + 1;
            while (i-- > min) {
                sk.update((float)i);
            }
        }
        return sk;
    }

    private static void printBoundary(int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("===========================================================");
        }
    }

    private static void checkToString(ReqSketch sk, int iDebug) {
        boolean summary = iDebug == 1;
        boolean allData = iDebug == 2;
        String brief = sk.toString();
        String all = sk.viewCompactorDetail("%4.0f", true);
        if (summary) {
            ReqSketchTest.println(brief);
            ReqSketchTest.println(sk.viewCompactorDetail("%4.0f", false));
        }
        if (allData) {
            ReqSketchTest.println(brief);
            ReqSketchTest.println(all);
        }
    }

    private static void checkGetRank(ReqSketch sk, int min, int max, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetRank Test:");
        }
        float[] spArr = Util.evenlySpacedFloats((float)0.0f, (float)max, (int)11);
        String dfmt = "%10.2f%10.6f" + LS;
        String sfmt = "%10s%10s" + LS;
        if (iDebug > 0) {
            ReqSketchTest.printf(sfmt, "Value", "Rank");
        }
        double slope = max - min + min;
        float va = 0.0f;
        double ranka = 0.0;
        for (int i = 0; i < spArr.length; ++i) {
            float v = spArr[i];
            double rank = sk.getRank(v);
            if (iDebug > 0) {
                ReqSketchTest.printf(dfmt, Float.valueOf(v), rank);
            }
            if (i == 0) {
                va = v;
                ranka = rank;
                continue;
            }
            Assert.assertTrue((v >= va ? 1 : 0) != 0);
            Assert.assertTrue((rank >= ranka ? 1 : 0) != 0);
            va = v;
            ranka = rank;
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkGetRanks(ReqSketch sk, int max, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetRanks Test:");
        }
        float[] sp = Util.evenlySpacedFloats((float)0.0f, (float)max, (int)11);
        String dfmt = "%10.2f%10.6f" + LS;
        String sfmt = "%10s%10s" + LS;
        if (iDebug > 0) {
            ReqSketchTest.printf(sfmt, "Value", "Rank");
        }
        double[] nRanks = sk.getRanks(sp);
        for (int i = 0; i < nRanks.length; ++i) {
            if (iDebug <= 0) continue;
            ReqSketchTest.printf(dfmt, Float.valueOf(sp[i]), nRanks[i]);
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkAux(ReqSketch sk, int iDebug) {
        ReqAuxiliary aux = new ReqAuxiliary(sk);
        if (iDebug > 0) {
            ReqSketchTest.println(aux.toString(3, 12));
        }
        int totalCount = sk.getRetainedItems();
        float item = 0.0f;
        long wt = 0L;
        for (int i = 0; i < totalCount; ++i) {
            ReqAuxiliary.Row row = aux.getRow(i);
            if (i == 0) {
                item = row.item;
                wt = row.weight;
                continue;
            }
            Assert.assertTrue((row.item >= item ? 1 : 0) != 0);
            Assert.assertTrue((row.weight >= wt ? 1 : 0) != 0);
            item = row.item;
            wt = row.weight;
        }
    }

    private static void checkGetQuantiles(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetQuantiles() Test");
        }
        double[] rArr = new double[]{0.0, 0.1f, 0.2f, 0.3f, 0.4f, 0.5, 0.6f, 0.7f, 0.8f, 0.9f, 1.0};
        float[] qOut = sk.getQuantiles(rArr);
        if (iDebug > 0) {
            for (int i = 0; i < qOut.length; ++i) {
                String r = String.format("%6.3f", rArr[i]);
                ReqSketchTest.println("nRank: " + r + ", q: " + qOut[i]);
            }
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkGetCDF(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetCDF() Test");
        }
        float[] spArr = new float[]{20.0f, 40.0f, 60.0f, 80.0f, 100.0f, 120.0f, 140.0f, 160.0f, 180.0f};
        double[] cdf = sk.getCDF(spArr);
        if (iDebug > 0) {
            for (int i = 0; i < cdf.length; ++i) {
                float sp = i == spArr.length ? sk.getMaxValue() : spArr[i];
                ReqSketchTest.println("SP: " + sp + ", Den: " + cdf[i]);
            }
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkGetPMF(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("GetPMF() Test");
        }
        float[] spArr = new float[]{20.0f, 40.0f, 60.0f, 80.0f, 100.0f, 120.0f, 140.0f, 160.0f, 180.0f};
        double[] pmf = sk.getPMF(spArr);
        if (iDebug > 0) {
            for (int i = 0; i < pmf.length; ++i) {
                float sp = i == spArr.length ? sk.getMaxValue() : spArr[i];
                ReqSketchTest.println("SP: " + sp + ", Mass: " + pmf[i]);
            }
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkIterator(ReqSketch sk, int iDebug) {
        if (iDebug > 0) {
            ReqSketchTest.println("iterator() Test");
        }
        ReqIterator itr = sk.iterator();
        while (itr.next()) {
            float v = itr.getValue();
            long wt = itr.getWeight();
            int cnt = itr.getCount();
            if (iDebug <= 0) continue;
            ReqSketchTest.println("count=" + cnt + " v=" + v + " wt=" + wt);
        }
        if (iDebug > 0) {
            ReqSketchTest.println("");
        }
    }

    private static void checkMerge(ReqSketch sk, int iDebug) {
        boolean summary;
        boolean allData = iDebug > 1;
        boolean bl = summary = iDebug > 0;
        if (summary) {
            ReqSketchTest.println("Merge Test");
            ReqSketchTest.println("Before Merge:");
            ReqSketchTest.outputCompactorDetail(sk, "%5.0f", allData, "Host Sketch:");
        }
        ReqSketch sk2 = new ReqSketch(sk);
        if (summary) {
            ReqSketchTest.outputCompactorDetail(sk2, "%5.0f", allData, "Incoming Sketch:");
            ReqSketchTest.println("Merge Process:");
        }
        sk.merge(sk2);
        Assert.assertEquals((long)sk.getN(), (long)400L);
    }

    @Test
    public void merge() {
        ReqSketch s1 = ReqSketch.builder().setK(12).build();
        for (int i = 0; i < 40; ++i) {
            s1.update((float)i);
        }
        ReqSketch s2 = ReqSketch.builder().setK(12).build();
        for (int i = 0; i < 40; ++i) {
            s2.update((float)i);
        }
        ReqSketch s3 = ReqSketch.builder().setK(12).build();
        for (int i = 0; i < 40; ++i) {
            s3.update((float)i);
        }
        ReqSketch s = ReqSketch.builder().setK(12).build();
        s.merge(s1);
        s.merge(s2);
        s.merge(s3);
    }

    @Test
    public void checkValidateSplits() {
        float[] arr = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        ReqSketch.validateSplits((float[])arr);
        try {
            float[] arr1 = new float[]{1.0f, 2.0f, 4.0f, 3.0f, 5.0f};
            ReqSketch.validateSplits((float[])arr1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkSerDe() {
        int k = 12;
        int exact = 71;
        ReqSketchTest.checkSerDeImpl(12, false, 0);
        ReqSketchTest.checkSerDeImpl(12, true, 0);
        ReqSketchTest.checkSerDeImpl(12, false, 4);
        ReqSketchTest.checkSerDeImpl(12, true, 4);
        ReqSketchTest.checkSerDeImpl(12, false, 71);
        ReqSketchTest.checkSerDeImpl(12, true, 71);
        ReqSketchTest.checkSerDeImpl(12, false, 142);
        ReqSketchTest.checkSerDeImpl(12, true, 142);
    }

    private static void checkSerDeImpl(int k, boolean hra, int count) {
        ReqSketch sk1 = ReqSketch.builder().setK(k).setHighRankAccuracy(hra).build();
        for (int i = 1; i <= count; ++i) {
            sk1.update((float)i);
        }
        byte[] sk1Arr = sk1.toByteArray();
        Memory mem = Memory.wrap((byte[])sk1Arr);
        ReqSketch sk2 = ReqSketch.heapify((Memory)mem);
        Assert.assertEquals((int)sk2.getRetainedItems(), (int)sk1.getRetainedItems());
        Assert.assertEquals((float)sk2.getMinValue(), (float)sk1.getMinValue());
        Assert.assertEquals((float)sk2.getMaxValue(), (float)sk1.getMaxValue());
        Assert.assertEquals((long)sk2.getN(), (long)sk1.getN());
        Assert.assertEquals((boolean)sk2.getHighRankAccuracy(), (boolean)sk1.getHighRankAccuracy());
        Assert.assertEquals((int)sk2.getK(), (int)sk1.getK());
        Assert.assertEquals((int)sk2.getMaxNomSize(), (int)sk1.getMaxNomSize());
        Assert.assertEquals((boolean)sk2.getLtEq(), (boolean)sk1.getLtEq());
        Assert.assertEquals((int)sk2.getNumLevels(), (int)sk1.getNumLevels());
        Assert.assertEquals((int)sk2.getSerializationBytes(), (int)sk1.getSerializationBytes());
    }

    @Test
    public void checkK() {
        try {
            ReqSketch sk1 = ReqSketch.builder().setK(1).build();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkAuxDeDup() {
        float[] arr;
        ReqSketchBuilder bldr = ReqSketch.builder();
        bldr.setK(8);
        bldr.setLessThanOrEqual(false);
        bldr.setHighRankAccuracy(true);
        ReqSketch sk1 = ReqSketch.builder().setK(8).build();
        for (float i : arr = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 3.0f, 4.0f, 4.0f}) {
            sk1.update(i);
        }
        float q = sk1.getQuantile(0.5);
        Assert.assertEquals((float)q, (float)3.0f);
        q = sk1.getQuantile(1.0);
        Assert.assertEquals((float)q, (float)4.0f);
    }

    private static void outputCompactorDetail(ReqSketch sk, String fmt, boolean allData, String text) {
        ReqSketchTest.println(text);
        ReqSketchTest.println(sk.viewCompactorDetail(fmt, allData));
    }

    private static final void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    private static final void print(Object o) {
        System.out.print(o.toString());
    }

    private static final void println(Object o) {
        System.out.println(o.toString());
    }
}

