/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Comparator;
import org.apache.datasketches.ArrayOfDoublesSerDe;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerDeCompatibilityTest {
    private static final ArrayOfItemsSerDe<Double> serDe = new ArrayOfDoublesSerDe();

    @Test
    public void itemsToDoubles() {
        ItemsSketch sketch1 = ItemsSketch.getInstance(Comparator.naturalOrder());
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((Object)i);
        }
        byte[] bytes = sketch1.toByteArray(serDe);
        UpdateDoublesSketch sketch2 = UpdateDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((double)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getRetainedItems() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((double)sketch2.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxValue(), (double)1000.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)500.0, (double)17.0);
    }

    @Test
    public void doublesToItems() {
        UpdateDoublesSketch sketch1 = DoublesSketch.builder().build();
        for (int i = 1; i <= 500; ++i) {
            sketch1.update((double)i);
        }
        CompactDoublesSketch cs = sketch1.compact();
        DoublesSketchTest.testSketchEquality((DoublesSketch)sketch1, (DoublesSketch)cs);
        byte[] bytes = cs.toByteArray();
        ItemsSketch sketch2 = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes), Comparator.naturalOrder(), serDe);
        for (int i = 501; i <= 1000; ++i) {
            sketch2.update((Object)i);
        }
        Assert.assertEquals((long)sketch2.getN(), (long)1000L);
        Assert.assertTrue((sketch2.getRetainedItems() < 1000 ? 1 : 0) != 0);
        Assert.assertEquals((double)((Double)sketch2.getMinValue()), (double)1.0);
        Assert.assertEquals((double)((Double)sketch2.getMaxValue()), (double)1000.0);
        Assert.assertEquals((double)((Double)sketch2.getQuantile(0.5)), (double)500.0, (double)17.0);
    }
}

