/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchTest;
import org.apache.datasketches.quantiles.HeapCompactDoublesSketch;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketchTest;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantiles.Util;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DirectCompactDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        DoublesSketch.rand.setSeed(32749L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrapFromUpdateSketch() {
        int k = 4;
        int n = 27;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(4, 27);
        byte[] qsBytes = qs.toByteArray();
        Memory qsMem = Memory.wrap((byte[])qsBytes);
        DirectCompactDoublesSketch.wrapInstance((Memory)qsMem);
        Assert.fail();
    }

    @Test
    public void createFromUnsortedUpdateSketch() {
        int k = 4;
        int n = 13;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(4).build();
        for (int i = 13; i > 0; --i) {
            qs.update((double)i);
        }
        WritableMemory dstMem = WritableMemory.writableWrap((byte[])new byte[qs.getCompactStorageBytes()]);
        DirectCompactDoublesSketch compactQs = DirectCompactDoublesSketch.createFromUpdateSketch((UpdateDoublesSketch)qs, (WritableMemory)dstMem);
        double[] combinedBuffer = compactQs.getCombinedBuffer();
        int bbCount = compactQs.getBaseBufferCount();
        for (int i = 1; i < bbCount; ++i) {
            assert (combinedBuffer[i - 1] < combinedBuffer[i]);
        }
    }

    @Test
    public void wrapFromCompactSketch() {
        int k = 8;
        int n = 177;
        DirectCompactDoublesSketch qs = DirectCompactDoublesSketchTest.buildAndLoadDCQS(8, 177);
        byte[] qsBytes = qs.toByteArray();
        Memory qsMem = Memory.wrap((byte[])qsBytes);
        DirectCompactDoublesSketch compactQs = DirectCompactDoublesSketch.wrapInstance((Memory)qsMem);
        DoublesSketchTest.testSketchEquality((DoublesSketch)qs, (DoublesSketch)compactQs);
        Assert.assertEquals((int)qsBytes.length, (int)compactQs.getStorageBytes());
        double[] combinedBuffer = compactQs.getCombinedBuffer();
        Assert.assertEquals((int)combinedBuffer.length, (int)compactQs.getCombinedBufferItemCapacity());
    }

    @Test
    public void wrapEmptyCompactSketch() {
        CompactDoublesSketch s1 = DoublesSketch.builder().build().compact();
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(s1.toByteArray()).order(ByteOrder.nativeOrder()));
        DoublesSketch s2 = DoublesSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)s2.isEmpty());
        Assert.assertEquals((long)s2.getN(), (long)0L);
        Assert.assertTrue((boolean)Double.isNaN(s2.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(s2.getMaxValue()));
    }

    @Test
    public void checkEmpty() {
        int k = 128;
        DirectCompactDoublesSketch qs1 = DirectCompactDoublesSketchTest.buildAndLoadDCQS(128, 0);
        Assert.assertTrue((boolean)Double.isNaN(qs1.getQuantile(0.0)));
        Assert.assertTrue((boolean)Double.isNaN(qs1.getQuantile(1.0)));
        Assert.assertTrue((boolean)Double.isNaN(qs1.getQuantile(0.5)));
        double[] quantiles = qs1.getQuantiles(new double[]{0.0, 0.5, 1.0});
        Assert.assertNull((Object)quantiles);
        double[] combinedBuffer = qs1.getCombinedBuffer();
        Assert.assertEquals((int)combinedBuffer.length, (int)256);
        Assert.assertNotEquals((Object)combinedBuffer.length, (Object)qs1.getCombinedBufferItemCapacity());
    }

    @Test
    public void checkCheckDirectMemCapacity() {
        int k = 128;
        DirectCompactDoublesSketch.checkDirectMemCapacity((int)128, (long)255L, (long)2080L);
        DirectCompactDoublesSketch.checkDirectMemCapacity((int)128, (long)257L, (long)3104L);
        DirectCompactDoublesSketch.checkDirectMemCapacity((int)128, (long)0L, (long)8L);
        try {
            DirectCompactDoublesSketch.checkDirectMemCapacity((int)128, (long)10000L, (long)64L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmall() {
        Memory mem = Memory.wrap((byte[])new byte[7]);
        HeapCompactDoublesSketch.heapifyInstance((Memory)mem);
    }

    static DirectCompactDoublesSketch buildAndLoadDCQS(int k, int n) {
        return DirectCompactDoublesSketchTest.buildAndLoadDCQS(k, n, 0);
    }

    static DirectCompactDoublesSketch buildAndLoadDCQS(int k, int n, int startV) {
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= n; ++i) {
            qs.update((double)(startV + i));
        }
        byte[] byteArr = new byte[qs.getCompactStorageBytes()];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArr);
        return (DirectCompactDoublesSketch)qs.compact(mem);
    }

    @Test
    public void printlnTest() {
        DirectCompactDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
        DirectCompactDoublesSketchTest.print("PRINTING: " + this.getClass().getName() + Util.LS);
    }

    static void println(String s) {
        DirectCompactDoublesSketchTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

