/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.io.PrintStream;
import org.apache.datasketches.Family;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.datasketches.cpc.CpcWrapper;
import org.apache.datasketches.memory.Memory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CpcWrapperTest {
    static PrintStream ps = System.out;

    @Test
    public void check() {
        int lgK = 10;
        CpcSketch sk1 = new CpcSketch(lgK);
        CpcSketch sk2 = new CpcSketch(lgK);
        CpcSketch skD = new CpcSketch(lgK);
        double dEst = skD.getEstimate();
        double dlb = skD.getLowerBound(2);
        double dub = skD.getUpperBound(2);
        int n = 100000;
        for (int i = 0; i < n; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + n));
            skD.update((long)i);
            skD.update((long)(i + n));
        }
        byte[] concatArr = skD.toByteArray();
        CpcUnion union = new CpcUnion(lgK);
        CpcSketch result = union.getResult();
        double uEst = result.getEstimate();
        double ulb = result.getLowerBound(2);
        double uub = result.getUpperBound(2);
        union.update(sk1);
        union.update(sk2);
        CpcSketch merged = union.getResult();
        byte[] mergedArr = merged.toByteArray();
        Memory concatMem = Memory.wrap((byte[])concatArr);
        CpcWrapper concatSk = new CpcWrapper(concatMem);
        Assert.assertEquals((int)concatSk.getLgK(), (int)lgK);
        CpcWrapperTest.printf("              %12s %12s %12s\n", "Lb", "Est", "Ub");
        double ccEst = concatSk.getEstimate();
        double ccLb = concatSk.getLowerBound(2);
        double ccUb = concatSk.getUpperBound(2);
        CpcWrapperTest.printf("Concatenated: %12.0f %12.0f %12.0f\n", ccLb, ccEst, ccUb);
        CpcWrapper mergedSk = new CpcWrapper(mergedArr);
        double mEst = mergedSk.getEstimate();
        double mLb = mergedSk.getLowerBound(2);
        double mUb = mergedSk.getUpperBound(2);
        CpcWrapperTest.printf("Merged:       %12.0f %12.0f %12.0f\n", mLb, mEst, mUb);
        Assert.assertEquals((Object)Family.CPC, (Object)CpcWrapper.getFamily());
    }

    @Test
    public void checkIsCompressed() {
        CpcSketch sk = new CpcSketch(10);
        byte[] byteArr = sk.toByteArray();
        byteArr[5] = (byte)(byteArr[5] & 0xFFFFFFFD);
        try {
            CpcWrapper wrapper = new CpcWrapper(Memory.wrap((byte[])byteArr));
            Assert.fail();
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    static void printf(String format, Object ... args) {
    }

    static void println(String s) {
    }
}

