/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import java.util.Arrays;
import java.util.Random;
import org.apache.datasketches.cpc.CompressionData;
import org.apache.datasketches.cpc.CpcCompression;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CpcCompressionTest {
    @Test
    public void checkWriteReadUnary() {
        int[] compressedWords = new int[256];
        long[] ptrArr = new long[3];
        int nextWordIndex = 0;
        long bitBuf = 0L;
        int bufBits = 0;
        for (int i = 0; i < 100; ++i) {
            ptrArr[0] = nextWordIndex;
            ptrArr[1] = bitBuf;
            ptrArr[2] = bufBits;
            assert ((long)nextWordIndex == ptrArr[0]);
            CpcCompression.writeUnary((int[])compressedWords, (long[])ptrArr, (int)i);
            nextWordIndex = (int)ptrArr[0];
            bitBuf = ptrArr[1];
            bufBits = (int)ptrArr[2];
            assert ((long)nextWordIndex == ptrArr[0]);
        }
        long padding = 7L;
        if ((bufBits += 7) >= 32) {
            compressedWords[nextWordIndex++] = (int)bitBuf;
            bitBuf >>>= 32;
            bufBits -= 32;
        }
        if (bufBits > 0) {
            assert (bufBits < 32);
            compressedWords[nextWordIndex++] = (int)bitBuf;
        }
        int numWordsUsed = nextWordIndex;
        CpcCompressionTest.println("Words used: " + numWordsUsed);
        nextWordIndex = 0;
        bitBuf = 0L;
        bufBits = 0;
        for (int i = 0; i < 100; ++i) {
            ptrArr[0] = nextWordIndex;
            ptrArr[1] = bitBuf;
            ptrArr[2] = bufBits;
            assert ((long)nextWordIndex == ptrArr[0]);
            long result = CpcCompression.readUnary((int[])compressedWords, (long[])ptrArr);
            CpcCompressionTest.println("Result: " + result + ", expected: " + i);
            Assert.assertEquals((long)result, (long)i);
            nextWordIndex = (int)ptrArr[0];
            bitBuf = ptrArr[1];
            bufBits = (int)ptrArr[2];
            assert ((long)nextWordIndex == ptrArr[0]);
        }
        Assert.assertTrue((nextWordIndex <= numWordsUsed ? 1 : 0) != 0);
    }

    @Test
    public void checkWriteReadBytes() {
        int[] compressedWords = new int[128];
        byte[] byteArray = new byte[256];
        byte[] byteArray2 = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byteArray[i] = (byte)i;
        }
        for (int j = 0; j < 22; ++j) {
            long numWordsWritten = CpcCompression.lowLevelCompressBytes((byte[])byteArray, (int)256, (short[])CompressionData.encodingTablesForHighEntropyByte[j], (int[])compressedWords);
            CpcCompression.lowLevelUncompressBytes((byte[])byteArray2, (int)256, (short[])CompressionData.decodingTablesForHighEntropyByte[j], (int[])compressedWords, (long)numWordsWritten);
            CpcCompressionTest.println("Words used: " + numWordsWritten);
            Assert.assertEquals((byte[])byteArray2, (byte[])byteArray);
        }
    }

    @Test
    public void checkWriteReadBytes65() {
        int size = 65;
        int[] compressedWords = new int[128];
        byte[] byteArray = new byte[65];
        byte[] byteArray2 = new byte[65];
        for (int i = 0; i < 65; ++i) {
            byteArray[i] = (byte)i;
        }
        long numWordsWritten = CpcCompression.lowLevelCompressBytes((byte[])byteArray, (int)65, (short[])CompressionData.lengthLimitedUnaryEncodingTable65, (int[])compressedWords);
        CpcCompression.lowLevelUncompressBytes((byte[])byteArray2, (int)65, (short[])CompressionData.lengthLimitedUnaryDecodingTable65, (int[])compressedWords, (long)numWordsWritten);
        CpcCompressionTest.println("Words used: " + numWordsWritten);
        Assert.assertEquals((byte[])byteArray2, (byte[])byteArray);
    }

    @Test
    public void checkWriteReadPairs() {
        int i;
        Random rgen = new Random(1L);
        int lgK = 14;
        int N = 3000;
        int MAX_WORDS = 4000;
        int[] pairArray = new int[3000];
        int[] pairArray2 = new int[3000];
        for (i = 0; i < 3000; ++i) {
            int rand;
            pairArray[i] = rand = rgen.nextInt(0x100000);
        }
        Arrays.sort(pairArray);
        int prev = -1;
        int nxt = 0;
        for (i = 0; i < 3000; ++i) {
            if (pairArray[i] == prev) continue;
            prev = pairArray[i];
            pairArray[nxt++] = pairArray[i];
        }
        int numPairs = nxt;
        CpcCompressionTest.println("numCsv = " + numPairs);
        int[] compressedWords = new int[4000];
        for (int bb = 0; bb <= 11; ++bb) {
            Long numWordsWritten = CpcCompression.lowLevelCompressPairs((int[])pairArray, (int)numPairs, (int)bb, (int[])compressedWords);
            CpcCompressionTest.println("numWordsWritten = " + numWordsWritten + ", bb = " + bb);
            CpcCompression.lowLevelUncompressPairs((int[])pairArray2, (int)numPairs, (int)bb, (int[])compressedWords, (long)numWordsWritten);
            for (i = 0; i < numPairs; ++i) {
                assert (pairArray[i] == pairArray2[i]);
            }
        }
    }

    @Test
    public void printlnTest() {
        CpcCompressionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

