/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import java.util.Random;
import org.apache.datasketches.BinarySearch;
import org.apache.datasketches.InequalitySearch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BinarySearchTest {
    static Random rand = new Random(1L);
    private static final String LS = System.getProperty("line.separator");

    private static int randDelta() {
        return rand.nextDouble() < 0.4 ? 0 : 1;
    }

    private static float[] buildRandFloatArr(int len) {
        float[] arr = new float[len];
        float v = 1.0f;
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v += (float)BinarySearchTest.randDelta();
        }
        return arr;
    }

    private static double[] buildRandDoubleArr(int len) {
        double[] arr = new double[len];
        double v = 1.0;
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v += (double)BinarySearchTest.randDelta();
        }
        return arr;
    }

    private static long[] buildRandLongArr(int len) {
        long[] arr = new long[len];
        long v = 1L;
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v += (long)(2 * BinarySearchTest.randDelta());
        }
        return arr;
    }

    @Test
    public void checkBinSearchDblLimits() {
        for (int len = 10; len <= 13; ++len) {
            double[] tarr = BinarySearchTest.buildRandDoubleArr(len);
            int low = 2;
            int high = len - 2;
            BinarySearchTest.println(BinarySearchTest.listDblArray(tarr, 2, high));
            BinarySearchTest.checkBinarySearchDoubleLimits(tarr, 2, high);
        }
    }

    private static String listDblArray(double[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        int len = arr.length;
        sb.append("double[" + len + "]: ");
        for (int i = 0; i < len; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%.0f) ", arr[i]));
                continue;
            }
            sb.append(String.format("%.0f ", arr[i]));
        }
        return sb.toString();
    }

    private static void checkBinarySearchDoubleLimits(double[] arr, int low, int high) {
        double lowV = arr[low];
        double highV = arr[high];
        double v = lowV - 1.0;
        int res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((double)arr[res], (double)v);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV + 1.0;
        res = InequalitySearch.find((double[])arr, (int)low, (int)high, (double)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void checkBinSearchFltLimits() {
        for (int len = 10; len <= 13; ++len) {
            float[] tarr = BinarySearchTest.buildRandFloatArr(len);
            int low = 2;
            int high = len - 2;
            BinarySearchTest.println(BinarySearchTest.listFltArray(tarr, 2, high));
            BinarySearchTest.checkBinarySearchFloatLimits(tarr, 2, high);
        }
    }

    private static String listFltArray(float[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        int len = arr.length;
        sb.append("float[" + len + "]: ");
        for (int i = 0; i < len; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%.0f) ", Float.valueOf(arr[i])));
                continue;
            }
            sb.append(String.format("%.0f ", Float.valueOf(arr[i])));
        }
        return sb.toString();
    }

    private static void checkBinarySearchFloatLimits(float[] arr, int low, int high) {
        float lowV = arr[low];
        float highV = arr[high];
        float v = lowV - 1.0f;
        int res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((float)arr[res], (float)v);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV + 1.0f;
        res = InequalitySearch.find((float[])arr, (int)low, (int)high, (float)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void checkBinSearchLongLimits() {
        for (int len = 10; len <= 13; ++len) {
            long[] tarr = BinarySearchTest.buildRandLongArr(len);
            int low = 2;
            int high = len - 2;
            BinarySearchTest.println(BinarySearchTest.listLongArray(tarr, 2, high));
            BinarySearchTest.checkBinarySearchLongLimits(tarr, 2, high);
        }
    }

    private static String listLongArray(long[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        int len = arr.length;
        sb.append("long[" + len + "]: ");
        for (int i = 0; i < len; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%d) ", arr[i]));
                continue;
            }
            sb.append(String.format("%d ", arr[i]));
        }
        return sb.toString();
    }

    private static void checkBinarySearchLongLimits(long[] arr, int low, int high) {
        long lowV = arr[low];
        long highV = arr[high];
        long v = lowV - 1L;
        int res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LT);
        BinarySearchTest.println(InequalitySearch.LT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.LE);
        BinarySearchTest.println(InequalitySearch.LE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)high);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((long)arr[res], (long)v);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.EQ);
        BinarySearchTest.println(InequalitySearch.EQ.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GT);
        BinarySearchTest.println(InequalitySearch.GT.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV - 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)low);
        v = highV + 1L;
        res = InequalitySearch.find((long[])arr, (int)low, (int)high, (long)v, (InequalitySearch)InequalitySearch.GE);
        BinarySearchTest.println(InequalitySearch.GE.desc(arr, low, high, v, res));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void exerciseDblBinSearch() {
        double[] arr = new double[]{1.0, 1.0, 3.0, 3.0, 4.0, 5.0, 5.0};
        BinarySearchTest.checkFindDouble(arr, InequalitySearch.LT);
        BinarySearchTest.checkFindDouble(arr, InequalitySearch.LE);
        BinarySearchTest.checkFindDouble(arr, InequalitySearch.GT);
        BinarySearchTest.checkFindDouble(arr, InequalitySearch.GE);
    }

    private static void checkFindDouble(double[] arr, InequalitySearch crit) {
        BinarySearchTest.println("InequalitySearch: " + crit.name());
        int len = arr.length;
        for (double v = 0.5; v <= arr[len - 1] + 0.5; v += 0.5) {
            boolean low = false;
            int high = len - 1;
            int idx = InequalitySearch.find((double[])arr, (int)0, (int)high, (double)v, (InequalitySearch)crit);
            if (idx == -1) {
                BinarySearchTest.println(v + " Not resolved, return -1.");
                continue;
            }
            BinarySearchTest.println(crit.desc(arr, 0, high, v, idx));
        }
        BinarySearchTest.println("");
    }

    @Test
    public void exerciseFltBinSearch() {
        float[] arr = new float[]{5.0f, 5.0f, 5.0f, 6.0f, 6.0f, 6.0f, 7.0f, 8.0f, 8.0f, 8.0f};
        BinarySearchTest.checkFindFloat(arr, InequalitySearch.LT);
        BinarySearchTest.checkFindFloat(arr, InequalitySearch.LE);
        BinarySearchTest.checkFindFloat(arr, InequalitySearch.GT);
        BinarySearchTest.checkFindFloat(arr, InequalitySearch.GE);
    }

    private static void checkFindFloat(float[] arr, InequalitySearch crit) {
        BinarySearchTest.println("InequalitySearch: " + crit.name());
        int len = arr.length;
        for (float v = 0.5f; v <= arr[len - 1] + 0.5f; v += 0.5f) {
            boolean low = false;
            int high = len - 1;
            int idx = InequalitySearch.find((float[])arr, (int)0, (int)high, (float)v, (InequalitySearch)crit);
            if (idx == -1) {
                BinarySearchTest.println("LT: " + v + " Not resolved, return -1.");
                continue;
            }
            BinarySearchTest.println(crit.desc(arr, 0, high, v, idx));
        }
        BinarySearchTest.println("");
    }

    @Test
    public void exerciseLongBinSearch() {
        long[] arr = new long[]{5L, 5L, 5L, 7L, 7L, 7L, 9L, 11L, 11L, 11L};
        BinarySearchTest.checkFindLong(arr, InequalitySearch.LT);
        BinarySearchTest.checkFindLong(arr, InequalitySearch.LE);
        BinarySearchTest.checkFindLong(arr, InequalitySearch.GT);
        BinarySearchTest.checkFindLong(arr, InequalitySearch.GE);
    }

    private static void checkFindLong(long[] arr, InequalitySearch crit) {
        BinarySearchTest.println("InequalitySearch: " + crit.name());
        int len = arr.length;
        for (long v = 1L; v <= arr[len - 1] + 1L; ++v) {
            boolean low = false;
            int high = len - 1;
            int idx = InequalitySearch.find((long[])arr, (int)0, (int)high, (long)v, (InequalitySearch)crit);
            if (idx == -1) {
                BinarySearchTest.println("LT: " + v + " Not resolved, return -1.");
                continue;
            }
            BinarySearchTest.println(crit.desc(arr, 0, high, v, idx));
        }
        BinarySearchTest.println("");
    }

    @Test
    public void checkSimpleFindFloat() {
        int idx;
        int len = 10;
        float[] arr = new float[10];
        for (int i = 0; i < 10; ++i) {
            arr[i] = i;
        }
        for (int i = 0; i < 10; ++i) {
            idx = BinarySearch.find((float[])arr, (int)0, (int)9, (float)i);
            Assert.assertEquals((int)idx, (int)i);
        }
        idx = BinarySearch.find((float[])arr, (int)0, (int)9, (float)-1.0f);
        Assert.assertEquals((int)idx, (int)-1);
        idx = BinarySearch.find((float[])arr, (int)0, (int)9, (float)10.0f);
        Assert.assertEquals((int)idx, (int)-1);
    }

    @Test
    public void checkSimpleFindDouble() {
        int idx;
        int len = 11;
        double[] arr = new double[11];
        for (int i = 0; i < 11; ++i) {
            arr[i] = i;
        }
        for (int i = 0; i < 11; ++i) {
            idx = BinarySearch.find((double[])arr, (int)0, (int)10, (double)i);
            Assert.assertEquals((int)idx, (int)i);
        }
        idx = BinarySearch.find((double[])arr, (int)0, (int)10, (double)-1.0);
        Assert.assertEquals((int)idx, (int)-1);
        idx = BinarySearch.find((double[])arr, (int)0, (int)10, (double)11.0);
        Assert.assertEquals((int)idx, (int)-1);
    }

    @Test
    public void checkSimpleFindLong() {
        int idx;
        int len = 11;
        long[] arr = new long[11];
        for (int i = 0; i < 11; ++i) {
            arr[i] = i;
        }
        for (int i = 0; i < 11; ++i) {
            idx = BinarySearch.find((long[])arr, (int)0, (int)10, (long)i);
            Assert.assertEquals((int)idx, (int)i);
        }
        idx = BinarySearch.find((long[])arr, (int)0, (int)10, (long)-1L);
        Assert.assertEquals((int)idx, (int)-1);
        idx = BinarySearch.find((long[])arr, (int)0, (int)10, (long)11L);
        Assert.assertEquals((int)idx, (int)-1);
    }

    private static void checkBuildRandFloatArr() {
        int len = 10;
        for (int i = 0; i < 10; ++i) {
            float[] tarr = BinarySearchTest.buildRandFloatArr(10);
            for (int j = 0; j < 10; ++j) {
                BinarySearchTest.printf("%4.1f,", Float.valueOf(tarr[j]));
            }
            BinarySearchTest.println("");
        }
    }

    static final void printf(String format, Object ... args) {
    }

    static final void println(Object o) {
    }
}

