/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.aninteger.IntegerSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CornerCaseTupleSetOperationsTest {
    private static final long GT_MIDP_V = 3L;
    private static final float MIDP_FLT = 0.5f;
    private static final long GT_LOWP_V = 6L;
    private static final float LOWP_FLT = 0.1f;
    private static final long LT_LOWP_V = 4L;
    private IntegerSummary.Mode mode = IntegerSummary.Mode.Min;
    private IntegerSummary integerSummary = new IntegerSummary(this.mode);
    private IntegerSummarySetOperations setOperations = new IntegerSummarySetOperations(this.mode, this.mode);

    @Test
    public void emptyEmpty() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = true;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 0, true);
    }

    @Test
    public void emptyExact() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void EmptyDegenerate() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 0, false);
    }

    @Test
    public void emptyEstimation() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 0, true, 0.1f, 1, false);
    }

    @Test
    public void exactEmpty() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 1.0, 1, false, 1.0, 1, false);
    }

    @Test
    public void exactExact() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 3L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 3L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 1.0;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = true;
        double expectedUnionTheta = 1.0;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 1, false, 1.0, 0, true, 1.0, 1, false);
    }

    @Test
    public void exactDegenerate() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void exactEstimation() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEmpty() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationExact() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void estimationDegenerate() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.5f, 4L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = true;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 1, false, 0.1f, 1, false);
    }

    @Test
    public void estimationEstimation() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.5f, 4L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = true;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 1, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateEmpty() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EMPTY, 0.0f, 0L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EMPTY, 0.0f, 0L);
        double expectedIntersectTheta = 1.0;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = true;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 1.0, 0, true, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateExact() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.EXACT, 0.0f, 4L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.EXACT, 0.0f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    @Test
    public void degenerateDegenerate() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.5f, 3L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.1f, 6L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.DEGENERATE, 0.1f, 6L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = false;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 0, false);
    }

    @Test
    public void degenerateEstimation() {
        IntegerSketch tupleA = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.DEGENERATE, 0.5f, 3L);
        IntegerSketch tupleB = CornerCaseTupleSetOperationsTest.getTupleSketch(SkType.ESTIMATION, 0.1f, 4L);
        UpdateSketch thetaB = CornerCaseTupleSetOperationsTest.getThetaSketch(SkType.ESTIMATION, 0.1f, 4L);
        double expectedIntersectTheta = 0.1f;
        boolean expectedIntersectCount = false;
        boolean expectedIntersectEmpty = false;
        double expectedAnotbTheta = 0.1f;
        boolean expectedAnotbCount = false;
        boolean expectedAnotbEmpty = false;
        double expectedUnionTheta = 0.1f;
        boolean expectedUnionCount = true;
        boolean expectedUnionEmpty = false;
        this.checks(tupleA, tupleB, thetaB, 0.1f, 0, false, 0.1f, 0, false, 0.1f, 1, false);
    }

    private void checks(IntegerSketch tupleA, IntegerSketch tupleB, UpdateSketch thetaB, double expectedIntersectTheta, int expectedIntersectCount, boolean expectedIntersectEmpty, double expectedAnotbTheta, int expectedAnotbCount, boolean expectedAnotbEmpty, double expectedUnionTheta, int expectedUnionCount, boolean expectedUnionEmpty) {
        Intersection inter = new Intersection((SummarySetOperations)this.setOperations);
        AnotB anotb = new AnotB();
        Union union = new Union(16, (SummarySetOperations)this.setOperations);
        CompactSketch csk = inter.intersect((Sketch)tupleA, (Sketch)tupleB);
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((Sketch)tupleA.compact(), (Sketch)tupleB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((Sketch)tupleA, (org.apache.datasketches.theta.Sketch)thetaB, (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = inter.intersect((Sketch)tupleA.compact(), (org.apache.datasketches.theta.Sketch)thetaB.compact(), (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("Intersect Stateless Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedIntersectTheta, expectedIntersectCount, expectedIntersectEmpty);
        csk = AnotB.aNotB((Sketch)tupleA, (Sketch)tupleB);
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateless Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = AnotB.aNotB((Sketch)tupleA.compact(), (Sketch)tupleB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateless Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = AnotB.aNotB((Sketch)tupleA, (org.apache.datasketches.theta.Sketch)thetaB);
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateless Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = AnotB.aNotB((Sketch)tupleA.compact(), (org.apache.datasketches.theta.Sketch)thetaB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateless Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((Sketch)tupleA);
        anotb.notB((Sketch)tupleB);
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateful Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((Sketch)tupleA.compact());
        anotb.notB((Sketch)tupleB.compact());
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateful Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((Sketch)tupleA);
        anotb.notB((org.apache.datasketches.theta.Sketch)thetaB);
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateful Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        anotb.setA((Sketch)tupleA.compact());
        anotb.notB((org.apache.datasketches.theta.Sketch)thetaB.compact());
        csk = anotb.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("AnotB Stateful Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedAnotbTheta, expectedAnotbCount, expectedAnotbEmpty);
        csk = union.union((Sketch)tupleA, (Sketch)tupleB);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateless Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        csk = union.union((Sketch)tupleA.compact(), (Sketch)tupleB.compact());
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateless Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        csk = union.union((Sketch)tupleA, (org.apache.datasketches.theta.Sketch)thetaB, (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateless Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        csk = union.union((Sketch)tupleA.compact(), (org.apache.datasketches.theta.Sketch)thetaB.compact(), (Summary)this.integerSummary);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateless Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((Sketch)tupleA);
        union.union((Sketch)tupleB);
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateful Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((Sketch)tupleA.compact());
        union.union((Sketch)tupleB.compact());
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateful Tuple, Tuple", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((Sketch)tupleA);
        union.union((org.apache.datasketches.theta.Sketch)thetaB, (Summary)this.integerSummary);
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateful Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
        union.union((Sketch)tupleA.compact());
        union.union((org.apache.datasketches.theta.Sketch)thetaB.compact(), (Summary)this.integerSummary);
        csk = union.getResult(true);
        CornerCaseTupleSetOperationsTest.checkResult("Union Stateful Tuple, Theta", (CompactSketch<IntegerSummary>)csk, expectedUnionTheta, expectedUnionCount, expectedUnionEmpty);
    }

    private static void checkResult(String comment, CompactSketch<IntegerSummary> csk, double expectedTheta, int expectedEntries, boolean expectedEmpty) {
        boolean emptyOk;
        double actualTheta = csk.getTheta();
        int actualEntries = csk.getRetainedEntries();
        boolean actualEmpty = csk.isEmpty();
        boolean thetaOk = actualTheta == expectedTheta;
        boolean entriesOk = actualEntries == expectedEntries;
        boolean bl = emptyOk = actualEmpty == expectedEmpty;
        if (!(thetaOk && entriesOk && emptyOk)) {
            StringBuilder sb = new StringBuilder();
            sb.append(comment + ": ");
            if (!thetaOk) {
                sb.append("Theta: expected " + expectedTheta + ", got " + actualTheta + "; ");
            }
            if (!entriesOk) {
                sb.append("Entries: expected " + expectedEntries + ", got " + actualEntries + "; ");
            }
            if (!emptyOk) {
                sb.append("Empty: expected " + expectedEmpty + ", got " + actualEmpty + ".");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static IntegerSketch getTupleSketch(SkType skType, float p, long updateKey) {
        IntegerSketch sk;
        switch (skType) {
            case EMPTY: {
                sk = new IntegerSketch(4, 2, 1.0f, IntegerSummary.Mode.Min);
                break;
            }
            case EXACT: {
                sk = new IntegerSketch(4, 2, 1.0f, IntegerSummary.Mode.Min);
                sk.update(updateKey, Integer.valueOf(1));
                break;
            }
            case ESTIMATION: {
                CornerCaseTupleSetOperationsTest.checkValidUpdate(p, updateKey);
                sk = new IntegerSketch(4, 2, p, IntegerSummary.Mode.Min);
                sk.update(updateKey, Integer.valueOf(1));
                break;
            }
            case DEGENERATE: {
                CornerCaseTupleSetOperationsTest.checkInvalidUpdate(p, updateKey);
                sk = new IntegerSketch(4, 2, p, IntegerSummary.Mode.Min);
                sk.update(updateKey, Integer.valueOf(1));
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static UpdateSketch getThetaSketch(SkType skType, float p, long updateKey) {
        UpdateSketch sk;
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        bldr.setLogNominalEntries(4);
        bldr.setResizeFactor(ResizeFactor.X4);
        switch (skType) {
            case EMPTY: {
                sk = bldr.build();
                break;
            }
            case EXACT: {
                sk = bldr.build();
                sk.update(updateKey);
                break;
            }
            case ESTIMATION: {
                CornerCaseTupleSetOperationsTest.checkValidUpdate(p, updateKey);
                bldr.setP(p);
                sk = bldr.build();
                sk.update(updateKey);
                break;
            }
            case DEGENERATE: {
                CornerCaseTupleSetOperationsTest.checkInvalidUpdate(p, updateKey);
                bldr.setP(p);
                sk = bldr.build();
                sk.update(updateKey);
                break;
            }
            default: {
                return null;
            }
        }
        return sk;
    }

    private static void checkValidUpdate(float p, long updateKey) {
        Assert.assertTrue((CornerCaseTupleSetOperationsTest.getLongHash(updateKey) < (long)(p * 9.223372E18f) ? 1 : 0) != 0);
    }

    private static void checkInvalidUpdate(float p, long updateKey) {
        Assert.assertTrue((CornerCaseTupleSetOperationsTest.getLongHash(updateKey) > (long)(p * 9.223372E18f) ? 1 : 0) != 0);
    }

    static long getLongHash(long v) {
        return MurmurHash3.hash((long)v, (long)9001L)[0] >>> 1;
    }

    private static enum SkType {
        EMPTY,
        EXACT,
        ESTIMATION,
        DEGENERATE;

    }
}

