/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.util.ArrayList;
import org.apache.datasketches.ArrayOfDoublesSerDe;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfLongsSerDe;
import org.apache.datasketches.ArrayOfNumbersSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.PreambleUtil;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.datasketches.sampling.ReservoirItemsSketchTest;
import org.apache.datasketches.sampling.ReservoirItemsUnion;
import org.apache.datasketches.sampling.ReservoirSize;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirItemsUnionTest {
    @Test
    public void checkEmptyUnion() {
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        byte[] unionBytes = riu.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertEquals((int)unionBytes.length, (int)8);
        ReservoirItemsUnionTest.println(riu.toString());
    }

    @Test
    public void checkInstantiation() {
        int n = 100;
        int k = 25;
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)25);
        Assert.assertNull((Object)riu.getResult());
        riu.update((Object)5L);
        Assert.assertNotNull((Object)riu.getResult());
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)25);
        for (long i = 0L; i < 100L; ++i) {
            ris.update((Object)i);
        }
        riu.reset();
        Assert.assertEquals((long)riu.getResult().getN(), (long)0L);
        riu.update(ris);
        Assert.assertEquals((long)riu.getResult().getN(), (long)ris.getN());
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] sketchBytes = ris.toByteArray((ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])sketchBytes);
        riu = ReservoirItemsUnion.newInstance((int)ris.getK());
        riu.update(mem, (ArrayOfItemsSerDe)serDe);
        Assert.assertNotNull((Object)riu.getResult());
        ReservoirItemsUnionTest.println(riu.toString());
    }

    @Test
    public void checkNullUpdate() {
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        Assert.assertNull((Object)riu.getResult());
        ReservoirItemsSketch nullSketch = null;
        riu.update(nullSketch);
        Assert.assertNull((Object)riu.getResult());
        riu.update(null, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertNull((Object)riu.getResult());
        riu.update((Object)null);
        Assert.assertNull((Object)riu.getResult());
        riu.update((Object)5L);
        Assert.assertNotNull((Object)riu.getResult());
    }

    @Test
    public void checkSerialization() {
        int n = 100;
        int k = 25;
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)25);
        for (long i = 0L; i < 100L; ++i) {
            riu.update((Object)i);
        }
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] unionBytes = riu.toByteArray((ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])unionBytes);
        ReservoirItemsUnionTest.println(PreambleUtil.preambleToString((Memory)mem));
        ReservoirItemsUnion rebuiltUnion = ReservoirItemsUnion.heapify((Memory)mem, (ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)riu.getMaxK(), (int)rebuiltUnion.getMaxK());
        ReservoirItemsSketchTest.validateReservoirEquality(riu.getResult(), rebuiltUnion.getResult());
    }

    @Test
    public void checkVersionConversionWithEmptyGadget() {
        int k = 32768;
        short encK = ReservoirSize.computeSize((int)32768);
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)32768);
        byte[] unionBytesOrig = riu.toByteArray((ArrayOfItemsSerDe)serDe);
        byte[] unionBytes = riu.toByteArray((ArrayOfItemsSerDe)serDe);
        WritableMemory unionMem = WritableMemory.writableWrap((byte[])unionBytes);
        unionMem.putByte(1L, (byte)1);
        unionMem.putInt(4L, 0);
        unionMem.putShort(4L, encK);
        ReservoirItemsUnionTest.println(PreambleUtil.preambleToString((Memory)unionMem));
        ReservoirItemsUnion rebuilt = ReservoirItemsUnion.heapify((Memory)unionMem, (ArrayOfItemsSerDe)serDe);
        byte[] rebuiltBytes = rebuilt.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)unionBytesOrig.length, (int)rebuiltBytes.length);
        for (int i = 0; i < unionBytesOrig.length; ++i) {
            Assert.assertEquals((byte)unionBytesOrig[i], (byte)rebuiltBytes[i]);
        }
    }

    @Test
    public void checkVersionConversionWithGadget() {
        long n = 32L;
        int k = 256;
        short encK = ReservoirSize.computeSize((int)256);
        ArrayOfNumbersSerDe serDe = new ArrayOfNumbersSerDe();
        ReservoirItemsUnion rlu = ReservoirItemsUnion.newInstance((int)256);
        for (long i = 0L; i < 32L; ++i) {
            rlu.update((Object)i);
        }
        byte[] unionBytesOrig = rlu.toByteArray((ArrayOfItemsSerDe)serDe);
        byte[] unionBytes = rlu.toByteArray((ArrayOfItemsSerDe)serDe);
        WritableMemory unionMem = WritableMemory.writableWrap((byte[])unionBytes);
        unionMem.putByte(1L, (byte)1);
        unionMem.putInt(4L, 0);
        unionMem.putShort(4L, encK);
        int offset = Family.RESERVOIR_UNION.getMaxPreLongs() << 3;
        unionMem.putByte((long)(offset + 1), (byte)1);
        unionMem.putInt((long)(offset + 4), 0);
        unionMem.putShort((long)(offset + 4), encK);
        ReservoirItemsUnion rebuilt = ReservoirItemsUnion.heapify((Memory)unionMem, (ArrayOfItemsSerDe)serDe);
        byte[] rebuiltBytes = rebuilt.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)unionBytesOrig.length, (int)rebuiltBytes.length);
        for (int i = 0; i < unionBytesOrig.length; ++i) {
            Assert.assertEquals((byte)unionBytesOrig[i], (byte)rebuiltBytes[i]);
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void checkNullMemoryInstantiation() {
        ReservoirItemsUnion.heapify(null, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
    }

    @Test
    public void checkDownsampledUpdate() {
        int bigK = 1024;
        int smallK = 256;
        int n = 2048;
        ReservoirItemsSketch<Long> sketch1 = ReservoirItemsUnionTest.getBasicSketch(2048, 256);
        ReservoirItemsSketch<Long> sketch2 = ReservoirItemsUnionTest.getBasicSketch(4096, 1024);
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)256);
        Assert.assertEquals((int)riu.getMaxK(), (int)256);
        riu.update(sketch1);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)256);
        riu.update(sketch2);
        Assert.assertEquals((int)riu.getResult().getK(), (int)256);
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)256);
    }

    @Test
    public void checkUnionResetWithInitialSmallK() {
        int maxK = 25;
        int sketchK = 10;
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)25);
        ReservoirItemsSketch<Long> ris = ReservoirItemsUnionTest.getBasicSketch(20, 10);
        riu.update(ris);
        Assert.assertEquals((int)riu.getMaxK(), (int)25);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)10);
        riu.reset();
        Assert.assertNotNull((Object)riu.getResult());
        ris = ReservoirItemsUnionTest.getBasicSketch(50, 26);
        riu.update(ris);
        Assert.assertEquals((int)riu.getMaxK(), (int)25);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)25);
    }

    @Test
    public void checkNewGadget() {
        int maxK = 1024;
        int bigK = 1536;
        int smallK = 128;
        ReservoirItemsSketch<Long> bigKSketch = ReservoirItemsUnionTest.getBasicSketch(512, 1536);
        byte[] bigKBytes = bigKSketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Memory bigKMem = Memory.wrap((byte[])bigKBytes);
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(bigKMem, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)512L);
        ReservoirItemsSketch<Long> smallKSketch = ReservoirItemsUnionTest.getBasicSketch(1024, 128);
        byte[] smallKBytes = smallKSketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Memory smallKMem = Memory.wrap((byte[])smallKBytes);
        riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(smallKMem, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertTrue((riu.getResult().getK() < 1024 ? 1 : 0) != 0);
        Assert.assertEquals((int)riu.getResult().getK(), (int)128);
        Assert.assertEquals((long)riu.getResult().getN(), (long)1024L);
        ReservoirItemsSketch<Long> smallKExactSketch = ReservoirItemsUnionTest.getBasicSketch(128, 128);
        byte[] smallKExactBytes = smallKExactSketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Memory smallKExactMem = Memory.wrap((byte[])smallKExactBytes);
        riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(smallKExactMem, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)128L);
    }

    @Test
    public void checkListInputUpdate() {
        int i;
        int k = 32;
        int n = 64;
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)32);
        ArrayList<Integer> data = new ArrayList<Integer>(32);
        for (i = 0; i < 32; ++i) {
            data.add(i);
        }
        riu.update(64L, 32, data);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((long)riu.getResult().getN(), (long)64L);
        Assert.assertEquals((int)riu.getResult().getK(), (int)32);
        data = new ArrayList(64);
        for (i = 0; i < 64; ++i) {
            data.add(i);
        }
        riu.update(640L, 64, data);
        Assert.assertEquals((long)riu.getResult().getN(), (long)704L);
        Assert.assertEquals((int)riu.getResult().getK(), (int)32);
    }

    @Test
    public void checkStandardMergeNoCopy() {
        int k = 1024;
        int n1 = 256;
        int n2 = 256;
        ReservoirItemsSketch<Long> sketch1 = ReservoirItemsUnionTest.getBasicSketch(256, 1024);
        ReservoirItemsSketch<Long> sketch2 = ReservoirItemsUnionTest.getBasicSketch(256, 1024);
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(sketch1);
        riu.update(sketch2);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)512L);
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)512);
        int n3 = 2048;
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        ReservoirItemsSketch<Long> sketch3 = ReservoirItemsUnionTest.getBasicSketch(2048, 1024);
        byte[] sketch3Bytes = sketch3.toByteArray((ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])sketch3Bytes);
        riu.update(mem, (ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)2560L);
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)1024);
    }

    @Test
    public void checkStandardMergeWithCopy() {
        int k = 1024;
        int n1 = 768;
        int n2 = 2048;
        ReservoirItemsSketch<Long> sketch1 = ReservoirItemsUnionTest.getBasicSketch(768, 1024);
        ReservoirItemsSketch<Long> sketch2 = ReservoirItemsUnionTest.getBasicSketch(2048, 1024);
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(sketch1);
        riu.update(sketch2);
        riu.update((Object)10L);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)2817L);
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)1024);
    }

    @Test
    public void checkWeightedMerge() {
        int k = 1024;
        int n1 = 16384;
        int n2 = 2048;
        ReservoirItemsSketch<Long> sketch1 = ReservoirItemsUnionTest.getBasicSketch(16384, 1024);
        ReservoirItemsSketch<Long> sketch2 = ReservoirItemsUnionTest.getBasicSketch(2048, 1024);
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(sketch1);
        riu.update(sketch2);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)18432L);
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)1024);
        riu = ReservoirItemsUnion.newInstance((int)1024);
        riu.update(sketch2);
        riu.update(sketch1);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertEquals((int)riu.getResult().getK(), (int)1024);
        Assert.assertEquals((long)riu.getResult().getN(), (long)18432L);
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)1024);
    }

    @Test
    public void checkPolymorphicType() {
        int k = 4;
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)4);
        riu.update((Object)2.2);
        riu.update((Object)6L);
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)4);
        ris.update((Object)1);
        ris.update((Object)Float.valueOf(3.7f));
        riu.update(ris);
        ArrayOfNumbersSerDe serDe = new ArrayOfNumbersSerDe();
        byte[] sketchBytes = riu.toByteArray((ArrayOfItemsSerDe)serDe, Number.class);
        Memory mem = Memory.wrap((byte[])sketchBytes);
        ReservoirItemsUnion rebuiltRiu = ReservoirItemsUnion.heapify((Memory)mem, (ArrayOfItemsSerDe)serDe);
        Assert.assertNotNull((Object)riu.getResult());
        Assert.assertNotNull((Object)rebuiltRiu.getResult());
        Assert.assertEquals((int)riu.getResult().getNumSamples(), (int)rebuiltRiu.getResult().getNumSamples());
        Number[] samples1 = (Number[])riu.getResult().getSamples(Number.class);
        Number[] samples2 = (Number[])rebuiltRiu.getResult().getSamples(Number.class);
        Assert.assertNotNull((Object)samples1);
        Assert.assertNotNull((Object)samples2);
        Assert.assertEquals((int)samples1.length, (int)samples2.length);
        for (int i = 0; i < samples1.length; ++i) {
            Assert.assertEquals((Object)samples1[i], (Object)samples2[i]);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreLongs() {
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        WritableMemory mem = WritableMemory.writableWrap((byte[])riu.toByteArray((ArrayOfItemsSerDe)new ArrayOfNumbersSerDe()));
        mem.putByte(0L, (byte)0);
        ReservoirItemsUnion.heapify((Memory)mem, (ArrayOfItemsSerDe)new ArrayOfNumbersSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        ReservoirItemsUnion riu = ReservoirItemsUnion.newInstance((int)1024);
        WritableMemory mem = WritableMemory.writableWrap((byte[])riu.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
        mem.putByte(1L, (byte)0);
        ReservoirItemsUnion.heapify((Memory)mem, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        ReservoirItemsUnion rlu = ReservoirItemsUnion.newInstance((int)1024);
        WritableMemory mem = WritableMemory.writableWrap((byte[])rlu.toByteArray((ArrayOfItemsSerDe)new ArrayOfDoublesSerDe()));
        mem.putByte(2L, (byte)0);
        ReservoirItemsUnion.heapify((Memory)mem, (ArrayOfItemsSerDe)new ArrayOfDoublesSerDe());
        Assert.fail();
    }

    private static ReservoirItemsSketch<Long> getBasicSketch(int n, int k) {
        ReservoirItemsSketch rls = ReservoirItemsSketch.newInstance((int)k);
        for (long i = 0L; i < (long)n; ++i) {
            rls.update((Object)i);
        }
        return rls;
    }

    private static void println(String msg) {
    }
}

