/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfLongsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ItemsUnionTest {
    @Test
    public void nullAndEmpty() {
        ItemsUnion union = ItemsUnion.getInstance(Comparator.naturalOrder());
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.isDirect());
        Assert.assertEquals((int)union.getMaxK(), (int)128);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        Assert.assertTrue((union.toString().length() > 0 ? 1 : 0) != 0);
        union.update((Object)null);
        ItemsSketch result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
        Assert.assertNull((Object)union.getResultAndReset());
        ItemsSketch emptySk = ItemsSketch.getInstance(Comparator.naturalOrder());
        ItemsSketch validSk = ItemsSketch.getInstance(Comparator.naturalOrder());
        validSk.update((Object)1);
        union.update(validSk);
        union = ItemsUnion.getInstance((ItemsSketch)result);
        union.update((ItemsSketch)null);
        union.update(emptySk);
        Assert.assertTrue((boolean)union.isEmpty());
        Assert.assertFalse((boolean)union.isDirect());
        Assert.assertEquals((int)union.getMaxK(), (int)128);
        Assert.assertEquals((int)union.getEffectiveK(), (int)128);
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
        union.update(validSk);
        union.reset();
        union.update((ItemsSketch)null);
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
        union.update(ItemsSketch.getInstance(Comparator.naturalOrder()));
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
        union.reset();
        union.update(ItemsSketch.getInstance(Comparator.naturalOrder()));
        result = union.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
    }

    @Test
    public void nullAndEmptyInputsToNonEmptyUnion() {
        ItemsUnion union = ItemsUnion.getInstance((int)128, Comparator.naturalOrder());
        union.update((Object)1);
        ItemsSketch result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)1L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)1);
        union.update((ItemsSketch)null);
        result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)1L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)1);
        union.update(ItemsSketch.getInstance(Comparator.naturalOrder()));
        result = union.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)result.getN(), (long)1L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)1);
    }

    @Test
    public void basedOnSketch() {
        Comparator comp = Comparator.naturalOrder();
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        ItemsSketch sketch = ItemsSketch.getInstance(comp);
        ItemsUnion union = ItemsUnion.getInstance((ItemsSketch)sketch);
        union.reset();
        byte[] byteArr = sketch.toByteArray((ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])byteArr);
        union = ItemsUnion.getInstance((Memory)mem, comp, (ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)byteArr.length, (int)8);
        union.reset();
    }

    @Test
    public void sameK() {
        ItemsUnion union = ItemsUnion.getInstance((int)128, Comparator.naturalOrder());
        ItemsSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
        for (int i = 1; i <= 1000; ++i) {
            union.update((Object)i);
        }
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)1000L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)1000L);
        Assert.assertEquals((float)((Long)result.getQuantile(0.5)).longValue(), (float)500.0f, (float)17.0f);
        ItemsSketch sketch1 = ItemsSketch.getInstance(Comparator.naturalOrder());
        for (int i = 1001; i <= 2000; ++i) {
            sketch1.update((Object)i);
        }
        union.update(sketch1);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)2000L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)2000L);
        Assert.assertEquals((float)((Long)result.getQuantile(0.5)).longValue(), (float)1000.0f, (float)34.0f);
        ItemsSketch sketch2 = ItemsSketch.getInstance(Comparator.naturalOrder());
        for (int i = 2001; i <= 3000; ++i) {
            sketch2.update((Object)i);
        }
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        union.update(Memory.wrap((byte[])sketch2.toByteArray((ArrayOfItemsSerDe)serDe)), (ArrayOfItemsSerDe)serDe);
        result = union.getResultAndReset();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)result.getN(), (long)3000L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)3000L);
        Assert.assertEquals((float)((Long)result.getQuantile(0.5)).longValue(), (float)1500.0f, (float)51.0f);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
    }

    @Test
    public void differentK() {
        ItemsUnion union = ItemsUnion.getInstance((int)512, Comparator.naturalOrder());
        ItemsSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
        for (int i = 1; i <= 10000; ++i) {
            union.update((Object)i);
        }
        result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)512);
        Assert.assertEquals((long)result.getN(), (long)10000L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)10000L);
        Assert.assertEquals((float)((Long)result.getQuantile(0.5)).longValue(), (float)5000.0f, (float)50.0f);
        ItemsSketch sketch1 = ItemsSketch.getInstance((int)256, Comparator.naturalOrder());
        for (int i = 10001; i <= 20000; ++i) {
            sketch1.update((Object)i);
        }
        union.update(sketch1);
        result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)256);
        Assert.assertEquals((long)result.getN(), (long)20000L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)20000L);
        Assert.assertEquals((float)((Long)result.getQuantile(0.5)).longValue(), (float)10000.0f, (float)180.0f);
        ItemsSketch sketch2 = ItemsSketch.getInstance((int)128, Comparator.naturalOrder());
        for (int i = 20001; i <= 30000; ++i) {
            sketch2.update((Object)i);
        }
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        union.update(Memory.wrap((byte[])sketch2.toByteArray((ArrayOfItemsSerDe)serDe)), (ArrayOfItemsSerDe)serDe);
        result = union.getResultAndReset();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.getK(), (int)128);
        Assert.assertEquals((long)result.getN(), (long)30000L);
        Assert.assertEquals((Object)result.getMinValue(), (Object)1L);
        Assert.assertEquals((Object)result.getMaxValue(), (Object)30000L);
        Assert.assertEquals((float)((Long)result.getQuantile(0.5)).longValue(), (float)15000.0f, (float)510.0f);
        result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertNull((Object)result.getMinValue());
        Assert.assertNull((Object)result.getMaxValue());
    }

    @Test
    public void differentLargerK() {
        ItemsUnion union = ItemsUnion.getInstance((int)128, Comparator.naturalOrder());
        ItemsSketch sketch1 = ItemsSketch.getInstance((int)256, Comparator.naturalOrder());
        union.update(sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
        sketch1.update((Object)1L);
        union.update(sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)128);
    }

    @Test
    public void differentSmallerK() {
        ItemsUnion union = ItemsUnion.getInstance((int)128, Comparator.naturalOrder());
        ItemsSketch sketch1 = ItemsSketch.getInstance((int)64, Comparator.naturalOrder());
        union.update(sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)64);
        sketch1.update((Object)1L);
        union.update(sketch1);
        Assert.assertEquals((int)union.getResult().getK(), (int)64);
    }

    @Test
    public void toStringCrudeCheck() {
        ItemsUnion union = ItemsUnion.getInstance((int)128, Comparator.naturalOrder());
        union.update((Object)"a");
        String brief = union.toString();
        String full = union.toString(true, true);
        Assert.assertTrue((brief.length() < full.length() ? 1 : 0) != 0);
    }

    @Test
    public void meNullOtherExactBiggerSmaller() {
        ItemsUnion union = ItemsUnion.getInstance((int)16, Comparator.naturalOrder());
        ItemsSketch<Long> skExact = ItemsUnionTest.buildIS(32, 31);
        union.update(skExact);
        ItemsUnionTest.println(skExact.toString(true, true));
        ItemsUnionTest.println(union.toString(true, true));
        Assert.assertEquals((double)((Long)skExact.getQuantile(0.5)).longValue(), (double)((Long)union.getResult().getQuantile(0.5)).longValue(), (double)0.0);
        union.reset();
        skExact = ItemsUnionTest.buildIS(8, 15);
        union.update(skExact);
        ItemsUnionTest.println(skExact.toString(true, true));
        ItemsUnionTest.println(union.toString(true, true));
        Assert.assertEquals((double)((Long)skExact.getQuantile(0.5)).longValue(), (double)((Long)union.getResult().getQuantile(0.5)).longValue(), (double)0.0);
    }

    @Test
    public void meNullOtherEstBiggerSmaller() {
        ItemsUnion union = ItemsUnion.getInstance((int)16, Comparator.naturalOrder());
        ItemsSketch<Long> skEst = ItemsUnionTest.buildIS(32, 64);
        union.update(skEst);
        Assert.assertEquals((double)((Long)union.getResult().getMinValue()).longValue(), (double)((Long)skEst.getMinValue()).longValue(), (double)0.0);
        Assert.assertEquals((double)((Long)union.getResult().getMaxValue()).longValue(), (double)((Long)skEst.getMaxValue()).longValue(), (double)0.0);
        union.reset();
        skEst = ItemsUnionTest.buildIS(8, 64);
        union.update(skEst);
        Assert.assertEquals((double)((Long)union.getResult().getMinValue()).longValue(), (double)((Long)skEst.getMinValue()).longValue(), (double)0.0);
        Assert.assertEquals((double)((Long)union.getResult().getMaxValue()).longValue(), (double)((Long)skEst.getMaxValue()).longValue(), (double)0.0);
    }

    @Test
    public void meEmptyOtherExactBiggerSmaller() {
        ItemsUnion union = ItemsUnion.getInstance((int)16, Comparator.naturalOrder());
        ItemsSketch skEmpty = ItemsSketch.getInstance((int)64, Comparator.naturalOrder());
        union.update(skEmpty);
        ItemsSketch<Long> skExact = ItemsUnionTest.buildIS(32, 63);
        union.update(skExact);
        Assert.assertEquals((double)((Long)union.getResult().getMinValue()).longValue(), (double)((Long)skExact.getMinValue()).longValue(), (double)0.0);
        Assert.assertEquals((double)((Long)union.getResult().getMaxValue()).longValue(), (double)((Long)skExact.getMaxValue()).longValue(), (double)0.0);
        union.reset();
        union.update(skEmpty);
        skExact = ItemsUnionTest.buildIS(8, 15);
        union.update(skExact);
        Assert.assertEquals((double)((Long)union.getResult().getMinValue()).longValue(), (double)((Long)skExact.getMinValue()).longValue(), (double)0.0);
        Assert.assertEquals((double)((Long)union.getResult().getMaxValue()).longValue(), (double)((Long)skExact.getMaxValue()).longValue(), (double)0.0);
    }

    @Test
    public void meEmptyOtherEstBiggerSmaller() {
        ItemsUnion union = ItemsUnion.getInstance((int)16, Comparator.naturalOrder());
        ItemsSketch skEmpty = ItemsSketch.getInstance((int)64, Comparator.naturalOrder());
        union.update(skEmpty);
        ItemsSketch<Long> skExact = ItemsUnionTest.buildIS(32, 64);
        union.update(skExact);
        Assert.assertEquals((double)((Long)union.getResult().getMinValue()).longValue(), (double)((Long)skExact.getMinValue()).longValue(), (double)0.0);
        Assert.assertEquals((double)((Long)union.getResult().getMaxValue()).longValue(), (double)((Long)skExact.getMaxValue()).longValue(), (double)0.0);
        union.reset();
        union.update(skEmpty);
        skExact = ItemsUnionTest.buildIS(8, 16);
        union.update(skExact);
        Assert.assertEquals((double)((Long)union.getResult().getMinValue()).longValue(), (double)((Long)skExact.getMinValue()).longValue(), (double)0.0);
        Assert.assertEquals((double)((Long)union.getResult().getMaxValue()).longValue(), (double)((Long)skExact.getMaxValue()).longValue(), (double)0.0);
    }

    @Test
    public void checkMergeIntoEqualKs() {
        ItemsSketch<Long> skEmpty1 = ItemsUnionTest.buildIS(32, 0);
        ItemsSketch<Long> skEmpty2 = ItemsUnionTest.buildIS(32, 0);
        ItemsMergeImpl.mergeInto(skEmpty1, skEmpty2);
        Assert.assertNull((Object)skEmpty2.getMaxValue());
        Assert.assertNull((Object)skEmpty2.getMaxValue());
        int n = 64;
        ItemsSketch<Long> skValid1 = ItemsUnionTest.buildIS(32, n, 0);
        ItemsSketch<Long> skValid2 = ItemsUnionTest.buildIS(32, 0, 0);
        ItemsMergeImpl.mergeInto(skValid1, skValid2);
        Assert.assertEquals((double)((Long)skValid2.getMinValue()).longValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)((Long)skValid2.getMaxValue()).longValue(), (double)((double)n - 1.0), (double)0.0);
        skValid1 = ItemsUnionTest.buildIS(32, 0, 0);
        skValid2 = ItemsUnionTest.buildIS(32, n, 0);
        ItemsMergeImpl.mergeInto(skValid1, skValid2);
        Assert.assertEquals((double)((Long)skValid2.getMinValue()).longValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)((Long)skValid2.getMaxValue()).longValue(), (double)((double)n - 1.0), (double)0.0);
        skValid1 = ItemsUnionTest.buildIS(32, n, 0);
        skValid2 = ItemsUnionTest.buildIS(32, n, n);
        ItemsMergeImpl.mergeInto(skValid1, skValid2);
        Assert.assertEquals((double)((Long)skValid2.getMinValue()).longValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)((Long)skValid2.getMaxValue()).longValue(), (double)((double)(2 * n) - 1.0), (double)0.0);
        n = 512;
        skValid1 = ItemsUnionTest.buildIS(32, n, 0);
        skValid2 = ItemsUnionTest.buildIS(32, n, n);
        ItemsMergeImpl.mergeInto(skValid1, skValid2);
        Assert.assertEquals((double)((Long)skValid2.getMinValue()).longValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)((Long)skValid2.getMaxValue()).longValue(), (double)((double)(2 * n) - 1.0), (double)0.0);
        skValid1 = ItemsUnionTest.buildIS(32, n, 0);
        skValid2 = ItemsUnionTest.buildIS(32, n, n);
        ItemsMergeImpl.mergeInto(skValid2, skValid1);
        Assert.assertEquals((double)((Long)skValid1.getMinValue()).longValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)((Long)skValid1.getMaxValue()).longValue(), (double)((double)(2 * n) - 1.0), (double)0.0);
    }

    @Test
    public void checkDownSamplingMergeIntoUnequalKs() {
        int n = 128;
        ItemsSketch<Long> sk1 = ItemsUnionTest.buildIS(64, 128, 0);
        ItemsSketch<Long> sk2 = ItemsUnionTest.buildIS(32, 128, 128);
        ItemsMergeImpl.downSamplingMergeInto(sk1, sk2);
        sk1 = ItemsUnionTest.buildIS(64, 128, 128);
        sk2 = ItemsUnionTest.buildIS(32, 128, 0);
        ItemsMergeImpl.downSamplingMergeInto(sk1, sk2);
    }

    @Test
    public void checkToByteArray() {
        int k = 32;
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        ItemsUnion union = ItemsUnion.getInstance((int)32, Comparator.naturalOrder());
        byte[] bytesOut = union.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)bytesOut.length, (int)8);
        Assert.assertTrue((boolean)union.isEmpty());
        byte[] byteArr = ItemsUnionTest.buildIS(32, 69).toByteArray((ArrayOfItemsSerDe)serDe);
        Memory mem = Memory.wrap((byte[])byteArr);
        union = ItemsUnion.getInstance((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)serDe);
        bytesOut = union.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)bytesOut.length, (int)byteArr.length);
        Assert.assertEquals((byte[])bytesOut, (byte[])byteArr);
    }

    private static ItemsSketch<Long> buildIS(int k, int n) {
        return ItemsUnionTest.buildIS(k, n, 0);
    }

    private static ItemsSketch<Long> buildIS(int k, int n, int startV) {
        ItemsSketch is = ItemsSketch.getInstance((int)k, Comparator.naturalOrder());
        for (long i = 0L; i < (long)n; ++i) {
            is.update((Object)(i + (long)startV));
        }
        return is;
    }

    @Test
    public void printlnTest() {
        ItemsUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

