/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectCompactDoublesSketch;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MiscDoublesTest {
    static final String LS = System.getProperty("line.separator");
    private final MemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void checkBounds() {
        KllDoublesSketch kll = KllDoublesSketch.newHeapInstance();
        for (int i = 0; i < 1000; ++i) {
            kll.update((double)i);
        }
        double eps = kll.getNormalizedRankError(false);
        double est = kll.getQuantile(0.5);
        double ub = kll.getQuantileUpperBound(0.5);
        double lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)kll.getQuantile(0.5 - eps));
        MiscDoublesTest.println("Ext     : " + est);
        MiscDoublesTest.println("UB      : " + ub);
        MiscDoublesTest.println("LB      : " + lb);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(6L, (byte)3);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        sk.update(2.0);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(1L, (byte)0);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(2L, (byte)0);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test
    public void checkMisc() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)8);
        Assert.assertTrue((boolean)Objects.isNull(sk.getQuantiles(10)));
        sk.toString(true, true);
        for (int i = 0; i < 20; ++i) {
            sk.update((double)i);
        }
        sk.toString(true, true);
        sk.toByteArray();
        double[] items = sk.getDoubleItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray();
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    public void visualCheckToString() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 0; i < 10; ++i) {
            sketch.update((double)(i + 1));
        }
        String s1 = sketch.toString(true, true);
        MiscDoublesTest.println(s1);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 0; i < 400; ++i) {
            sketch2.update((double)(i + 1));
        }
        MiscDoublesTest.println("\n" + sketch2.toString(true, true));
        sketch2.merge((KllSketch)sketch);
        String s2 = sketch2.toString(true, true);
        MiscDoublesTest.println(LS + s2);
    }

    @Test
    public void viewCompactions() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        MiscDoublesTest.show(sk, 20);
        MiscDoublesTest.show(sk, 21);
        MiscDoublesTest.show(sk, 43);
        MiscDoublesTest.show(sk, 44);
        MiscDoublesTest.show(sk, 54);
        MiscDoublesTest.show(sk, 55);
        MiscDoublesTest.show(sk, 73);
        MiscDoublesTest.show(sk, 74);
        MiscDoublesTest.show(sk, 88);
        MiscDoublesTest.show(sk, 89);
        MiscDoublesTest.show(sk, 96);
        MiscDoublesTest.show(sk, 97);
        MiscDoublesTest.show(sk, 108);
    }

    private static void show(KllDoublesSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((double)(i + 1));
        }
        MiscDoublesTest.println(sk.toString(true, true));
    }

    @Test
    public void checkGrowLevels() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray()[2], (int)33);
    }

    @Test
    public void checkSketchInitializeDoubleHeap() {
        int k = 20;
        MiscDoublesTest.println("#### CASE: DOUBLE FULL HEAP");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        MiscDoublesTest.println("#### CASE: DOUBLE HEAP EMPTY");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        MiscDoublesTest.println("#### CASE: DOUBLE HEAP SINGLE");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        sk.update(1.0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyCompactMem() {
        int k = 20;
        MiscDoublesTest.println("#### CASE: DOUBLE FULL HEAPIFIED FROM COMPACT");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        MiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        KllDoublesSketch sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        MiscDoublesTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        MiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        MiscDoublesTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        sk2.update(1.0);
        MiscDoublesTest.println(sk2.toString(true, true));
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        MiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyUpdatableMem() {
        int k = 20;
        MiscDoublesTest.println("#### CASE: DOUBLE FULL HEAPIFIED FROM UPDATABLE");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        MiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        MiscDoublesTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        MiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        MiscDoublesTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        sk2.update(1.0);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        MiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (boolean)true));
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxDoubleValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinDoubleValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringDoubleCompact() {
        int k = 20;
        MiscDoublesTest.println("#### CASE: DOUBLE FULL COMPACT");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] compBytes = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDoublesTest.println(s);
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((Memory)wmem);
        byte[] compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        MiscDoublesTest.println("#### CASE: DOUBLE EMPTY COMPACT");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDoublesTest.println(s);
        sk2 = KllDoublesSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        MiscDoublesTest.println("#### CASE: DOUBLE SINGLE COMPACT");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDoublesTest.println(s);
        sk2 = KllDoublesSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkMemoryToStringDoubleUpdatable() {
        int k = 20;
        MiscDoublesTest.println("#### CASE: DOUBLE FULL UPDATABLE");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDoublesTest.println(s);
        KllHeapDoublesSketch sk2 = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        byte[] upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDoublesTest.println(s);
        Assert.assertEquals((long)sk.getN(), (long)sk2.getN());
        Assert.assertEquals((double)sk.getMinValue(), (double)sk2.getMinValue());
        Assert.assertEquals((double)sk.getMaxValue(), (double)sk2.getMaxValue());
        Assert.assertEquals((int)sk.getNumRetained(), (int)sk2.getNumRetained());
        MiscDoublesTest.println("#### CASE: DOUBLE EMPTY UPDATABLE");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDoublesTest.println(s);
        sk2 = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        MiscDoublesTest.println("#### CASE: DOUBLE SINGLE UPDATABL");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        sk.update(1.0);
        upBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        MiscDoublesTest.println(s);
        sk2 = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (boolean)true);
        MiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        MiscDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int m = 8;
        int n1 = 21;
        int n2 = 43;
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        WritableMemory wmem2 = WritableMemory.allocate((int)3000);
        KllDirectDoublesSketch sk1 = KllDirectDoublesSketch.newDirectInstance((int)k, (int)m, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        KllDirectDoublesSketch sk2 = KllDirectDoublesSketch.newDirectInstance((int)k, (int)m, (WritableMemory)wmem2, (MemoryRequestServer)this.memReqSvr);
        for (i = 1; i <= n1; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((double)(i + 100));
        }
        sk1.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk1.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk1.getMaxValue(), (double)143.0);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllDoublesSketch skHeap = KllDoublesSketch.newHeapInstance((int)k);
        skHeap.update(1.0);
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapDoublesSketch));
        Assert.assertEquals((double)skHeap.getDoubleSingleItem(), (double)1.0);
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)skHeap));
        KllDoublesSketch skDirect = KllDoublesSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)this.memReqSvr);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectDoublesSketch));
        Assert.assertEquals((double)skDirect.getDoubleSingleItem(), (double)1.0);
        Memory srcMem2 = Memory.wrap((byte[])skHeap.toByteArray());
        KllDoublesSketch skCompact = KllDoublesSketch.wrap((Memory)srcMem2);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectCompactDoublesSketch));
        Assert.assertEquals((double)skCompact.getDoubleSingleItem(), (double)1.0);
    }

    @Test
    public void printlnTest() {
        MiscDoublesTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

