/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllSketchTest {
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void checkWrapCase1Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Memory mem = Memory.wrap((byte[])sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkWrapFloats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        Memory mem = Memory.wrap((byte[])sk.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkWritableWrapCase6And2Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)sk));
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertFalse((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkWritableWrapFloats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            sk.update((float)i);
        }
        sk.update(21.0f);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)sk));
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertFalse((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase5Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase3Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Memory mem = Memory.wrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)sk));
        WritableMemory wmem = (WritableMemory)mem;
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, null);
        Assert.assertTrue((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase7Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Memory mem = Memory.wrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)sk));
        WritableMemory wmem = (WritableMemory)mem;
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkReadOnlyExceptions() {
        int[] intArr = new int[]{};
        int intV = 2;
        int idx = 1;
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)mem);
        try {
            sk2.setLevelsArray(intArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelsArrayAt(idx, intV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsSameResource() {
        WritableMemory reg2;
        int cap = 128;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        WritableMemory reg1 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == (reg2 = wmem.writableRegion(64L, 64L)) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)reg1.isSameResource((Object)reg2));
        WritableMemory reg3 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == reg3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reg1.isSameResource((Object)reg3));
        byte[] byteArr1 = KllFloatsSketch.newHeapInstance((int)20).toByteArray();
        reg1.putByteArray(0L, byteArr1, 0, byteArr1.length);
        KllFloatsSketch sk1 = KllFloatsSketch.wrap((Memory)reg1);
        byte[] byteArr2 = KllFloatsSketch.newHeapInstance((int)20).toByteArray();
        reg2.putByteArray(0L, byteArr2, 0, byteArr2.length);
        if (!sk1.isSameResource((Memory)reg2)) {
            KllFloatsSketch kllFloatsSketch = KllFloatsSketch.wrap((Memory)reg2);
        }
        byte[] byteArr3 = KllFloatsSketch.newHeapInstance((int)20).toByteArray();
        reg3.putByteArray(0L, byteArr3, 0, byteArr3.length);
        if (!sk1.isSameResource((Memory)reg3)) {
            KllFloatsSketch sk3 = KllFloatsSketch.wrap((Memory)reg3);
            Assert.fail();
        }
    }
}

