/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectFloatsSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void empty() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(Float.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)Double.isNaN(sketch.getRank(0.0f)));
        Assert.assertTrue((boolean)Float.isNaN(sketch.getMinValue()));
        Assert.assertTrue((boolean)Float.isNaN(sketch.getMaxValue()));
        Assert.assertTrue((boolean)Float.isNaN(sketch.getQuantile(0.5)));
        Assert.assertNull((Object)sketch.getQuantiles(new double[]{0.0}));
        Assert.assertNull((Object)sketch.getPMF(new float[]{0.0f}));
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(1.0f);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(1.0f);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneItem() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(1.0f);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(1.0f), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0f), (double)1.0);
        Assert.assertEquals((float)sketch.getMinValue(), (float)1.0f);
        Assert.assertEquals((float)sketch.getMaxValue(), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5), (float)1.0f);
    }

    @Test
    public void manyItemsEstimationMode() {
        int i;
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((float)i), (double)trueRank, (double)0.013, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new float[]{500000.0f});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((float)sketch.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.0), (float)0.0f);
        Assert.assertEquals((float)sketch.getMaxValue(), (float)999999.0f);
        Assert.assertEquals((float)sketch.getQuantile(1.0), (float)999999.0f);
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        float[] quantiles = sketch.getQuantiles(fractions);
        float[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        double previousQuantile = 0.0;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            double quantile = sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((double)quantile, (double)quantiles[i3]);
            Assert.assertEquals((double)quantile, (double)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        int n = 1000;
        float[] values = new float[1000];
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
            values[i] = i;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i * 1.0f);
            sketch2.update((float)(20000 - i - 1) * 1.0f);
        }
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxValue(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinValue(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxValue(), (double)19999.0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinValue(), (double)0.0);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)130.0);
    }

    @Test
    public void mergeLowerK() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(256, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getDFSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
            sketch2.update((float)(20000 - i - 1));
        }
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)10000.0f);
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)19999.0f);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)250.0);
    }

    @Test
    public void mergeEmptyLowerK() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(256, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getDFSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinValue(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxValue(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)65.0);
    }

    @Test
    public void mergeExactModeLowerK() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(256, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getDFSketch(128, 0);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        sketch2.update(1.0f);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch1.update(1.0f);
        sketch2.update(2.0f);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)1.0f);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        KllFloatsSketch sketch2 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((float)i);
        }
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinValue(), (float)1.0f);
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)1000000.0f);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(7, 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(65536, 0);
    }

    @Test
    public void minK() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(8, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)175.0);
    }

    @Test
    public void maxK() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(65535, 0);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)6.5);
    }

    @Test
    public void serializeDeserializeEmptyViaCompactHeapify() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((boolean)Double.isNaN(sketch2.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void serializeDeserializeEmptyViaUpdatableWritableWrap() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        byte[] bytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sketch1);
        KllFloatsSketch sketch2 = KllFloatsSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])bytes), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentUpdatableSerializedSizeBytes());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertTrue((boolean)Double.isNaN(sketch2.getMinValue()));
        Assert.assertTrue((boolean)Double.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void serializeDeserializeOneItemViaCompactHeapify() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch1.update(1.0f);
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertFalse((boolean)Double.isNaN(sketch2.getMinValue()));
        Assert.assertFalse((boolean)Double.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)12);
    }

    @Test
    public void serializeDeserializeOneItemViaUpdatableWritableWrap() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch1.update(1.0f);
        byte[] bytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sketch1);
        KllFloatsSketch sketch2 = KllFloatsSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])bytes), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentUpdatableSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)1);
        Assert.assertEquals((long)sketch2.getN(), (long)1L);
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertFalse((boolean)Double.isNaN(sketch2.getMinValue()));
        Assert.assertFalse((boolean)Double.isNaN(sketch2.getMaxValue()));
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)12);
    }

    @Test
    public void serializeDeserializeFullViaCompactHeapify() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((float)i);
        }
        byte[] bytes = sketch1.toByteArray();
        KllFloatsSketch sketch2 = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((float)sketch2.getMinValue(), (float)sketch1.getMinValue());
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)sketch1.getMaxValue());
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void serializeDeserializeFullViaUpdatableWritableWrap() {
        KllFloatsSketch sketch1 = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        int n = 1000;
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((float)i);
        }
        byte[] bytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sketch1);
        KllFloatsSketch sketch2 = KllFloatsSketch.writableWrap((WritableMemory)WritableMemory.writableWrap((byte[])bytes), (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)bytes.length, (int)sketch1.getCurrentUpdatableSerializedSizeBytes());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((int)sketch2.getNumRetained(), (int)sketch1.getNumRetained());
        Assert.assertEquals((long)sketch2.getN(), (long)sketch1.getN());
        Assert.assertEquals((double)sketch2.getNormalizedRankError(false), (double)sketch1.getNormalizedRankError(false));
        Assert.assertEquals((float)sketch2.getMinValue(), (float)sketch1.getMinValue());
        Assert.assertEquals((float)sketch2.getMaxValue(), (float)sketch1.getMaxValue());
        Assert.assertEquals((int)sketch2.getCurrentCompactSerializedSizeBytes(), (int)sketch1.getCurrentCompactSerializedSizeBytes());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(0.0f);
        sketch.getCDF(new float[]{1.0f, 0.0f});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(0.0f);
        sketch.getCDF(new float[]{Float.NaN});
    }

    @Test
    public void getQuantiles() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 0);
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        float[] quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0});
        float[] quantiles2 = sketch.getQuantiles(3);
        Assert.assertEquals((float[])quantiles1, (float[])quantiles2);
        Assert.assertEquals((float)quantiles1[0], (float)1.0f);
        Assert.assertEquals((float)quantiles1[1], (float)2.0f);
        Assert.assertEquals((float)quantiles1[2], (float)3.0f);
    }

    @Test
    public void checkSimpleMergeDirect() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 43;
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)k);
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)k);
        for (i = 1; i <= n1; ++i) {
            sk1.update((float)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((float)(i + 100));
        }
        KllDirectFloatsSketchTest.println("SK1:");
        KllDirectFloatsSketchTest.println(sk1.toString(true, true));
        KllDirectFloatsSketchTest.println("SK2:");
        KllDirectFloatsSketchTest.println(sk2.toString(true, true));
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)sk1));
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2));
        KllFloatsSketch dsk1 = KllFloatsSketch.writableWrap((WritableMemory)wmem1, (MemoryRequestServer)memReqSvr);
        KllFloatsSketch dsk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem2, (MemoryRequestServer)memReqSvr);
        KllDirectFloatsSketchTest.println("BEFORE MERGE");
        KllDirectFloatsSketchTest.println(dsk1.toString(true, true));
        dsk1.merge((KllSketch)dsk2);
        KllDirectFloatsSketchTest.println("AFTER MERGE");
        KllDirectFloatsSketchTest.println(dsk1.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDirectDoubleUpdatableMem() {
        int k = 20;
        KllDirectFloatsSketchTest.println("#### CASE: DOUBLE FULL DIRECT FROM UPDATABLE");
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((float)i);
        }
        byte[] compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDirectFloatsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (boolean)true));
        KllFloatsSketch sk = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)3);
        Assert.assertEquals((double)sk.getMaxFloatValue(), (double)21.0);
        Assert.assertEquals((double)sk.getMinFloatValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectFloatsSketchTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDirectFloatsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (boolean)true));
        sk = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxFloatValue(), (double)Double.NaN);
        Assert.assertEquals((double)sk.getMinFloatValue(), (double)Double.NaN);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllDirectFloatsSketchTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllFloatsSketch.newHeapInstance((int)k);
        sk2.update(1.0f);
        compBytes = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk2);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDirectFloatsSketchTest.println(KllPreambleUtil.toString((byte[])compBytes, (boolean)true));
        sk = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getFloatItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray().length, (int)2);
        Assert.assertEquals((double)sk.getMaxFloatValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMinFloatValue(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkGetWritableMemory() {
        KllFloatsSketch sketch = KllDirectFloatsSketchTest.getDFSketch(200, 200);
        Assert.assertEquals((int)sketch.getK(), (int)200);
        Assert.assertEquals((long)sketch.getN(), (long)200L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isMemoryUpdatableFormat());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertTrue((boolean)sketch.isFloatsSketch());
        Assert.assertFalse((boolean)sketch.isLevelZeroSorted());
        Assert.assertFalse((boolean)sketch.isDoublesSketch());
        WritableMemory wmem = sketch.getWritableMemory();
        KllHeapFloatsSketch sk = KllHeapFloatsSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)200);
        Assert.assertEquals((long)sk.getN(), (long)200L);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isMemoryUpdatableFormat());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertTrue((boolean)sk.isFloatsSketch());
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        Assert.assertFalse((boolean)sk.isDoublesSketch());
    }

    @Test
    public void checkReset() {
        WritableMemory dstMem = WritableMemory.allocate((int)3000);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n1 = sk.getN();
        float min1 = sk.getMinValue();
        float max1 = sk.getMaxValue();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n2 = sk.getN();
        float min2 = sk.getMinValue();
        float max2 = sk.getMaxValue();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((float)min2, (float)min1);
        Assert.assertEquals((float)max2, (float)max1);
    }

    @Test
    public void checkHeapify() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        KllHeapFloatsSketch sk2 = KllHeapFloatsSketch.heapifyImpl((Memory)dstMem);
        Assert.assertEquals((double)sk2.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxValue(), (double)100.0);
    }

    @Test
    public void checkMergeKllFloatsSketch() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((float)(i + 100));
        }
        sk.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxValue(), (double)121.0);
    }

    @Test
    public void checkReverseMergeKllFloatsSketch() {
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllFloatsSketch sk = KllFloatsSketch.newDirectInstance((int)20, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        KllFloatsSketch sk2 = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk2.update((float)(i + 100));
        }
        sk2.merge((KllSketch)sk);
        Assert.assertEquals((double)sk2.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxValue(), (double)121.0);
    }

    @Test
    public void checkWritableWrapOfCompactForm() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)memReqSvr);
        Assert.assertEquals((float)sk2.getMinValue(), (float)1.0f);
        Assert.assertEquals((float)sk2.getMaxValue(), (float)21.0f);
    }

    @Test
    public void chickReadOnlyExceptions() {
        int k = 20;
        float[] fltArr = new float[]{};
        float fltV = 1.0f;
        int idx = 1;
        boolean bool = true;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        try {
            sk2.incN();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.incNumLevels();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setFloatItemsArray(fltArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setFloatItemsArrayAt(idx, fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelZeroSorted(bool);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMaxFloatValue(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinFloatValue(fltV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinK(idx);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setN((long)idx);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setNumLevels(idx);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getDoubleSingleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMergeExceptions() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        WritableMemory srcMem1 = WritableMemory.writableWrap((byte[])sk1.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)srcMem1, (MemoryRequestServer)memReqSvr);
        sk2.merge((KllSketch)sk1);
    }

    @Test
    public void checkMergeExceptionsWrongType() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        try {
            sk1.merge((KllSketch)sk2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.merge((KllSketch)sk1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    private static KllFloatsSketch getDFSketch(int k, int n) {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((float)i);
        }
        byte[] byteArr = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllFloatsSketch dfsk = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return dfsk;
    }

    @Test
    public void printlnTest() {
        KllDirectFloatsSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

