/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketchIterator;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectDoublesSketchIteratorTest {
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void emptySketch() {
        KllDoublesSketch sketch = KllDirectDoublesSketchIteratorTest.getDDSketch(200, 0);
        KllDoublesSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        KllDoublesSketch sketch = KllDirectDoublesSketchIteratorTest.getDDSketch(200, 0);
        sketch.update(0.0);
        KllDoublesSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)it.getValue(), (double)0.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            KllDoublesSketch sketch = KllDirectDoublesSketchIteratorTest.getDDSketch(200, 0);
            for (int i = 0; i < n; ++i) {
                sketch.update((double)i);
            }
            KllDoublesSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }

    private static KllDoublesSketch getDDSketch(int k, int n) {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllDoublesSketch ddsk = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return ddsk;
    }
}

