/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactDoublesSketchTest {
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();

    @Test
    public void checkRODirectUpdatable() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toUpdatableByteArrayImpl((KllSketch)sk);
        Memory srcMem = Memory.wrap((byte[])byteArr);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)srcMem);
        Assert.assertEquals((double)sk2.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxValue(), (double)21.0);
    }

    @Test
    public void checkRODirectCompact() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        Memory srcMem = Memory.wrap((byte[])sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)srcMem);
        KllDirectCompactDoublesSketchTest.println(sk2.toString(true, true));
        Assert.assertEquals((double)sk2.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxValue(), (double)21.0);
        Memory srcMem2 = Memory.wrap((byte[])sk2.toByteArray());
        KllDoublesSketch sk3 = KllDoublesSketch.writableWrap((WritableMemory)((WritableMemory)srcMem2), null);
        Assert.assertEquals((double)sk3.getMinValue(), (double)1.0);
        Assert.assertEquals((double)sk3.getMaxValue(), (double)21.0);
    }

    @Test
    public void checkDirectCompactSingleItem() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        sk.update(1.0);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((double)sk2.getDoubleSingleItem(), (double)1.0);
        sk.update(2.0);
        sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((long)sk2.getN(), (long)2L);
        try {
            sk2.getDoubleSingleItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkDirectCompactGetFloatItemsArray() {
        int i;
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        double[] itemsArr = sk2.getDoubleItemsArray();
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((double)itemsArr[i], (double)0.0);
        }
        sk.update(1.0);
        sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        itemsArr = sk2.getDoubleItemsArray();
        for (i = 0; i < 19; ++i) {
            Assert.assertEquals((double)itemsArr[i], (double)0.0);
        }
        Assert.assertEquals((double)itemsArr[19], (double)1.0);
        for (i = 2; i <= 21; ++i) {
            sk.update((double)i);
        }
        sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        itemsArr = sk2.getDoubleItemsArray();
        Assert.assertEquals((int)itemsArr.length, (int)33);
        Assert.assertEquals((double)itemsArr[22], (double)21.0);
    }

    @Test
    public void checkMinAndMax() {
        int k = 20;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertTrue((boolean)Double.isNaN(sk2.getMaxValue()));
        Assert.assertTrue((boolean)Double.isNaN(sk2.getMinValue()));
        sk.update(1.0);
        sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((double)sk2.getMaxValue(), (double)1.0);
        Assert.assertEquals((double)sk2.getMinValue(), (double)1.0);
        for (int i = 2; i <= 21; ++i) {
            sk.update((double)i);
        }
        sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk.toByteArray()));
        Assert.assertEquals((double)sk2.getMaxValue(), (double)21.0);
        Assert.assertEquals((double)sk2.getMinValue(), (double)1.0);
    }

    @Test
    public void checkQuantile() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance();
        for (int i = 1; i <= 1000; ++i) {
            sk1.update((double)i);
        }
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])sk1.toByteArray()));
        double med2 = sk2.getQuantile(0.5);
        double med1 = sk1.getQuantile(0.5);
        Assert.assertEquals((double)med1, (double)med2);
        KllDirectCompactDoublesSketchTest.println("Med1: " + med1);
        KllDirectCompactDoublesSketchTest.println("Med2: " + med2);
    }

    @Test
    public void checkCompactSingleItemMerge() {
        int k = 20;
        KllDoublesSketch skH1 = KllDoublesSketch.newHeapInstance((int)k);
        skH1.update(21.0);
        KllDoublesSketch skDC1 = KllDoublesSketch.wrap((Memory)Memory.wrap((byte[])skH1.toByteArray()));
        KllDoublesSketch skH20 = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= 20; ++i) {
            skH20.update((double)i);
        }
        skH20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skH20.getN(), (long)21L);
        WritableMemory wmem = WritableMemory.allocate((int)1000);
        KllDoublesSketch skDU20 = KllDoublesSketch.newDirectInstance((int)k, (WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 20; ++i) {
            skDU20.update((double)i);
        }
        skDU20.merge((KllSketch)skDC1);
        Assert.assertEquals((long)skDU20.getN(), (long)21L);
    }

    @Test
    public void printlnTest() {
        KllDirectCompactDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

