/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hllmap;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.hllmap.UniqueCountMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UniqueCountMapTest {
    private static final int INIT_ENTRIES = 211;

    @Test
    public void nullKey() {
        UniqueCountMap map = new UniqueCountMap(4);
        double estimate = map.update(null, null);
        Assert.assertTrue((boolean)Double.isNaN(estimate));
        Assert.assertTrue((boolean)Double.isNaN(map.getEstimate(null)));
        Assert.assertTrue((boolean)Double.isNaN(map.getUpperBound(null)));
        Assert.assertTrue((boolean)Double.isNaN(map.getLowerBound(null)));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrongSizeKeyUpdate() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        byte[] key = new byte[]{0};
        map.update(key, null);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrongSizeKey() {
        UniqueCountMap map = new UniqueCountMap(211, 2);
        UniqueCountMapTest.println(map.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void wrongSizeKeyGetEstimate() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        byte[] key = new byte[]{0};
        map.getEstimate(key);
    }

    @Test
    public void emptyMapNullValue() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        double estimate = map.update("1234".getBytes(StandardCharsets.UTF_8), null);
        Assert.assertEquals((double)estimate, (double)0.0);
    }

    @Test
    public void oneEntry() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        double estimate = map.update("1234".getBytes(StandardCharsets.UTF_8), "a".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)1.0, (double)0.01);
    }

    @Test
    public void duplicateEntry() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        byte[] key = "1234".getBytes(StandardCharsets.UTF_8);
        double estimate = map.update(key, "a".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)1.0);
        estimate = map.update(key, "a".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)1.0);
        estimate = map.update(key, null);
        Assert.assertEquals((double)estimate, (double)1.0);
    }

    @Test
    public void oneKeyTwoValues() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        double estimate = map.update("1234".getBytes(StandardCharsets.UTF_8), "a".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)1.0);
        estimate = map.update("1234".getBytes(StandardCharsets.UTF_8), "b".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)2.0, (double)0.02);
    }

    @Test
    public void oneKeyThreeValues() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        byte[] key = "1234".getBytes(StandardCharsets.UTF_8);
        double estimate = map.update(key, "a".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)1.0);
        estimate = map.update(key, "b".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)2.0);
        estimate = map.update(key, "c".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((double)estimate, (double)3.0);
    }

    @Test
    public void oneKeyManyValues() {
        UniqueCountMap map = new UniqueCountMap(211, 4);
        byte[] key = "1234".getBytes(StandardCharsets.UTF_8);
        byte[] id = new byte[4];
        for (int i = 1; i <= 1000; ++i) {
            id = Util.intToBytes((int)i, (byte[])id);
            double estimate = map.update(key, id);
            if (i % 100 == 0) {
                double err = (estimate / (double)i - 1.0) * 100.0;
                String eStr = String.format("%.3f%%", err);
                UniqueCountMapTest.println("i: " + i + "\t Est: " + estimate + "\t" + eStr);
            }
            Assert.assertEquals((double)estimate, (double)i, (double)((double)i * 0.1));
            Assert.assertEquals((double)map.getEstimate(key), (double)estimate);
            Assert.assertTrue((map.getUpperBound(key) >= estimate ? 1 : 0) != 0);
            Assert.assertTrue((map.getLowerBound(key) <= estimate ? 1 : 0) != 0);
        }
        String out = map.toString();
        UniqueCountMapTest.println(out);
    }

    @Test
    public void manyKeys() {
        double estimate;
        byte[] key;
        int i;
        UniqueCountMap map = new UniqueCountMap(2000, 4);
        for (i = 1; i <= 1000; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            estimate = map.update(key, new byte[]{1});
            Assert.assertEquals((double)estimate, (double)1.0);
        }
        Assert.assertEquals((int)1000, (int)map.getActiveEntries());
        for (i = 1; i <= 1000; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            estimate = map.update(key, new byte[]{2});
            Assert.assertEquals((double)estimate, (double)2.0);
        }
        Assert.assertEquals((int)1000, (int)map.getActiveEntries());
        for (i = 1; i <= 1000; ++i) {
            key = String.format("%4s", i).getBytes(StandardCharsets.UTF_8);
            estimate = map.update(key, new byte[]{3});
            Assert.assertEquals((double)estimate, (double)3.0);
        }
        Assert.assertEquals((int)1000, (int)map.getActiveEntries());
        String out = map.toString();
        UniqueCountMapTest.println(out);
    }

    @Test
    public void forceDeletesAndReuse() {
        int k;
        long h;
        int v;
        UniqueCountMap map = new UniqueCountMap(156, 4);
        byte[] key = new byte[4];
        byte[] id = new byte[8];
        for (v = 1; v <= 200; ++v) {
            h = (int)MurmurHash3.hash((long[])new long[]{v}, (long)0L)[0];
            id = Util.longToBytes((long)h, (byte[])id);
            for (k = 1; k <= 147; ++k) {
                key = Util.intToBytes((int)k, (byte[])key);
                map.update(key, id);
            }
        }
        for (v = 1; v <= 200; ++v) {
            h = (int)MurmurHash3.hash((long[])new long[]{v}, (long)0L)[0];
            id = Util.longToBytes((long)h, (byte[])id);
            for (k = 148; k <= 294; ++k) {
                key = Util.intToBytes((int)k, (byte[])key);
                map.update(key, id);
            }
        }
        Assert.assertNotNull((Object)map.getBaseMap());
        Assert.assertNotNull((Object)map.getHllMap());
    }

    @Test
    public void printlnTest() {
        UniqueCountMapTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

