/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    @Test
    public void preambleToString() {
        int i;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)8, (TgtHllType)TgtHllType.HLL_4);
        byte[] byteArr1 = new byte[bytes];
        WritableMemory wmem1 = WritableMemory.writableWrap((byte[])byteArr1);
        HllSketch sk = new HllSketch(8, TgtHllType.HLL_4, wmem1);
        byte[] byteArr2 = sk.toCompactByteArray();
        WritableMemory wmem2 = WritableMemory.writableWrap((byte[])byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        Assert.assertTrue((boolean)sk.isEmpty());
        String s = HllSketch.toString((byte[])byteArr2);
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((Memory)wmem2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((Memory)wmem2));
        PreambleUtilTest.println("Serialization Bytes: " + wmem2.getCapacity());
        for (i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        byteArr2 = sk.toCompactByteArray();
        wmem2 = WritableMemory.writableWrap((byte[])byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        Assert.assertFalse((boolean)sk.isEmpty());
        s = HllSketch.toString((byte[])byteArr2);
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((Memory)wmem2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((Memory)wmem2));
        PreambleUtilTest.println("Serialization Bytes: " + wmem2.getCapacity());
        for (i = 7; i < 24; ++i) {
            sk.update((long)i);
        }
        byteArr2 = sk.toCompactByteArray();
        wmem2 = WritableMemory.writableWrap((byte[])byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        s = HllSketch.toString((byte[])byteArr2);
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((Memory)wmem2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((Memory)wmem2));
        PreambleUtilTest.println("Serialization Bytes: " + wmem2.getCapacity());
        sk.update(24L);
        byteArr2 = sk.toCompactByteArray();
        wmem2 = WritableMemory.writableWrap((byte[])byteArr2);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.HLL);
        s = HllSketch.toString((Memory)Memory.wrap((byte[])byteArr2));
        PreambleUtilTest.println(s);
        PreambleUtilTest.println("LgArr: " + PreambleUtil.extractLgArr((Memory)wmem2));
        PreambleUtilTest.println("Empty: " + PreambleUtil.extractEmptyFlag((Memory)wmem2));
        PreambleUtilTest.println("Serialization Bytes: " + wmem2.getCapacity());
    }

    @Test
    public void checkCompactFlag() {
        HllSketch sk = new HllSketch(7);
        byte[] memObj = sk.toCompactByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])memObj);
        boolean compact = PreambleUtil.extractCompactFlag((Memory)wmem);
        Assert.assertTrue((boolean)compact);
        PreambleUtil.insertCompactFlag((WritableMemory)wmem, (boolean)false);
        compact = PreambleUtil.extractCompactFlag((Memory)wmem);
        Assert.assertFalse((boolean)compact);
    }

    @Test
    public void checkCorruptMemoryInput() {
        HllSketch bad;
        HllSketch sk = new HllSketch(12);
        byte[] memObj = sk.toCompactByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])memObj);
        long memAdd = wmem.getCumulativeOffset(0L);
        try {
            wmem.putByte((long)PreambleUtil.FAMILY_BYTE, (byte)0);
            bad = HllSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertFamilyId((WritableMemory)wmem);
        try {
            wmem.putByte((long)PreambleUtil.SER_VER_BYTE, (byte)0);
            bad = HllSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertSerVer((WritableMemory)wmem);
        try {
            PreambleUtil.insertPreInts((WritableMemory)wmem, (int)0);
            bad = HllSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((WritableMemory)wmem, (int)2);
        try {
            PreambleUtil.insertPreInts((WritableMemory)wmem, (int)3);
            bad = HllSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((WritableMemory)wmem, (int)2);
        for (int i = 1; i <= 15; ++i) {
            sk.update((long)i);
        }
        memObj = sk.toCompactByteArray();
        wmem = WritableMemory.writableWrap((byte[])memObj);
        memAdd = wmem.getCumulativeOffset(0L);
        try {
            PreambleUtil.insertPreInts((WritableMemory)wmem, (int)2);
            bad = HllSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException i) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((WritableMemory)wmem, (int)3);
        for (int i = 15; i <= 1000; ++i) {
            sk.update((long)i);
        }
        memObj = sk.toCompactByteArray();
        wmem = WritableMemory.writableWrap((byte[])memObj);
        memAdd = wmem.getCumulativeOffset(0L);
        try {
            PreambleUtil.insertPreInts((WritableMemory)wmem, (int)2);
            bad = HllSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertPreInts((WritableMemory)wmem, (int)10);
    }

    @Test
    public void checkExtractFlags() {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)4, (TgtHllType)TgtHllType.HLL_4);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        Object memObj = wmem.getArray();
        long memAdd = wmem.getCumulativeOffset(0L);
        HllSketch sk = new HllSketch(4, TgtHllType.HLL_4, wmem);
        int flags = PreambleUtil.extractFlags((Memory)wmem);
        Assert.assertEquals((int)flags, (int)4);
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

