/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.fdt;

import java.util.List;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.fdt.FdtSketch;
import org.apache.datasketches.fdt.Group;
import org.apache.datasketches.fdt.PostProcessor;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.strings.ArrayOfStringsSummary;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FdtSketchTest {
    private static final String LS = System.getProperty("line.separator");
    private static final char sep = '|';

    @Test
    public void checkFdtSketch() {
        int lgK = 14;
        FdtSketch sketch = new FdtSketch(14);
        Object[] nodesArr = new String[]{"abc", "def"};
        sketch.update((String[])nodesArr);
        SketchIterator it = sketch.iterator();
        int count = 0;
        while (it.next()) {
            Object[] nodesArr2 = ((ArrayOfStringsSummary)it.getSummary()).getValue();
            Assert.assertEquals((Object[])nodesArr2, (Object[])nodesArr);
            ++count;
        }
        Assert.assertEquals((int)count, (int)1);
        byte[] byteArr = sketch.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        FdtSketch sketch2 = new FdtSketch(mem);
        SketchIterator it2 = sketch2.iterator();
        int count2 = 0;
        while (it2.next()) {
            Object[] nodesArr2 = ((ArrayOfStringsSummary)it2.getSummary()).getValue();
            Assert.assertEquals((Object[])nodesArr2, (Object[])nodesArr);
            ++count2;
        }
        Assert.assertEquals((int)count, (int)count2);
        Assert.assertEquals((double)sketch2.getEstimate(), (double)sketch.getEstimate());
        Assert.assertEquals((double)sketch2.getLowerBound(2), (double)sketch.getLowerBound(2));
        Assert.assertEquals((double)sketch2.getUpperBound(2), (double)sketch.getUpperBound(2));
    }

    @Test
    public void checkAlternateLgK() {
        int lgK = FdtSketch.computeLgK((double)0.01, (double)0.01);
        Assert.assertEquals((int)lgK, (int)20);
        lgK = FdtSketch.computeLgK((double)0.02, (double)0.05);
        Assert.assertEquals((int)lgK, (int)15);
        try {
            lgK = FdtSketch.computeLgK((double)0.01, (double)0.001);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFdtSketchWithThreshold() {
        FdtSketch sk = new FdtSketch(0.02, 0.05);
        Assert.assertEquals((int)sk.getLgK(), (int)15);
        FdtSketchTest.println("LgK: " + sk.getLgK());
    }

    @Test
    public void simpleCheckPostProcessing() {
        FdtSketch sk = new FdtSketch(8);
        int[] priKeyIndices = new int[]{0, 2};
        String[] arr1 = new String[]{"a", "1", "c"};
        String[] arr2 = new String[]{"a", "2", "c"};
        String[] arr3 = new String[]{"a", "3", "c"};
        String[] arr4 = new String[]{"a", "4", "c"};
        String[] arr5 = new String[]{"a", "1", "d"};
        String[] arr6 = new String[]{"a", "2", "d"};
        sk.update(arr1);
        sk.update(arr2);
        sk.update(arr3);
        sk.update(arr4);
        sk.update(arr5);
        sk.update(arr6);
        Group gp = new Group();
        PostProcessor post = new PostProcessor(sk, gp, '|');
        post = sk.getPostProcessor(gp, '|');
        post = sk.getPostProcessor();
        List list = post.getGroupList(priKeyIndices, 2, 0);
        Assert.assertEquals((int)list.size(), (int)2);
        Assert.assertEquals((int)post.getGroupCount(), (int)2);
        FdtSketchTest.println(gp.getHeader());
        for (int i = 0; i < list.size(); ++i) {
            FdtSketchTest.println(((Group)list.get(i)).toString());
        }
        list = post.getGroupList(priKeyIndices, 2, 1);
        Assert.assertEquals((int)list.size(), (int)1);
        list = sk.getResult(priKeyIndices, 0, 2, '|');
        Assert.assertEquals((int)list.size(), (int)2);
    }

    @Test
    public void checkEstimatingPostProcessing() {
        FdtSketch sk = new FdtSketch(4);
        int[] priKeyIndices = new int[]{0};
        for (int i = 0; i < 32; ++i) {
            String[] arr = new String[]{"a", Integer.toHexString(i)};
            sk.update(arr);
        }
        Assert.assertTrue((boolean)sk.isEstimationMode());
        List list = sk.getResult(priKeyIndices, 0, 2, '|');
        Assert.assertEquals((int)list.size(), (int)1);
        FdtSketchTest.println(new Group().getHeader());
        for (int i = 0; i < list.size(); ++i) {
            FdtSketchTest.println(((Group)list.get(i)).toString());
        }
    }

    @Test
    public void checkCopyCtor() {
        int lgK = 14;
        FdtSketch sk = new FdtSketch(14);
        String[] nodesArr = new String[]{"abc", "def"};
        sk.update(nodesArr);
        Assert.assertEquals((int)sk.getRetainedEntries(), (int)1);
        FdtSketch sk2 = sk.copy();
        Assert.assertEquals((int)sk2.getRetainedEntries(), (int)1);
    }

    @Test
    public void printlnTest() {
        FdtSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        FdtSketchTest.print(s + LS);
    }

    static void print(String s) {
    }
}

