/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import java.util.Comparator;
import java.util.Random;
import org.apache.datasketches.GenericInequalitySearch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GenericInequalitySearchTest {
    static Random rand = new Random(1L);
    private static final String LS = System.getProperty("line.separator");
    private final Comparator<Float> comparator = Comparator.naturalOrder();

    private static int randDelta() {
        return rand.nextDouble() < 0.4 ? 0 : 1;
    }

    private static Float[] buildRandFloatArr(int len) {
        Float[] arr = new Float[len];
        Float v = Float.valueOf(1.0f);
        for (int i = 0; i < len; ++i) {
            arr[i] = v;
            v = Float.valueOf(v.floatValue() + (float)GenericInequalitySearchTest.randDelta());
        }
        return arr;
    }

    @Test
    private static void checkBuildRandArr() {
        int len = 10;
        for (int i = 0; i < 10; ++i) {
            Float[] tarr = GenericInequalitySearchTest.buildRandFloatArr(10);
            for (int j = 0; j < 10; ++j) {
                GenericInequalitySearchTest.printf("%4.1f,", tarr[j]);
            }
            GenericInequalitySearchTest.println("");
        }
    }

    private static String listFltArray(Float[] arr, int low, int high) {
        StringBuilder sb = new StringBuilder();
        sb.append(LS);
        sb.append("arr: ");
        for (int i = 0; i < arr.length; ++i) {
            if (i == low || i == high) {
                sb.append(String.format("(%.0f) ", arr[i]));
                continue;
            }
            sb.append(String.format("%.0f ", arr[i]));
        }
        return sb.toString();
    }

    @Test
    public void checkBinSearchFltLimits() {
        for (int len = 10; len <= 13; ++len) {
            Float[] tarr = GenericInequalitySearchTest.buildRandFloatArr(len);
            int low = 2;
            int high = len - 2;
            GenericInequalitySearchTest.println(GenericInequalitySearchTest.listFltArray(tarr, 2, high));
            this.checkBinarySearchFloatLimits(tarr, 2, high);
        }
    }

    private void checkBinarySearchFloatLimits(Float[] arr, int low, int high) {
        Float lowV = arr[low];
        Float highV = arr[high];
        Float v = Float.valueOf(lowV.floatValue() - 1.0f);
        int res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.LT, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.LT, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = lowV;
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.LT, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.LT, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = Float.valueOf(highV.floatValue() + 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.LT, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.LT, this.comparator));
        Assert.assertEquals((int)res, (int)high);
        v = Float.valueOf(lowV.floatValue() - 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.LE, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.LE, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.LE, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.LE, this.comparator));
        Assert.assertEquals((int)res, (int)high);
        v = Float.valueOf(highV.floatValue() + 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.LE, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.LE, this.comparator));
        Assert.assertEquals((int)res, (int)high);
        v = Float.valueOf(lowV.floatValue() - 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.EQ, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.EQ, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = highV;
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.EQ, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.EQ, this.comparator));
        Assert.assertEquals((Object)arr[res], (Object)v);
        v = Float.valueOf(highV.floatValue() + 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.EQ, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.EQ, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = Float.valueOf(lowV.floatValue() - 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.GT, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.GT, this.comparator));
        Assert.assertEquals((int)res, (int)low);
        v = highV;
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.GT, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.GT, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = Float.valueOf(highV.floatValue() + 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.GT, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.GT, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
        v = Float.valueOf(lowV.floatValue() - 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.GE, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.GE, this.comparator));
        Assert.assertEquals((int)res, (int)low);
        v = lowV;
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.GE, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.GE, this.comparator));
        Assert.assertEquals((int)res, (int)low);
        v = Float.valueOf(highV.floatValue() + 1.0f);
        res = GenericInequalitySearch.find((Object[])arr, (int)low, (int)high, (Object)v, (GenericInequalitySearch.Inequality)GenericInequalitySearch.Inequality.GE, this.comparator);
        GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, low, high, v, res, GenericInequalitySearch.Inequality.GE, this.comparator));
        Assert.assertEquals((int)res, (int)-1);
    }

    @Test
    public void exerciseFltBinSearch() {
        this.checkFindFloat(GenericInequalitySearch.Inequality.LT);
        this.checkFindFloat(GenericInequalitySearch.Inequality.LE);
        this.checkFindFloat(GenericInequalitySearch.Inequality.GE);
        this.checkFindFloat(GenericInequalitySearch.Inequality.GT);
    }

    private void checkFindFloat(GenericInequalitySearch.Inequality inequality) {
        int i;
        String ie = inequality.name();
        GenericInequalitySearchTest.println("Inequality: " + ie);
        Object[] arr = new Float[]{Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(6.0f), Float.valueOf(6.0f), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(8.0f), Float.valueOf(8.0f)};
        int len = arr.length;
        GenericInequalitySearchTest.print("Index:    ");
        for (i = 0; i < len; ++i) {
            GenericInequalitySearchTest.printf("%d,   ", i);
        }
        GenericInequalitySearchTest.print(LS + "Value:  ");
        for (i = 0; i < len; ++i) {
            GenericInequalitySearchTest.printf("%.1f, ", arr[i]);
        }
        GenericInequalitySearchTest.println("");
        for (float v = 0.5f; v <= arr[len - 1].floatValue() + 0.5f; v += 0.5f) {
            boolean low = false;
            int high = len - 1;
            int idx = GenericInequalitySearch.find((Object[])arr, (int)0, (int)high, (Object)Float.valueOf(v), (GenericInequalitySearch.Inequality)inequality, this.comparator);
            if (idx == -1) {
                GenericInequalitySearchTest.println(ie + ": " + v + " Not resolved, return -1.");
                continue;
            }
            GenericInequalitySearchTest.println(GenericInequalitySearchTest.desc(arr, 0, high, Float.valueOf(v), idx, inequality, this.comparator));
        }
        GenericInequalitySearchTest.println("");
    }

    public static <T> String desc(T[] arr, int low, int high, T v, int idx, GenericInequalitySearch.Inequality inequality, Comparator<T> comparator) {
        switch (inequality) {
            case LT: {
                if (idx == -1) {
                    return "LT: " + v + " <= arr[" + low + "]=" + arr[low] + "; return -1";
                }
                if (idx == high) {
                    return "LT: " + v + " > arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
                }
                return "LT: " + v + ": arr[" + idx + "]=" + arr[idx] + " < " + v + " <= arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
            }
            case LE: {
                if (idx == -1) {
                    return "LE: " + v + " < arr[" + low + "]=" + arr[low] + "; return -1";
                }
                if (idx == high) {
                    return "LE: " + v + " >= arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
                }
                return "LE: " + v + ": arr[" + idx + "]=" + arr[idx] + " <= " + v + " < arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
            }
            case EQ: {
                if (idx == -1) {
                    if (comparator.compare(v, arr[high]) > 0) {
                        return "EQ: " + v + " > arr[" + high + "]; return -1";
                    }
                    if (comparator.compare(v, arr[low]) < 0) {
                        return "EQ: " + v + " < arr[" + low + "]; return -1";
                    }
                    return "EQ: " + v + " Cannot be found within arr[" + low + "], arr[" + high + "]; return -1";
                }
                return "EQ: " + v + " == arr[" + idx + "]; return " + idx;
            }
            case GE: {
                if (idx == -1) {
                    return "GE: " + v + " > arr[" + high + "]=" + arr[high] + "; return -1";
                }
                if (idx == low) {
                    return "GE: " + v + " <= arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
                }
                return "GE: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " < " + v + " <= arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
            }
            case GT: {
                if (idx == -1) {
                    return "GT: " + v + " >= arr[" + high + "]=" + arr[high] + "; return -1";
                }
                if (idx == low) {
                    return "GT: " + v + " < arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
                }
                return "GT: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " <= " + v + " < arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
            }
        }
        return "";
    }

    static final void printf(String format, Object ... args) {
    }

    static final void println(Object o) {
    }

    static final void print(Object o) {
    }
}

