/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.ByteArrayUtil;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapHashIterator;
import org.apache.datasketches.theta.PreambleUtil;

final class SingleItemSketch
extends CompactSketch {
    private static final long DEFAULT_SEED_HASH = (long)Util.computeSeedHash(9001L) & 0xFFFFL;
    private static final long PRE0_LO6_SI = 63771674608385L;
    private long pre0_ = 0L;
    private long hash_ = 0L;

    private SingleItemSketch(long hash) {
        this.pre0_ = DEFAULT_SEED_HASH << 48 | 0x3A0000030301L;
        this.hash_ = hash;
    }

    SingleItemSketch(long hash, long seed) {
        long seedHash = (long)Util.computeSeedHash(seed) & 0xFFFFL;
        this.pre0_ = seedHash << 48 | 0x3A0000030301L;
        this.hash_ = hash;
    }

    SingleItemSketch(long hash, short seedHash) {
        long seedH = (long)seedHash & 0xFFFFL;
        this.pre0_ = seedH << 48 | 0x3A0000030301L;
        this.hash_ = hash;
    }

    public static SingleItemSketch heapify(Memory srcMem) {
        return SingleItemSketch.heapify(srcMem, 9001L);
    }

    public static SingleItemSketch heapify(Memory srcMem, long seed) {
        short seedHashMem = PreambleUtil.checkMemorySeedHash(srcMem, seed);
        boolean singleItem = SingleItemSketch.otherCheckForSingleItem(srcMem);
        if (singleItem) {
            return new SingleItemSketch(srcMem.getLong(8L), seedHashMem);
        }
        throw new SketchesArgumentException("Input Memory is not a SingleItemSketch.");
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        if (dstMem == null) {
            return this;
        }
        dstMem.putLong(0L, this.pre0_);
        dstMem.putLong(8L, this.hash_);
        return new DirectCompactSketch((Memory)dstMem);
    }

    static SingleItemSketch create(long datum) {
        long[] data = new long[]{datum};
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(String datum) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(char[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(int[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(long[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, 9001L)[0] >>> 1);
    }

    static SingleItemSketch create(long datum, long seed) {
        long[] data = new long[]{datum};
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1);
    }

    static SingleItemSketch create(double datum, long seed) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(String datum, long seed) {
        if (datum == null || datum.isEmpty()) {
            return null;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(byte[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(char[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(int[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    static SingleItemSketch create(long[] data, long seed) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new SingleItemSketch(MurmurHash3.hash(data, seed)[0] >>> 1, seed);
    }

    @Override
    public int getCountLessThanThetaLong(long thetaLong) {
        return this.hash_ < thetaLong ? 1 : 0;
    }

    @Override
    public int getCurrentBytes() {
        return 16;
    }

    @Override
    public double getEstimate() {
        return 1.0;
    }

    @Override
    public HashIterator iterator() {
        return new HeapHashIterator(new long[]{this.hash_}, 1, Long.MAX_VALUE);
    }

    @Override
    public double getLowerBound(int numStdDev) {
        return 1.0;
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return 1;
    }

    @Override
    public long getThetaLong() {
        return Long.MAX_VALUE;
    }

    @Override
    public double getUpperBound(int numStdDev) {
        return 1.0;
    }

    @Override
    public boolean hasMemory() {
        return false;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public byte[] toByteArray() {
        byte[] out = new byte[16];
        ByteArrayUtil.putLongLE(out, 0, this.pre0_);
        ByteArrayUtil.putLongLE(out, 8, this.hash_);
        return out;
    }

    @Override
    long[] getCache() {
        return new long[]{this.hash_};
    }

    @Override
    int getCompactPreambleLongs() {
        return 1;
    }

    @Override
    int getCurrentPreambleLongs() {
        return 1;
    }

    @Override
    Memory getMemory() {
        return null;
    }

    @Override
    short getSeedHash() {
        return (short)(this.pre0_ >>> 48);
    }

    static final boolean otherCheckForSingleItem(Memory mem) {
        return SingleItemSketch.otherCheckForSingleItem(PreambleUtil.extractPreLongs(mem), PreambleUtil.extractSerVer(mem), PreambleUtil.extractFamilyID(mem), PreambleUtil.extractFlags(mem));
    }

    static final boolean otherCheckForSingleItem(int preLongs, int serVer, int famId, int flags) {
        boolean numPreLongs = preLongs == 1;
        boolean numSerVer = serVer >= 3;
        boolean numFamId = famId == Family.COMPACT.getID();
        boolean numFlags = (flags & 0x1F) == 26;
        boolean singleFlag = (flags & 0x20) > 0;
        return numPreLongs && numSerVer && numFamId && numFlags || singleFlag;
    }
}

