/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SingleItemSketchTest {
    static final short DEFAULT_SEED_HASH = (short)((long)Util.computeSeedHash((long)9001L) & 0xFFFFL);
    static final long SiSkPre0WithSiFlag = -7796793083210562815L;
    static final long SiSkPre0WoutSiFlag = -7796828267582651647L;
    static final long Hash = 405753591161026837L;

    @Test
    public void check1() {
        Union union = Sketches.setOperationBuilder().buildUnion();
        union.union((Sketch)SingleItemSketch.create((long)1L));
        union.union((Sketch)SingleItemSketch.create((double)1.0));
        union.union((Sketch)SingleItemSketch.create((double)0.0));
        union.union((Sketch)SingleItemSketch.create((String)"1"));
        union.union((Sketch)SingleItemSketch.create((byte[])new byte[]{1, 2, 3, 4}));
        union.union((Sketch)SingleItemSketch.create((char[])new char[]{'a'}));
        union.union((Sketch)SingleItemSketch.create((int[])new int[]{2}));
        union.union((Sketch)SingleItemSketch.create((long[])new long[]{3L}));
        union.union((Sketch)SingleItemSketch.create((double)-0.0));
        double est = union.getResult().getEstimate();
        SingleItemSketchTest.println("" + est);
        Assert.assertEquals((double)est, (double)8.0, (double)0.0);
        Assert.assertNull((Object)SingleItemSketch.create((String)""));
        String str = null;
        Assert.assertNull((Object)SingleItemSketch.create(str));
        Assert.assertNull((Object)SingleItemSketch.create((byte[])new byte[0]));
        byte[] byteArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(byteArr));
        Assert.assertNull((Object)SingleItemSketch.create((char[])new char[0]));
        char[] charArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(charArr));
        Assert.assertNull((Object)SingleItemSketch.create((int[])new int[0]));
        int[] intArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(intArr));
        Assert.assertNull((Object)SingleItemSketch.create((long[])new long[0]));
        long[] longArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(longArr));
    }

    @Test
    public void check2() {
        long seed = 9001L;
        Union union = Sketches.setOperationBuilder().buildUnion();
        union.union((Sketch)SingleItemSketch.create((long)1L, (long)seed));
        union.union((Sketch)SingleItemSketch.create((double)1.0, (long)seed));
        union.union((Sketch)SingleItemSketch.create((double)0.0, (long)seed));
        union.union((Sketch)SingleItemSketch.create((String)"1", (long)seed));
        union.union((Sketch)SingleItemSketch.create((byte[])new byte[]{1, 2, 3, 4}, (long)seed));
        union.union((Sketch)SingleItemSketch.create((char[])new char[]{'a'}, (long)seed));
        union.union((Sketch)SingleItemSketch.create((int[])new int[]{2}, (long)seed));
        union.union((Sketch)SingleItemSketch.create((long[])new long[]{3L}, (long)seed));
        union.union((Sketch)SingleItemSketch.create((double)-0.0, (long)seed));
        double est = union.getResult().getEstimate();
        SingleItemSketchTest.println("" + est);
        Assert.assertEquals((double)est, (double)8.0, (double)0.0);
        Assert.assertNull((Object)SingleItemSketch.create((String)"", (long)seed));
        String str = null;
        Assert.assertNull((Object)SingleItemSketch.create(str, (long)seed));
        Assert.assertNull((Object)SingleItemSketch.create((byte[])new byte[0], (long)seed));
        byte[] byteArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(byteArr, (long)seed));
        Assert.assertNull((Object)SingleItemSketch.create((char[])new char[0], (long)seed));
        char[] charArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(charArr, (long)seed));
        Assert.assertNull((Object)SingleItemSketch.create((int[])new int[0], (long)seed));
        int[] intArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(intArr, (long)seed));
        Assert.assertNull((Object)SingleItemSketch.create((long[])new long[0], (long)seed));
        long[] longArr = null;
        Assert.assertNull((Object)SingleItemSketch.create(longArr, (long)seed));
    }

    @Test
    public void checkSketchInterface() {
        SingleItemSketch sis = SingleItemSketch.create((long)1L);
        Assert.assertEquals((int)sis.getCompactBytes(), (int)16);
        Assert.assertEquals((double)sis.getEstimate(), (double)1.0);
        Assert.assertEquals((double)sis.getLowerBound(1), (double)1.0);
        Assert.assertEquals((int)sis.getRetainedEntries(true), (int)1);
        Assert.assertEquals((double)sis.getUpperBound(1), (double)1.0);
        Assert.assertFalse((boolean)sis.isDirect());
        Assert.assertFalse((boolean)sis.hasMemory());
        Assert.assertFalse((boolean)sis.isEmpty());
        Assert.assertTrue((boolean)sis.isOrdered());
    }

    @Test
    public void checkLessThanThetaLong() {
        for (int i = 0; i < 10; ++i) {
            long[] data = new long[]{i};
            long h = MurmurHash3.hash((long[])data, (long)9001L)[0] >>> 1;
            SingleItemSketch sis = SingleItemSketch.create((long)i);
            long halfMax = 0x3FFFFFFFFFFFFFFFL;
            int count = sis.getCountLessThanThetaLong(halfMax);
            Assert.assertEquals((int)count, (int)(h < halfMax ? 1 : 0));
        }
    }

    @Test
    public void checkSerDe() {
        SingleItemSketch sis = SingleItemSketch.create((long)1L);
        byte[] byteArr = sis.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        SingleItemSketch sis2 = SingleItemSketch.heapify((Memory)mem);
        Assert.assertEquals((double)sis2.getEstimate(), (double)1.0);
        SingleItemSketch sis3 = SingleItemSketch.heapify((Memory)mem, (long)9001L);
        Assert.assertEquals((double)sis2.getEstimate(), (double)1.0);
        Union union = Sketches.setOperationBuilder().buildUnion();
        union.union((Sketch)sis);
        union.union((Sketch)sis2);
        union.union((Sketch)sis3);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)1.0);
    }

    @Test
    public void checkRestricted() {
        SingleItemSketch sis = SingleItemSketch.create((long)1L);
        Assert.assertNull((Object)sis.getMemory());
        Assert.assertEquals((int)sis.getCompactPreambleLongs(), (int)1);
    }

    @Test
    public void unionWrapped() {
        SingleItemSketch sketch = SingleItemSketch.create((long)1L);
        Union union = Sketches.setOperationBuilder().buildUnion();
        Memory mem = Memory.wrap((byte[])sketch.toByteArray());
        union.union(mem);
        Assert.assertEquals((double)union.getResult().getEstimate(), (double)1.0, (double)0.0);
    }

    @Test
    public void buildAndCompact() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        sk1.update(1L);
        CompactSketch csk = sk1.compact(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = sk1.compact(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        int bytes = Sketches.getMaxUpdateSketchBytes((int)32);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        sk1 = Sketches.updateSketchBuilder().setNominalEntries(32).build(wmem);
        sk1.update(1L);
        csk = sk1.compact(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = sk1.compact(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        bytes = Sketches.getMaxCompactSketchBytes((int)1);
        wmem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        csk = sk1.compact(true, wmem);
        Assert.assertTrue((boolean)csk.isOrdered());
        csk = sk1.compact(false, wmem);
        Assert.assertTrue((boolean)csk.isOrdered());
    }

    @Test
    public void intersection() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        sk1.update(1L);
        sk1.update(2L);
        sk2.update(1L);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)sk1);
        inter.intersect((Sketch)sk2);
        CompactSketch csk = inter.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        int bytes = Sketches.getMaxIntersectionBytes((int)32);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        inter = Sketches.setOperationBuilder().buildIntersection(wmem);
        inter.intersect((Sketch)sk1);
        inter.intersect((Sketch)sk2);
        csk = inter.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = inter.getResult(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void union() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        sk1.update(1L);
        sk2.update(1L);
        Union union = Sketches.setOperationBuilder().buildUnion();
        union.union((Sketch)sk1);
        union.union((Sketch)sk2);
        CompactSketch csk = union.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        int bytes = Sketches.getMaxUnionBytes((int)32);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        union = Sketches.setOperationBuilder().buildUnion(wmem);
        union.union((Sketch)sk1);
        union.union((Sketch)sk2);
        csk = union.getResult(true, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        csk = union.getResult(false, null);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void aNotB() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().setNominalEntries(32).build();
        sk1.update(1L);
        sk2.update(2L);
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        aNotB.setA((Sketch)sk1);
        aNotB.notB((Sketch)sk2);
        CompactSketch csk = aNotB.getResult(true, null, true);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void checkHeapifyInstance() {
        UpdateSketch sk1 = new UpdateSketchBuilder().build();
        sk1.update(1L);
        UpdateSketch sk2 = new UpdateSketchBuilder().build();
        sk2.update(1L);
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)sk1);
        inter.intersect((Sketch)sk2);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[16]);
        CompactSketch csk = inter.getResult(false, wmem);
        Assert.assertTrue((boolean)csk.isOrdered());
        Sketch csk2 = Sketches.heapifySketch((Memory)wmem);
        Assert.assertTrue((boolean)(csk2 instanceof SingleItemSketch));
        SingleItemSketchTest.println(csk2.toString(true, true, 1, true));
    }

    @Test
    public void checkSingleItemBadFlags() {
        UpdateSketch sk1 = new UpdateSketchBuilder().build();
        sk1.update(1L);
        WritableMemory wmem = WritableMemory.allocate((int)16);
        sk1.compact(true, wmem);
        wmem.putByte(5L, (byte)0);
        try {
            SingleItemSketch.heapify((Memory)wmem);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkDirectUnionSingleItem2() {
        Sketch sk = Sketch.wrap((Memory)SingleItemSketchTest.siSkWoutSiFlag24Bytes());
        Assert.assertEquals((double)sk.getEstimate(), (double)1.0, (double)0.0);
        sk = Sketch.wrap((Memory)SingleItemSketchTest.siSkWithSiFlag24Bytes());
        Assert.assertEquals((double)sk.getEstimate(), (double)1.0, (double)0.0);
    }

    @Test
    public void checkSingleItemCompact() {
        UpdateSketch sk1 = new UpdateSketchBuilder().build();
        sk1.update(1L);
        CompactSketch csk = sk1.compact();
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
        CompactSketch csk2 = csk.compact();
        Assert.assertEquals((Object)csk, (Object)csk2);
        CompactSketch csk3 = csk.compact(true, WritableMemory.allocate((int)16));
        Assert.assertTrue((boolean)(csk3 instanceof DirectCompactSketch));
        Assert.assertEquals((int)csk2.getCurrentPreambleLongs(), (int)1);
        Assert.assertEquals((int)csk3.getCurrentPreambleLongs(), (int)1);
    }

    static Memory siSkWithSiFlag24Bytes() {
        int cap = 24;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        wmem.putLong(0L, -7796793083210562815L);
        wmem.putLong(8L, 405753591161026837L);
        return wmem;
    }

    static Memory siSkWoutSiFlag24Bytes() {
        int cap = 24;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        wmem.putLong(0L, -7796828267582651647L);
        wmem.putLong(8L, 405753591161026837L);
        return wmem;
    }

    @Test
    public void printlnTest() {
        SingleItemSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

