/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.SketchesReadOnlyException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReadOnlyMemoryTest {
    @Test
    public void wrapAndTryUpdatingUpdateSketch() {
        UpdateSketch updateSketch = UpdateSketch.builder().build();
        updateSketch.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(updateSketch.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        UpdateSketch sketch = (UpdateSketch)Sketch.wrap((Memory)mem);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
        boolean thrown = false;
        try {
            sketch.update(2L);
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void wrapCompactUnorderedSketch() {
        UpdateSketch updateSketch = UpdateSketch.builder().build();
        updateSketch.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(updateSketch.compact(false, null).toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Sketch sketch = Sketch.wrap((Memory)mem);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
    }

    @Test
    public void wrapCompactOrderedSketch() {
        UpdateSketch updateSketch = UpdateSketch.builder().build();
        updateSketch.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(updateSketch.compact().toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Sketch sketch = Sketch.wrap((Memory)mem);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
    }

    @Test
    public void heapifyUpdateSketch() {
        UpdateSketch us1 = UpdateSketch.builder().build();
        us1.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(us1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        UpdateSketch us2 = (UpdateSketch)Sketch.heapify((Memory)mem);
        us2.update(2L);
        Assert.assertEquals((double)us2.getEstimate(), (double)2.0);
    }

    @Test
    public void heapifyCompactUnorderedSketch() {
        UpdateSketch updateSketch = UpdateSketch.builder().build();
        updateSketch.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(updateSketch.compact(false, null).toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Sketch sketch = Sketch.heapify((Memory)mem);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
    }

    @Test
    public void heapifyCompactOrderedSketch() {
        UpdateSketch updateSketch = UpdateSketch.builder().build();
        updateSketch.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(updateSketch.compact().toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Sketch sketch = Sketch.heapify((Memory)mem);
        Assert.assertEquals((double)sketch.getEstimate(), (double)1.0);
    }

    @Test
    public void heapifyUnion() {
        Union u1 = SetOperation.builder().buildUnion();
        u1.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(u1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Union u2 = (Union)SetOperation.heapify((Memory)mem);
        u2.update(2L);
        Assert.assertEquals((double)u2.getResult().getEstimate(), (double)2.0);
    }

    @Test
    public void wrapAndTryUpdatingUnion() {
        Union u1 = SetOperation.builder().buildUnion();
        u1.update(1L);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(u1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Union u2 = (Union)Sketches.wrapSetOperation((Memory)mem);
        Union u3 = Sketches.wrapUnion((Memory)mem);
        Assert.assertEquals((double)u2.getResult().getEstimate(), (double)1.0);
        Assert.assertEquals((double)u3.getResult().getEstimate(), (double)1.0);
        try {
            u2.update(2L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
        try {
            u3.update(2L);
            Assert.fail();
        }
        catch (SketchesReadOnlyException sketchesReadOnlyException) {
            // empty catch block
        }
    }

    @Test
    public void heapifyIntersection() {
        UpdateSketch us1 = UpdateSketch.builder().build();
        us1.update(1L);
        us1.update(2L);
        UpdateSketch us2 = UpdateSketch.builder().build();
        us2.update(2L);
        us2.update(3L);
        Intersection i1 = SetOperation.builder().buildIntersection();
        i1.intersect((Sketch)us1);
        i1.intersect((Sketch)us2);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(i1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Intersection i2 = (Intersection)SetOperation.heapify((Memory)mem);
        i2.intersect((Sketch)us1);
        Assert.assertEquals((double)i2.getResult().getEstimate(), (double)1.0);
    }

    @Test
    public void wrapIntersection() {
        UpdateSketch us1 = UpdateSketch.builder().build();
        us1.update(1L);
        us1.update(2L);
        UpdateSketch us2 = UpdateSketch.builder().build();
        us2.update(2L);
        us2.update(3L);
        Intersection i1 = SetOperation.builder().buildIntersection();
        i1.intersect((Sketch)us1);
        i1.intersect((Sketch)us2);
        Memory mem = Memory.wrap((ByteBuffer)ByteBuffer.wrap(i1.toByteArray()).asReadOnlyBuffer().order(ByteOrder.nativeOrder()));
        Intersection i2 = (Intersection)SetOperation.wrap((Memory)mem);
        Assert.assertEquals((double)i2.getResult().getEstimate(), (double)1.0);
        boolean thrown = false;
        try {
            i2.intersect((Sketch)us1);
        }
        catch (SketchesReadOnlyException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void printlnTest() {
        ReadOnlyMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

