/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import org.apache.datasketches.Family;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.sampling.ReservoirLongsSketch;
import org.apache.datasketches.sampling.ReservoirSize;
import org.apache.datasketches.sampling.SampleSubsetSummary;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReservoirLongsSketchTest {
    private static final double EPS = 1.0E-8;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkInvalidK() {
        ReservoirLongsSketch.newInstance((int)0);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreLongs() {
        WritableMemory mem = ReservoirLongsSketchTest.getBasicSerializedRLS();
        mem.putByte(0L, (byte)0);
        ReservoirLongsSketch.heapify((Memory)mem);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        WritableMemory mem = ReservoirLongsSketchTest.getBasicSerializedRLS();
        mem.putByte(1L, (byte)0);
        ReservoirLongsSketch.heapify((Memory)mem);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadFamily() {
        WritableMemory mem = ReservoirLongsSketchTest.getBasicSerializedRLS();
        mem.putByte(2L, (byte)0);
        ReservoirLongsSketch.heapify((Memory)mem);
        Assert.fail();
    }

    @Test
    public void checkEmptySketch() {
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)5);
        Assert.assertTrue((rls.getSamples() == null ? 1 : 0) != 0);
        byte[] sketchBytes = rls.toByteArray();
        Memory mem = Memory.wrap((byte[])sketchBytes);
        Assert.assertEquals((int)sketchBytes.length, (int)(Family.RESERVOIR.getMinPreLongs() << 3));
        ReservoirLongsSketch loadedRls = ReservoirLongsSketch.heapify((Memory)mem);
        Assert.assertEquals((int)loadedRls.getNumSamples(), (int)0);
        ReservoirLongsSketchTest.println("Empty sketch:");
        ReservoirLongsSketchTest.println(rls.toString());
        ReservoirLongsSketch.toString((byte[])sketchBytes);
        ReservoirLongsSketch.toString((Memory)mem);
    }

    @Test
    public void checkUnderFullReservoir() {
        int k = 128;
        int n = 64;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)128);
        for (int i = 0; i < 64; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((int)rls.getNumSamples(), (int)64);
        long[] data = rls.getSamples();
        Assert.assertEquals((long)rls.getNumSamples(), (long)rls.getN());
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((int)data.length, (int)64);
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((long)data[i], (long)i);
        }
        ReservoirLongsSketchTest.validateSerializeAndDeserialize(rls);
    }

    @Test
    public void checkFullReservoir() {
        int k = 1000;
        int n = 2000;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)1000, (ResizeFactor)ResizeFactor.X2);
        for (int i = 0; i < 2000; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((int)rls.getNumSamples(), (int)rls.getK());
        ReservoirLongsSketchTest.validateSerializeAndDeserialize(rls);
        ReservoirLongsSketchTest.println("Full reservoir:");
        ReservoirLongsSketchTest.println(rls.toString());
    }

    @Test
    public void checkDownsampledCopy() {
        int i;
        int k = 256;
        int tgtK = 64;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)256);
        for (i = 0; i < 63; ++i) {
            rls.update((long)i);
        }
        ReservoirLongsSketch dsCopy = rls.downsampledCopy(64);
        Assert.assertEquals((int)dsCopy.getK(), (int)64);
        ReservoirLongsSketchTest.validateReservoirEquality(rls, dsCopy);
        while (i < 255) {
            rls.update((long)i);
            ++i;
        }
        Assert.assertEquals((long)rls.getN(), (long)255L);
        dsCopy = rls.downsampledCopy(64);
        Assert.assertEquals((long)dsCopy.getN(), (long)rls.getN());
        Assert.assertEquals((int)dsCopy.getNumSamples(), (int)64);
        while (i < 512) {
            rls.update((long)i);
            ++i;
        }
        Assert.assertEquals((long)rls.getN(), (long)512L);
        dsCopy = rls.downsampledCopy(64);
        Assert.assertEquals((long)dsCopy.getN(), (long)rls.getN());
        Assert.assertEquals((int)dsCopy.getNumSamples(), (int)64);
    }

    @Test
    public void checkBadConstructorArgs() {
        long[] data = new long[128];
        for (int i = 0; i < 128; ++i) {
            data[i] = i;
        }
        ResizeFactor rf = ResizeFactor.X8;
        try {
            ReservoirLongsSketch.getInstance(null, (long)128L, (ResizeFactor)rf, (int)128);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("null reservoir"));
        }
        try {
            ReservoirLongsSketch.getInstance((long[])data, (long)128L, (ResizeFactor)rf, (int)1);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("size less than 2"));
        }
        try {
            ReservoirLongsSketch.getInstance((long[])data, (long)128L, (ResizeFactor)rf, (int)64);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("max size less than array length"));
        }
        try {
            ReservoirLongsSketch.getInstance((long[])data, (long)512L, (ResizeFactor)rf, (int)256);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("too few samples"));
        }
        try {
            ReservoirLongsSketch.getInstance((long[])data, (long)256L, (ResizeFactor)rf, (int)256);
            Assert.fail();
        }
        catch (SketchesException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("too few samples"));
        }
    }

    @Test
    public void checkSketchCapacity() {
        long[] data = new long[64];
        long itemsSeen = 0xFFFFFFFFFFFEL;
        ReservoirLongsSketch rls = ReservoirLongsSketch.getInstance((long[])data, (long)0xFFFFFFFFFFFEL, (ResizeFactor)ResizeFactor.X8, (int)data.length);
        rls.update(0L);
        try {
            rls.update(0L);
            Assert.fail();
        }
        catch (SketchesStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Sketch has exceeded capacity for total items seen"));
        }
        rls.reset();
        Assert.assertEquals((long)rls.getN(), (long)0L);
        rls.update(1L);
        Assert.assertEquals((long)rls.getN(), (long)1L);
    }

    @Test
    public void checkSampleWeight() {
        int i;
        int k = 32;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)32);
        for (i = 0; i < 16; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((double)rls.getImplicitSampleWeight(), (double)1.0);
        for (i = 0; i < 32; ++i) {
            rls.update((long)i);
        }
        Assert.assertTrue((Math.abs(rls.getImplicitSampleWeight() - 1.5) < 1.0E-8 ? 1 : 0) != 0);
    }

    @Test
    public void checkVersionConversion() {
        int k = 32768;
        short encK = ReservoirSize.computeSize((int)32768);
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)32768);
        byte[] sketchBytesOrig = rls.toByteArray();
        byte[] sketchBytes = rls.toByteArray();
        WritableMemory sketchMem = WritableMemory.writableWrap((byte[])sketchBytes);
        sketchMem.putByte(1L, (byte)1);
        sketchMem.putInt(4L, 0);
        sketchMem.putShort(4L, encK);
        ReservoirLongsSketch rebuilt = ReservoirLongsSketch.heapify((Memory)sketchMem);
        byte[] rebuiltBytes = rebuilt.toByteArray();
        Assert.assertEquals((int)sketchBytesOrig.length, (int)rebuiltBytes.length);
        for (int i = 0; i < sketchBytesOrig.length; ++i) {
            Assert.assertEquals((byte)sketchBytesOrig[i], (byte)rebuiltBytes[i]);
        }
    }

    @Test
    public void checkSetAndGetValue() {
        int k = 20;
        int tgtIdx = 5;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)20);
        for (int i = 0; i < 20; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((long)rls.getValueAtPosition(5), (long)5L);
        rls.insertValueAtPosition(-1L, 5);
        Assert.assertEquals((long)rls.getValueAtPosition(5), (long)-1L);
    }

    @Test
    public void checkBadSetAndGetValue() {
        int k = 20;
        int tgtIdx = 5;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)20);
        try {
            rls.getValueAtPosition(0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        for (int i = 0; i < 20; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((long)rls.getValueAtPosition(5), (long)5L);
        try {
            rls.insertValueAtPosition(-1L, -1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            rls.insertValueAtPosition(-1L, 21);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            rls.getValueAtPosition(-1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            rls.getValueAtPosition(21);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkForceIncrement() {
        int k = 100;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)100);
        for (int i = 0; i < 200; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((long)rls.getN(), (long)200L);
        rls.forceIncrementItemsSeen(100L);
        Assert.assertEquals((long)rls.getN(), (long)300L);
        try {
            rls.forceIncrementItemsSeen(0xFFFFFFFFFFFFL);
            Assert.fail();
        }
        catch (SketchesStateException sketchesStateException) {
            // empty catch block
        }
    }

    @Test
    public void checkEstimateSubsetSum() {
        long i;
        int k = 10;
        ReservoirLongsSketch sketch = ReservoirLongsSketch.newInstance((int)10);
        SampleSubsetSummary ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)0.0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)0.0);
        double itemCount = 0.0;
        for (i = 1L; i <= 9L; ++i) {
            sketch.update(i);
            itemCount += 1.0;
        }
        ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)itemCount);
        Assert.assertEquals((double)ss.getLowerBound(), (double)itemCount);
        Assert.assertEquals((double)ss.getUpperBound(), (double)itemCount);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
        for (i = 10L; i <= 11L; ++i) {
            sketch.update(i);
            itemCount += 1.0;
        }
        ss = sketch.estimateSubsetSum(item -> true);
        Assert.assertEquals((double)ss.getEstimate(), (double)itemCount);
        Assert.assertEquals((double)ss.getUpperBound(), (double)itemCount);
        Assert.assertTrue((ss.getLowerBound() < itemCount ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
        ss = sketch.estimateSubsetSum(item -> false);
        Assert.assertEquals((double)ss.getEstimate(), (double)0.0);
        Assert.assertEquals((double)ss.getLowerBound(), (double)0.0);
        Assert.assertTrue((ss.getUpperBound() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
        for (i = 1L; i <= 11L; ++i) {
            sketch.update(-i);
            itemCount += 1.0;
        }
        ss = sketch.estimateSubsetSum(item -> item < 0L);
        Assert.assertTrue((ss.getEstimate() >= ss.getLowerBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getEstimate() <= ss.getUpperBound() ? 1 : 0) != 0);
        Assert.assertTrue((ss.getLowerBound() < itemCount / 1.4 ? 1 : 0) != 0);
        Assert.assertTrue((ss.getUpperBound() > itemCount / 2.6 ? 1 : 0) != 0);
        Assert.assertEquals((double)ss.getTotalSketchWeight(), (double)itemCount);
    }

    private static WritableMemory getBasicSerializedRLS() {
        int k = 10;
        int n = 20;
        ReservoirLongsSketch rls = ReservoirLongsSketch.newInstance((int)10);
        Assert.assertEquals((int)rls.getNumSamples(), (int)0);
        for (int i = 0; i < 20; ++i) {
            rls.update((long)i);
        }
        Assert.assertEquals((int)rls.getNumSamples(), (int)Math.min(20, 10));
        Assert.assertEquals((long)rls.getN(), (long)20L);
        Assert.assertEquals((int)rls.getK(), (int)10);
        byte[] sketchBytes = rls.toByteArray();
        return WritableMemory.writableWrap((byte[])sketchBytes);
    }

    private static void validateSerializeAndDeserialize(ReservoirLongsSketch rls) {
        byte[] sketchBytes = rls.toByteArray();
        Assert.assertEquals((int)sketchBytes.length, (int)(Family.RESERVOIR.getMaxPreLongs() + rls.getNumSamples() << 3));
        Memory mem = Memory.wrap((byte[])sketchBytes);
        ReservoirLongsSketch loadedRls = ReservoirLongsSketch.heapify((Memory)mem);
        ReservoirLongsSketchTest.validateReservoirEquality(rls, loadedRls);
    }

    static void validateReservoirEquality(ReservoirLongsSketch rls1, ReservoirLongsSketch rls2) {
        Assert.assertEquals((int)rls1.getNumSamples(), (int)rls2.getNumSamples());
        if (rls1.getNumSamples() == 0) {
            return;
        }
        long[] samples1 = rls1.getSamples();
        long[] samples2 = rls2.getSamples();
        Assert.assertNotNull((Object)samples1);
        Assert.assertNotNull((Object)samples2);
        Assert.assertEquals((int)samples1.length, (int)samples2.length);
        for (int i = 0; i < samples1.length; ++i) {
            Assert.assertEquals((long)samples1[i], (long)samples2[i]);
        }
    }

    static String printBytesAsLongs(byte[] byteArr) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < byteArr.length; i += 8) {
            for (int j = i + 7; j >= i; --j) {
                String str = Integer.toHexString(byteArr[j] & 0xFF);
                sb.append(Util.zeroPad((String)str, (int)2));
            }
            sb.append(Util.LS);
        }
        return sb.toString();
    }

    private static void println(String msg) {
    }
}

